//CODE BY JAKE LORD
//ALL RIGHTS RESERVED BY VOLCKENS GROUP, FORT COLLINS CO
#include "mbed.h"
#include "BLE.h"
#include "UPAS_Service.h"
#include "EEPROM.h"
#include "CronoDot.h"
#include "NCP5623BMUTBG.h"

#include "SDFileSystem.h"
#include "Adafruit_ADS1015.h"
#include "MCP40D17.h"
#include "BME280.h"
#include "Calibration_one.h"

//List of files not currently in this Code
#include "LSM303.h"
#include "SI1145.h"
#include "STC3100.h"
//#include "US_Menu.h"



DigitalOut          blower(p29, 0);
DigitalOut          pbKill(p18, 1);
DigitalOut          GPS_EN(p4,0); 
EEPROM              E2PROM(p22, p20);
CronoDot            RTC(p22, p20);  
NCP5623BMUTBG       RGB_LED(p22, p20);   
Serial              pc(USBTX, USBRX);
LSM303              movementsensor(p22, p20);
SI1145              lightsensor(p22, p20);
STC3100             gasG(p22, p20);
I2C                 i2c(p22, p20);
Adafruit_ADS1115    ads(&i2c);
Calibration         calibrations(7);     //Default serial/calibration if there are no values for the selected option
MCP40D17            DigPot(&i2c);
BME280              bmesensor(p22, p20);

BLE         ble;
/*EEPROM ADDRESSING:
    0:Status bit-Unused
    1-15:Device Name
    16-19:Flow Rate
    20: Data Log Interval
    21-26: Start Time: ssmmHHddMMyy
    27-32: Stop Time: ssmmHHddMMyy
    33: Duty Up
    34: Duty Down
    35-38: Home Latitude
    39-42: Home Longitude
    43-46: Work Latitude
    47-50: Work Longitude
    51: Runready: Currently useless, should be 0
    52-53: Device Calibration
    54: Consider RunReady
    55-56: Menu Options
    57+ Nothing*/

Timeout         stop;   //This is the stop call back object
Timeout         logg;   //This is the logging call back object

uint16_t serial_num = 1;                // Default serial/calibration number
int RunReady =0;


float press;
float temp;
float rh;

int uv;

float compass;
float accel_x;
float accel_y;
float accel_z;
float accel_comp;

int vInReading;
int vBlowerReading;
int omronDiff;
float omronVolt; //V
int omronReading;
float atmoRho; //g/L

float massflow; //g/min
float volflow; //L/min
float volflowSet = 1.0; //L/min
int   logInerval = 10; //seconds

float massflowSet;
float deltaVflow = 0.0;
float deltaMflow = 0.0;
float gainFlow;
float sampledVol; //L, total sampled volume

int digital_pot_setpoint; //min = 0x7F, max = 0x00
int digital_pot_set;
int digital_pot_change;
int digitalpotMax = 127;
int digitalpotMin = 2;

//char filename[] = "/sd/XXXX0000LOG000000000000---------------.txt";
char filename[] = "/sd/UPASLOG00.txt";
SDFileSystem sd(SPIS_PSELMOSI, SPIS_PSELMISO, SPIS_PSELSCK, SPIS_PSELSS, "sd"); // I believe this matches Todd's pinout, let me know if this doesn't work. (p12, p13, p15, p14)


const static char     DEVICE_NAME[] = "UPAS"; //Will hold the actual name of the whichever UPAS is being connected to
static const uint16_t uuid16_list[] = {UPAS_Service::UPAS_SERVICE_UUID}; //Currently a custom 16-bit representation of 128-bit UUID

UPAS_Service *upasServicePtr;



void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)//Code called when mbed ble senses a disconnect
{
    ble.gap().startAdvertising();
}

void periodicCallback(void)
{
    RTC.get_time();
    const uint8_t refreshPassValues[6] = {RTC.seconds, RTC.minutes,RTC.hour,RTC.date,RTC.month,RTC.year};
    ble.updateCharacteristicValue( upasServicePtr->rtcCharacteristic.getValueHandle(),refreshPassValues,6);
    
}
void periodicPrint(void)
{
 //   led1 = !led1; /* Do blinky on LED1 to indicate system aliveness. */
    //RGB_LED.set_led(1,1,5);
    
}

/*
This function is called the BLE GATT Server every time a characterisitic is written to
All logic revolving around which bits to write to EEPROM, and what to see the RTC to us done here
*/
void writeCharacteristicCallback(const GattWriteCallbackParams *params)
{
    uint8_t *writeData =  const_cast<uint8_t*>(params->data);
    // check to see what characteristic was written, by handle
    if(params->handle == upasServicePtr->rtcCharacteristic.getValueHandle()) {

        //ble.updateCharacteristicValue(upasServicePtr->readChar.getValueHandle(),params->data,params->len);
        
        E2PROM.write(0x00015, writeData+6, 12);
        RTC.set_time(writeData[0],writeData[1],writeData[2],writeData[3],writeData[3],writeData[4],writeData[5]);
   
    }else if(params->handle == upasServicePtr->sampleTimeCharacteristic.getValueHandle()){
        
        E2PROM.write(0x00015, writeData, 12);
    
    }else if(params->handle == upasServicePtr->subjectLabelCharacteristic.getValueHandle()){
        E2PROM.write(0x00001,writeData,15);
    
    }else if(params->handle == upasServicePtr->runReadyCharacteristic.getValueHandle()){
        uint8_t runData = writeData[0];
        
        if(runData == 10){
             RunReady = 10;
             RGB_LED.set_led(1,2,3);
        }else{ 
             RunReady = 2;
        }
    
    }else if(params->handle == upasServicePtr->runModeCharacteristic.getValueHandle()){
        /* Trigger demo mode*/
        RGB_LED.set_led(3,1,0);
        E2PROM.write(0x00036,writeData,1);
    }
}

void log_data()
{
    //logg.detach();
    //logg.attach(&log_data, logInerval);     // reading and logging data must take significintly less than 0.5s. This can be increased.
    RGB_LED.set_led(0,0,0);
     RTC.get_time();
    //*****************************************//
    //RTC.get_time(); //debug
    //pc.printf("%02d:%02d:%02d on %d/%d/%d before fmod  \r\n",RTC.hour, RTC.minutes, RTC.seconds, RTC.month, RTC.date, RTC.year);//debug
    //*****************************************//
    
    
   
   /* while(fmod(secondsD,logInerval)!=0 || floor(secondsD)==floor(lastsecondD)) {
       //pc.printf("%f, %f\r\n", floor(secondsD), floor(lastsecondD)); 
        RTC.get_time();
        secondsD = RTC.seconds;
        wait_ms(100);
    }
    lastsecondD = secondsD;
    */
    //*****************************************//
    //RTC.get_time(); //debug
    //pc.printf("%02d:%02d:%02d on %d/%d/%d after fmod \r\n",RTC.hour, RTC.minutes, RTC.seconds, RTC.month, RTC.date, RTC.year);//debug
    //*****************************************//
    DigPot.writeRegister(digital_pot_setpoint);
    omronReading = ads.readADC_SingleEnded(0, 0xC583); // read channel 0 PGA = 2 : Full Scale Range = 2.048V
    omronVolt = (omronReading*4.096)/(32768*2);
      
    vInReading = ads.readADC_SingleEnded(1, 0xD583); // read channel 0
    vBlowerReading = ads.readADC_SingleEnded(2, 0xE783); // read channel 0
    omronDiff = ads.readADC_Differential(0x8583); // differential channel 2-3
    press = bmesensor.getPressure();
    temp = bmesensor.getTemperature()-5.0;
    rh = bmesensor.getHumidity();
    uint16_t fuel = gasG.getCounter();
    

    
    FILE *fp = fopen(filename, "a");
    fprintf(fp, "%02d,%02d,%02d,%02d,%02d,%02d,",RTC.year, RTC.month,RTC.date,RTC.hour,RTC.minutes,RTC.seconds);
        fprintf(fp, "%1.3f,%1.3f,%2.2f,%4.2f,%2.1f,%1.3f,", omronVolt,massflow,temp,press,rh,atmoRho);
        fprintf(fp, "%1.3f,%5.1f,%1.1f,%1.1f,%1.1f,%1.1f,", volflow, sampledVol, accel_x, accel_y, accel_z, accel_comp);
        fprintf(fp, "%.1f,", compass);
        fprintf(fp, "%d," ,uv);
        fprintf(fp, "%d,%d,%d,%d,%d," ,omronReading, vInReading, vBlowerReading, omronDiff,gasG.getAmps());
        fprintf(fp, "%d,%d,%d,%1.3f,%1.3f,", gasG.getVolts(), gasG.getCharge(),digital_pot_set, deltaMflow, deltaVflow);
    fclose(fp);
    wait(5);
    RGB_LED.set_led(0,1,0);

    
}


int main(void)
{
    Ticker ticker;
    ticker.attach(periodicPrint, 600); //currently unused. But do not want to comment out
    RGB_LED.set_led(1,1,1);
    RTC.get_time();
    uint8_t rtcPassValues[6] = {RTC.seconds, RTC.minutes,RTC.hour,RTC.date,RTC.month,RTC.year};
    uint8_t sampleTimePassValues[12] = {0,};
    uint8_t subjectLabelOriginal[15] = {0,};
    E2PROM.read(0x00015, sampleTimePassValues, 12);
    E2PROM.read(0x00001, subjectLabelOriginal,15);

    ble.init();
    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(writeCharacteristicCallback); //add writeCharCallback (custom function) to whenever data is being written to device
    UPAS_Service upasService(ble, false,rtcPassValues,sampleTimePassValues,subjectLabelOriginal); //Create a GattService that is defined in UPAS_Service.h
    upasServicePtr = &upasService; //Create a pointer to the service (Allows advertisement without specifically adding the service

    /* setup advertising 
    Following lines do the follow:
        1:Declare the device as Bluetooth Smart(Low-Energy)
        2.Advertise the UPAS service that will send and receive the 57-bits of settable values in the UPAS EEPROM
        3.Advertise the name that will be associated with the UPAS
        4.Allow the UPAS to advertise unrestricted (this might change) */
        
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(30); /* 160ms. */
    ble.gap().startAdvertising();
    
    //Loop keeps device in infinite loop waiting for events to occur
    while (1) {
        ble.waitForEvent();
        if(RunReady==2 && blower ==0){ //Code used to see if one-click run should begin
            calibrations.initialize(serial_num);
            RGB_LED.set_led(3,0,2);
            blower=1;
            RunReady=0;
            break;
         }
         if(RunReady==2 && blower ==1){ //Code used to see if one-click run is done.
            blower=0;
            RunReady=0;
         }
         
        if(RunReady==10){ //Check to see if app is done with configurations
           blower = 0;
           ble.gap().stopAdvertising();
           //break;
       }
    }
    uint8_t startAndEndTime[12] = {0,}; 
    E2PROM.read(0x00015, startAndEndTime, 12); //Grab start and end times from EEPROM
    while(!RTC.compare(startAndEndTime[0], startAndEndTime[1], startAndEndTime[2], startAndEndTime[3], startAndEndTime[4], startAndEndTime[5])) {  // this while waits for the start time by looping until the start time
            wait(0.5);
            RTC.get_time(); 

        }
    calibrations.initialize(serial_num);
    blower=1;
    
    while(!RTC.compare(startAndEndTime[6], startAndEndTime[7], startAndEndTime[8], startAndEndTime[9], startAndEndTime[10], startAndEndTime[11])) { //Waits for end time
        wait(0.5);
        RTC.get_time(); 

    }
    //pbKill = 0; // this is were we shut everything down
    
    RGB_LED.set_led(1,0,0);
    //The filename creation isn't working...
    /*
      for (uint8_t i = 0; i < 100; i++) {
      filename[11] = i/10 + '0';
      filename[12] = i%10 + '0';
      FILE *fp = fopen(filename, "r");
      if (fp == NULL) {
      // only open a new file if it doesn't exist
      FILE *fp = fopen(filename, "w");
      fclose(fp);
      break;  // leave the loop!
                    } 
    }
    */
    wait(10);
       RGB_LED.set_led(0,0,1);
       
       wait(10);
    
    while(1) {
    
       
        log_data();
        }

}
