#include "mbed.h"
#include "rtos.h"
#include "MyAxis.h"


extern Serial pc;
extern float DeadBand;
extern bool scoping;
extern int scope_duration;
extern int scope_time;
extern bool sinusoid;
extern bool ratiocalc;
extern float jogaccel_time;
extern float jogaccel;
extern int pos_enc_start;
extern int run_count_jog;
extern int primed;
float temp;


// Returns the new set point entered via the keyboard
int ServiceKeyboard ()
{
    int key;                                            // The keypress by the user
    int value = 0;                                      // The variable to return

    key = pc.getc();                                    // Read the intial keypress

    switch (key)   {
// List keypresses used:
        case 'q':
            // To move up and down: 8, 2:  To move left and right 4,6. To start stop both: 5:
            pc.printf("\n\r Left, Right, Up Down:  4,6,8,2.  \n\r Start & Stop both: 5 \n\r Toggle all directions = d \n\r");
            pc.printf("\n\r Scope = s \n\r Run Test sinusoid = t \n\r Run Ratio Calculator = r \n\r Set Motor Kp = g \n\r Set Sys Kp_Sys = h \n\r Fetch Gain = f \n\r Set Kff_Sys = k \n\r Prime Start Scope = p \n\r Set Kff = 2 \n\r Set Gearbox Ratio = 1  \n\r");
            pc.printf(" Set Stationary c value = c \n\r Set Moving c value = b \n\r Set Jog_2 value = 3 \n\r \n\r \n\r Jog Speed PAN,TILT = j,m \n\r Set Jog Acceleration = a \n\r Cycle to hard Stop = z \n\r Fade = x \n\r");
            break;

// Turn on Scope Tool:
        case 's':
            if (!scoping) {
                scope_time = 0;
                scoping = true;
            } else {
                scoping = false;
            }
            break;
// Turn on Ratio Calculator:
        case 'r':
            if (!ratiocalc) {
                ratiocalc = true;
                pc.printf("\n\r Running Ratio Calculator");
            } else {
                Tilt.calcmyratio = false;
                Pan.calcmyratio = false;
            }
            break;
// We are going to jog Tilt up
        case '8':
            Tilt.sysjogdir = -1;
            if (Tilt.moveme) {
                //pc.printf("\n\r Moving stop");
                Tilt.moveme = false;
            } else {
                //pc.printf("\n\r Moving Start");
                Tilt.moveme = true;
            }
            break;
// We are going to jog Tilt down
        case '2':
            Tilt.sysjogdir = 1;
            if (Tilt.moveme) {
                //pc.printf("\n\r Moving stop");
                Tilt.moveme = false;
            } else {
                //pc.printf("\n\r Moving Start");
                Tilt.moveme = true;
            }
            break;
// We are going to jog Tilt up
        case '4':
            Pan.sysjogdir = -1;
            if (Pan.moveme) {
                //pc.printf("\n\r Moving stop");
                Pan.moveme = false;
            } else {
                //pc.printf("\n\r Moving Start");
                Pan.moveme = true;
            }
            break;
// We are going to jog Tilt down
        case '6':
            Pan.sysjogdir = 1;
            if (Pan.moveme) {
                //pc.printf("\n\r Moving stop");
                Pan.moveme = false;
            } else {
                //pc.printf("\n\r Moving Start");
                Pan.moveme = true;
            }
            break;
// We are going to jog everything
        case '5':
            if (Pan.moveme) {
                //pc.printf("\n\r Moving stop");
                Pan.moveme = false;
            } else {
                //pc.printf("\n\r Moving Start");
                Pan.moveme = true;
            }
            if (Tilt.moveme) {
                //pc.printf("\n\r Moving stop");
                Tilt.moveme = false;
            } else {
                //pc.printf("\n\r Moving Start");
                Tilt.moveme = true;
            }
            break;
// We are going to toggle all directions
        case 'd':
            Pan.sysjogdir = -Pan.sysjogdir;
            Tilt.sysjogdir = -Tilt.sysjogdir;
            break;

// Turn on Potentiometer control:
        case 't':
            if (!sinusoid) {
                pc.printf("\n\r Running sinusoid test");
                sinusoid = true;
            } else {
                sinusoid = false;
            }
            break;
// We are going to set the Motor gain
        case 'g':
            pc.printf("\n\r Enter a new Motor Kp gain x 1000: ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            Pan.Kp = value;
            Pan.Kp = Pan.Kp / 1000;
            Tilt.Kp = Pan.Kp;
            //PanVelocityPID.setKp(Kp/1000);
            pc.printf("\n\r");
            break;
// We are going to set the System gain
        case 'h':
            pc.printf("\n\r Enter a new System Sys_Kp gain x 10000: ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            Pan.Kp_Sys = value;
            Pan.Kp_Sys = Pan.Kp_Sys / 10000;
            Tilt.Kp_Sys = Pan.Kp_Sys;
            //PanVelocityPID.setKp(Kp/1000);
            pc.printf("\n\r");
            break;
// We are going to confirm what the gain is
        case 'f':
            //Kp = PanVelocityPID.getKp();
            pc.printf("\n\r Kp = %f, Kff = %f, Kp_Sys = %f, Kff_Sys = %f, Ratio = %f, c_stationary = %f, c_moving = %f, Jog_2 = %f \n\r", Pan.Kp,Pan.Kff,Pan.Kp_Sys,Pan.Kff_Sys,Pan.ratio,Pan.c_stationary, Pan.c_moving, Pan.Jog_2);
            break;

// We are going to set the Jog_2 Value:
        case '3':
            pc.printf("\n\r Enter a new Jog_2 value: ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            Pan.Jog_2 = value;
            pc.printf("\n\r");
            break;
// We are going to set the new threshold:
        case '1':
            pc.printf("\n\r Enter a new gearbox ratio: ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            Pan.ratio = value;
            pc.printf("\n\r");
            break;
// We are going to set the Kff gain
        case 'w':
            pc.printf("\n\r Enter a new Kff gain x 100: ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            Pan.Kff = value;
            Pan.Kff = Pan.Kff / 100;
            pc.printf("\n\r");
            break;
// We are going to set the dead band for the Motor PWM
        case 'k':
            pc.printf("\n\r Enter a new Kff_Sys x 100: ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            temp = value;
            Pan.Kff_Sys = temp / 100;
            pc.printf("\n\r");
            break;
// We are going to set a stationary c value
        case 'c':
            pc.printf("\n\r Enter a new stationary c value: ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            Pan.c_stationary = value;
            pc.printf("\n\r");
            break;
// We are going to set a moving b value
        case 'b':
            pc.printf("\n\r Enter a new moving c value: ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            Pan.c_moving = value;
            pc.printf("\n\r");
            break;
//  Set a jog speed
        case 'j':
            pc.printf("\n\r Set Jog PAN speed (Deg/s) x100 ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            Pan.jog = value;
            Pan.jog = (Pan.jog * 0.0145);
            pc.printf("\n\r");
            break;
//  Set a jog speed
        case 'm':
            pc.printf("\n\r Set Jog TILT speed (Deg/s) x100 ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            Tilt.jog = value;
            Tilt.jog = (Tilt.jog * 0.0145);
            pc.printf("\n\r");
            break;
// Set the jog function to cycle to a stop
        case 'z':
            pc.printf("\n\r Set to ramp to stop \n\r");
            Pan.ramp = Pan.jog / jogaccel_time;
            Pan.run_count_jog = 0;
            scope_time = 0;
            Pan.setramp = true;
            break;
// Set a Fade like move
        case 'x':
            pc.printf("\n\r Set to Fade like move \n\r");
            Pan.ramp = Pan.jog / jogaccel_time;
            Pan.run_count_jog = 0;
            scope_time = 0;
            Pan.setramp_x = true;

            Tilt.ramp = Tilt.jog / jogaccel_time;
            Tilt.run_count_jog = 0;
            scope_time = 0;
            Tilt.setramp_x = true;
            break;
//  Set a jog acceleration
        case 'a':
            pc.printf("\n\r Set ramp jogaccel_time, (ms) ");
            //key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            temp = value;
            jogaccel_time = temp;
            //ramp = ramp / 1000;
            pc.printf("\n\r");
            break;
//  Prime the scope tool
        case 'p':
            pc.printf("\n\r Prime the scope tool \n\r");
            primed = true;
            break;
    }
    return(1);
}





