#include "mbed.h"
#include "CradleFluidics.h"
#include "CradleUI.h"

DigitalOut myled(PC_13);
DigitalOut rst(PB_10);

CradleFluidics fluids(PB_4, PA_8, 0x01, PB_1, PC_7, PC_6);

CradleUI ui(PB_15, PB_14, PB_13, PA_15, PB_12, PC_0, PC_1, PC_2);

int main() {
    
    rst = 1;
    wait_ms(50);
    rst = 0;
    wait_ms(200);
    rst = 1;
    wait_ms(100);
    printf("Completed Reset\r\n");
    
    for (int x = 0; x<5; x++)
    {
        myled = !myled;
        wait_ms(250);
    }
    
    ui.screen.screen.font_ptrs(ptr_font_8x16, ptr_font_6x8);
    ui.screen.set_logo_ptr(ptr_overture_logo);
    ui.screen.init();
    
    ui.screen.embryologist("Tamara Martin");
   
    fluids.init();
    
    wait_ms(250);
    fluids.solenoids.open_all();
    wait_ms(250);
    
    int positive_ports[] = {1,3,5,3};
    int negative_ports[] = {2,8,2,8};
    
    float rate = 0.3;
    
    fluids.channels.move_angle(true, 36);  //Make 54 degress or similar
    while(1){
        
        for(int i = 0; i < 4; i = i + 2){
            fluids.solenoids.route_to_reagent_port(positive_ports[i]);
            fluids.solenoids.set_all_high_z();
            fluids.pump2 = rate;
            for(int n = 0; n<7; n++){
                fluids.channels.move_angle(true, 18);
                wait_ms(250);
            }
            fluids.channels.move_angle(true, 36);  //72 degress
            wait_ms(200);
            fluids.pump2 = 0;
            fluids.solenoids.route_to_reagent_port(positive_ports[i+1]);
            fluids.pump2 = rate;
            for(int n = 0; n<8; n++){
                fluids.channels.move_angle(true, 18);
                wait_ms(250);
            }
            fluids.pump2 = 0;
            fluids.channels.home();
            fluids.solenoids.set_all_high_z();
            
        }
    }
}
