#include "mbed.h"
#include "CAN.h" // we need to include CAN library
AnalogIn poignee(p15);

Ticker TickCan;     // ticker call every 100 ms.
CAN can1(p30,p29);  // define can 1 with p30 (rx) and p29 (tx)

char Poignee;

void send()     // function executed every 100 ms to send the gaz value
{

    Poignee=poignee.read()*100;  // *100 for the communication

    printf("send()\n\r");
    led1 = !led1; // led is blinking when a message is send

    if(can1.write(CANMessage(1337, &Poignee, 1))) { // 1337 = ID
        printf("Message sent: %f\n",poignee.read());
    }

}

int main()                      // Start main ()
{
    printf("main()\n");
    TickCan.attach(&send, 0.1);     // ticker attach to the function "send" every 100ms
    CANMessage msg;
    while(1) {
        printf("Message received: %d\n", msg.data[0]);
        wait(0.2);
    }
}