/*
APP1 S5 info
Author : lemy2301 and gagv2103
*/

#include "mbed.h"
#include "acceleroMMA8452Q.h"
#include "customUART.h"

Serial pc(USBTX, USBRX);
CustomUART afficheur;
//Serial afficheur(p9, p10);

void display2decimal(int number);


int main() {
    Accelero accelero(100000);

    while(1) {
        vector acceleroVector = accelero.getAccelVector();
        
        pc.printf("X: %i \n\r", acceleroVector.x);
        pc.printf("Y: %i \n\r", acceleroVector.y);
        pc.printf("Z: %i \n\n\r", acceleroVector.z);
        
        display2decimal(accelero.getAngle());
        wait(0.2);
    }
}

//Affiche automatique un nombre avec 2 dgits
//Pour display 12.35 il faut envoyer 1235
void display2decimal(int number)
{
    int digit1 = number / 1000;
    int rest = number - digit1 * 1000;
    int digit2 = rest / 100;
    rest -= digit2 * 100;
    int digit3 = rest / 10;
    rest -= digit3 * 10;
    int digit4 = rest;
    
    //Put the cursor at the first digit
    afficheur.putc(0x79);
    afficheur.putc(0x00);
    
    //Write 2 first digits
    afficheur.putc(digit1);
    afficheur.putc(digit2);
    
    //Add the dot after two digit
    afficheur.putc(0x77);
    afficheur.putc(0b00000010);
    
    //Write the last two digits
    afficheur.putc(digit3);
    afficheur.putc(digit4);
}
