/*
APP1 S5 info
Author : lemy2301 and gagv2103
*/

#include "customUART.h"

CustomUART::CustomUART()
{   
    //Choose the right pin for UART3 port (STEP5)
    volatile int* PINSEL0 = (volatile int*)0x4002C000;
    *PINSEL0 = *PINSEL0 | 0b10 | (0b10 << 2);
    
    //Select the good clock to configure the baud rate (STEP2)
    volatile int* PCLKSEL1 = (volatile int*)0x400FC1AC;
    *PCLKSEL1 = *PCLKSEL1 | (0b01 << 18);
    
    //Enable the UART3 port (STEP1)
    volatile int* PCONP = (volatile int*)0x400FC0C4;
    *PCONP = *PCONP | (0b1 << 25);
    
    //Enable clock division to have good baud rate (STEP3)
    volatile int* U3LCR = (volatile int*)0x4009C00C;
    volatile int* U3DLL = (volatile int*)0x4009C000;
    volatile int* U3DLM = (volatile int*)0x4009C004;
    *U3LCR = *U3LCR | (0b1 << 7);
    *U3DLM = 0x02;
    *U3DLL = 0x71;
    *U3LCR = 0b11;

    //Enable the UART FIFO (STEP4)
    volatile int* U3FCR = (volatile int*)0x4009C008;
    *U3FCR = *U3FCR | 0b1;
    
    //Set the pointer for the writting process
    U3THR = (volatile int*)0x4009C000;
}

void CustomUART::putc(const char caracter)
{
    //Write the caracter on the register
    *U3THR = caracter;
}
    