/*
APP1 S5 info
Author : lemy2301 and gagv2103
*/

#ifndef ACCELEROMMA8452Q_H
#define ACCELEROMMA8452Q_H

#include "mbed.h"

const int ACCELERO_WRITE_ADRESS = 0x3A;
const int ACCELERO_READ_ADRESS  = 0x3B;

const char ACCELERO_REGISTER_WHO_AM_I = 0x0D;
const char ACCELERO_RESPONSE_WHO_AM_I = 0x2A;

const char ACCELERO_REGISTER_CTRL_REG1 = 0x2A;
const char ACCELERO_REGISTER_CTRL_REG2 = 0x2B;

const char ACCELERO_REGISTER_HP_FILTER_CUTOFF = 0x0F;

const char ACCELERO_REGISTER_OUT_X_MSB = 0x01;

struct vector{
    int x;
    int y;
    int z;
};

class Accelero
{
    public:
        Accelero(int frequency);
        
        vector getAccelVector();
        int    getAngle();
        
    private:
        void init(int frequency);
        int  getSignedNumber(int rawValue);
        
        I2C  i2cPort;
};


#endif