#include "mbed.h"
#include "x_nucleo_iks01a1.h"
#include <iostream>
#include <string>
#include <sstream>
using namespace std;
DigitalOut led1(LED1);
int cinput;

static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;
// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)




int main() {
    
  char buffer2[32];
  int32_t axes[3];
    Serial pc(USBTX, USBRX);
    DevI2C i2c(D14, D15);
    HTS221 htsensor(i2c);
    LPS25H barosensor(i2c);
    
    uint8_t sensor_id;
    int status = htsensor.ReadID(&sensor_id);
    if (status || sensor_id != I_AM_HTS221) {
        pc.printf("No HT sensor (status = %d id = %02x?\n", status, sensor_id);
    }
    HUM_TEMP_InitTypeDef htInitState = {
        .OutputDataRate = HTS221_ODR_7Hz, // This is the only one used by the init
    };
    status = htsensor.Init(&htInitState);
    if (status) {
        pc.printf("HT init fails!\n");
    }
    
    status = barosensor.ReadID(&sensor_id);
    if (status || sensor_id != I_AM_LPS25H) {
        pc.printf("No Barosensor (status = %d id = %02x?\n", status, sensor_id);
    }
    
    PRESSURE_InitTypeDef baroInitState = {
        // These are used in the initialization
        .OutputDataRate = LPS25H_ODR_7Hz,
        .DiffEnable = LPS25H_DIFF_DISABLE,
        .BlockDataUpdate = LPS25H_BDU_CONT,
        .SPIMode = LPS25H_SPI_SIM_4W
    };
    status = barosensor.Init(&baroInitState);
    if (status) {
        pc.printf("Baro init fails!\n");
    }
    
  
    Thread::wait(5000);
    pc.printf("Connecting...\n\r");
    led1 = !led1;
        float temperature = 0.0;
        status = htsensor.GetTemperature(&temperature);
        float humidity = 0.0;
        status |= htsensor.GetHumidity(&humidity);
        float pressure = 0.0;
        status |= barosensor.GetPressure(&pressure);
        float temperatureB = 0.0;
        status |= barosensor.GetTemperature(&temperatureB);
        pc.printf("Status = %d T = %.1f C RH = %.1f%% | T = %.1f C P = %.1f mbar\n\r", 
            status, temperature, humidity, temperatureB, pressure);
        printf("---\r\n");

    magnetometer->Get_M_Axes(axes);
    printf("LIS3MDL [mag/mgauss]:  %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);

    accelerometer->Get_X_Axes(axes);
    printf("LSM6DS0 [acc/mg]:      %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);

    gyroscope->Get_G_Axes(axes);
    printf("LSM6DS0 [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
    
    printf("Starting again..");

    while (true) {
            
    printf("Enter sensor name(1 for temperature, 2 for humidity, 3 for pressure ): \r\n");
   
        Thread::wait(1500);
        // pc.printf("IP address %s\n", wifiIf.get_ip_address());
        

        printf("Enter 1 for heat, humidity and pressure \n\r ");
        printf("Enter 2 for acceleration, gyroscope, magnitude \n\r ");
        
    scanf("%i", &cinput);
    if((cinput==1)){
            printf("[Temperature] %f\n\r",temperature);
            printf("[Humidity] %f\n\r",humidity);
            printf("[Pressure] %f\n\r",pressure);
            }
    if((cinput==2)){
            magnetometer->Get_M_Axes(axes);
    printf("[Magnetism] [mag/mgauss]:  %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);

    accelerometer->Get_X_Axes(axes);
    printf("[Acceleration] [acc/mg]:      %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);

    gyroscope->Get_G_Axes(axes);
    printf("[Gyroscope] [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
            }        
   
    }
}

