/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2012 - 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/**************************************************************************//**
* @file         lcd_vklcd70rt_ch0.h
* @version      1.00
* $Rev: 199 $
* $Date:: 2014-05-23 16:33:52 +0900#$
* @brief        LCD panel for vdc5 channel 0 definition header
******************************************************************************/

#ifndef LCD_VKLCD70RT_CH0_H
#define LCD_VKLCD70RT_CH0_H

#ifndef LCD_PANEL_H
#error  Do not include this file directly!
#else
/******************************************************************************
Includes   <System Includes> , "Project Includes"
******************************************************************************/
#include    <stdlib.h>

#include    "r_typedefs.h"

#include    "r_vdc5.h"


/******************************************************************************
Macro definitions
******************************************************************************/
#define     LCD_CH0_DISP_HS         (160u)                      /* LCD display area size, horizontal start position */
#define     LCD_CH0_DISP_HW         (1024u)                     /* LCD display area size, horizontal width */
#define     LCD_CH0_DISP_VS         (18u)                       /* LCD display area size, vertical start position */
#define     LCD_CH0_DISP_VW         (600u)                      /* LCD display area size, height (vertical width) */
#define     LCD_CH0_SIG_FV          (635u - 1u)                 /* Free-running Vsync period */
#define     LCD_CH0_SIG_FH          (1344u - 1u)                /* Hsync period */
/* Pixel data is latched in the falling edge of pixel clock.
   Therefore, pixel data should be output from VDC5 at the rising edge of the clock. */
#define     LCD_CH0_OUT_EDGE        VDC5_EDGE_RISING            /* Output phase control of LCD_DATA[23:0] signal */
#define     LCD_CH0_OUT_FORMAT      VDC5_LCD_OUTFORMAT_RGB888   /* LCD output format select */

#define     LCD_CH0_PANEL_CLK       VDC5_PANEL_ICKSEL_LVDS_DIV7 /* Panel clock select */
#define     LCD_CH0_PANEL_CLK_DIV   VDC5_PANEL_CLKDIV_1_2       /* Panel clock frequency division ratio */

#define     LCD_CH0_TCON_HALF       (LCD_CH0_SIG_FH / 2u)       /* TCON reference timing, 1/2fH timing */
#define     LCD_CH0_TCON_OFFSET     (0u)                        /* TCON reference timing, offset Hsync signal timing */

#define     LCD_CH0_INITIAL_DC      30

#define     LCD_CH0_EXP_ADDR        0x80
#define     LCD_CH0_CALIB_ADDR      0x90
/******************************************************************************
Typedef definitions
******************************************************************************/
enum CONTROL_BIT__ {
   RGB_DATA = 0,
   M666_888,
   L_R_SCAN,
   U_D_SCAN,
   BL_EN   ,
   RESET_CTP,
//-----------
   MAXBITS
};

enum CONTROL_REG__ {
   PORTMODE = 0,
   OUTPUT,
   INPUT,
   PWM_DC,
   PWM_DIV,
   PWM_T,
//-----------
   MAXREGS
};

typedef union __IOEXP
{
  struct __CONTROL
  {
    uint8_t portmode;
    uint8_t output;
    uint8_t input;
    uint8_t PWM_dc;
    uint8_t PWM_div;
    uint8_t PWM_t;
  }regs;
  
  uint8_t reg[sizeof(struct __CONTROL)];
}ioexp_t;

/******************************************************************************
Exported global functions (to be accessed by other files)
******************************************************************************/
void GRAPHICS_SetLcdPanel_Ch0(void);
void GRAPHICS_SetLcdTconSettings_Ch0(const vdc5_lcd_tcon_timing_t * * const outctrl);


#endif  /* LCD_PANEL_H not defined */
#endif  /* LCD_VKLCD70RT_CH0_H */

