/*
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
 
#ifndef RGA_FUNC_H
#define RGA_FUNC_H

#include "RGA.h"
#include "lcd_panel.h"

typedef struct {
    char * style;
    int x;
    int y;
    int w;
    int h;
} draw_rectangle_pos_t;

typedef enum {
	MANUAL_INTERACT,
	AUTO_INTERACT
}interact_t;

#if (LCD_VDC5_CH0_PANEL == LCD_CH0_PANEL_VKLCD70RT)
 #define IMG_DRAW_WIDTH                      (518)
 #define IMG_DRAW_HEIGHT                     (322)
 #define IMAGE_WIDTH_SCROLL_FUNC             (835)      // Image width of Scroll function
 #define IMAGE_HEIGHT_SCROLL_FUNC            (322)      // Image height of Scroll function
 #define IMAGE_WIDTH_ZOOM_FUNC               (518)      // Image width of Zoom function
 #define IMAGE_HEIGHT_ZOOM_FUNC              (322)      // Image height of Zoom function
 #define CRYSTAL_DIAMETER                    (119)
 #define SLIDE_WIDTH                         (106)
 #define NO_DEV_X							 (285)
 #define NO_DEV_Y							 (75)
#else
 #define IMG_DRAW_WIDTH                      (235)
 #define IMG_DRAW_HEIGHT                     (146)
 #define IMAGE_WIDTH_SCROLL_FUNC             (379)      // Image width of Scroll function
 #define IMAGE_HEIGHT_SCROLL_FUNC            (146)      // Image height of Scroll function
 #define IMAGE_WIDTH_ZOOM_FUNC               (235)      // Image width of Zoom function
 #define IMAGE_HEIGHT_ZOOM_FUNC              (146)      // Image height of Zoom function
 #define CRYSTAL_DIAMETER                    (55)
 #define SLIDE_WIDTH                         (50)
 #define NO_DEV_X							 (128)
 #define NO_DEV_Y 							 (24)
#endif

#define DISSOLVE_MAX_NUM                    (256)
#define SCROLL_MAX_NUM                      (IMAGE_WIDTH_SCROLL_FUNC - IMG_DRAW_WIDTH)
#define ZOOM_MAX_NUM                        (IMAGE_HEIGHT_ZOOM_FUNC / 2)
#define ROTATION_MAX_NUM                    (360)
#define ACCELERATE_MAX_NUM                  (256)

#define ANIMATION_TIMING_EASE               (0)
#define ANIMATION_TIMING_LINEAR             (1)
#define ANIMATION_TIMING_EASE_IN            (2)
#define ANIMATION_TIMING_EASE_OUT           (3)
#define ANIMATION_TIMING_EASE_IN_OUT        (4)

extern void Set_RGAObject(frame_buffer_t* frmbuf_info);
extern void RGA_Func_DrawFullScreen(frame_buffer_t* frmbuf_info, const graphics_image_t *image);
extern void RGA_Func_DrawRectangle(frame_buffer_t* frmbuf_info, draw_rectangle_pos_t * pos, int pos_num);
extern void RGA_Func_DrawImage(frame_buffer_t* frmbuf_info, int x, int y);
extern void RGA_Func_Dissolve(frame_buffer_t* frmbuf_info, float32_t global_alpha, interact_t mode);
extern void RGA_Func_Scroll(frame_buffer_t* frmbuf_info, int src_width_pos, interact_t mode);
extern void RGA_Func_Zoom(frame_buffer_t* frmbuf_info, int src_height_pos, interact_t mode);
extern void RGA_Func_Rotation(frame_buffer_t* frmbuf_info, graphics_matrix_float_t image_angle, interact_t mode);
extern void RGA_Func_Accelerate(frame_buffer_t* frmbuf_info, int animation_timing, float32_t relative_pos);
extern void Rotor(frame_buffer_t* frmbuf_info, graphics_matrix_float_t image_angle);

extern void RGA_Func_DrawCamScreen(uint8_t* cam_buffer);
extern void RGA_Func_DrawPNG(frame_buffer_t* frmbuf_info, const graphics_image_t* png_img, int x, int y);
extern bool RGA_Func_CheckPorts(frame_buffer_t* frmbuf_info, bool rca_pluged, bool usb_pluged);
extern void RGA_Func_Rotor(frame_buffer_t* frmbuf_info, graphics_matrix_float_t image_angle, interact_t mode, graphics_image_t *image);
extern void RGA_Func_Axel(frame_buffer_t* frmbuf_info, int animation_timing, float32_t relative_pos, graphics_image_t* image);
extern void RGA_Func_Zo(frame_buffer_t* frmbuf_info, int src_height_pos, interact_t mode, graphics_image_t* image);
extern void RGA_Func_Scr(frame_buffer_t* frmbuf_info, int src_width_pos, interact_t mode, graphics_image_t* image);
extern void RGA_Func_Diss(frame_buffer_t* frmbuf_info, float32_t global_alpha, interact_t mode, graphics_image_t* image);
#endif

