
#ifndef LCD_CFG_H
#define LCD_CFG_H

#include "DisplayBace.h"
#include "lcd_panel.h"

/* LCD Parameter */
#define LCD_INPUT_CLOCK                     (66.67)
#if (LCD_VDC5_CH0_PANEL == LCD_CH0_PANEL_VKLCD70RT)
  #define LCD_OUTPUT_CLOCK                  (51.2f)
#else
  #define LCD_OUTPUT_CLOCK                  (9.52f)
#endif
#define LCD_PIXEL_WIDTH                     LCD_CH0_DISP_HW
#define LCD_PIXEL_HEIGHT                    LCD_CH0_DISP_VW
#define LCD_H_BACK_PORCH                    (LCD_CH0_SIG_FH - (LCD_CH0_DISP_HW + LCD_CH0_DISP_HS))
#define LCD_H_FRONT_PORCH                   LCD_CH0_DISP_HS
#define LCD_H_SYNC_WIDTH                    (0u)
#define LCD_V_BACK_PORCH                    (LCD_CH0_SIG_FV - (LCD_CH0_DISP_VW + LCD_CH0_DISP_VS))
#define LCD_V_FRONT_PORCH                   LCD_CH0_DISP_VS
#define LCD_V_SYNC_WIDTH                    (0u)

extern const DisplayBase::lcd_config_t LcdCfgTbl;

#endif

