/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2012 - 2014 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/******************************************************************************
* $FileName: clib_samples.c $
* $Module: CLibCommon $ $PublicVersion: 1.00 $ (=CLIB_VERSION)
* $Rev: 52 $
* $Date:: 2014-03-20 18:41:05 +0900#$
* Description: Sample functions
*******************************************************************************/


/******************************************************************************
Includes   <System Includes> , "Project Includes"
*******************************************************************************/
#include  "Project_Config.h"
#include  "r_typedefs.h"
#include  "r_ospl.h"
#include  "clib_samples.h"
#if ! IS_VDC_SAMPLE_VRAM_USED
#include  "clib_samples_private.h"
#endif


/******************************************************************************
Typedef definitions
******************************************************************************/

/******************************************************************************
Macro definitions
******************************************************************************/

/******************************************************************************
Imported global variables and functions (from other files)
******************************************************************************/

/******************************************************************************
Exported global variables and functions (to be accessed by other files)
******************************************************************************/

/******************************************************************************
Private global variables and functions
******************************************************************************/

/******************************************************************************
* Function Name: [R_Sample_GetBigMemory]
* Description  :
* Arguments    :
* Return Value : Error code, 0=No error
******************************************************************************/
errnum_t  R_Sample_GetBigMemory( uint8_t **const  out_Address,  size_t *const  out_Size )
{
#if IS_VDC_SAMPLE_VRAM_USED
    errnum_t          e;
    static uint8_t   *address;
    static size_t     memory_size;

    IF_DQ( out_Address == NULL ) {
        e=E_OTHERS;
        goto fin;
    }
    IF_DQ( out_Size    == NULL ) {
        e=E_OTHERS;
        goto fin;
    }

    if ( address == NULL ) {
        e= R_Sample_GetBigMemory_FromVDC_Sample( &address, &memory_size );
        IF(e!=0) {
            goto fin;
        }
    }
    *out_Address = address;
    *out_Size    = memory_size;

    e=0;
fin:
    return  e;
#else
    R_MEMORY_SECTION_GetMemory_ClibSamplesC( out_Address, out_Size );
    return  0;
#endif
}



