#ifndef __WDT_MANAGER_H__
#define __WDT_MANAGER_H__

#include "EthernetInterface.h"
#include "mbed.h"
#include "wdt.h"

extern Watchdog wdt;
extern Timer wdt_timer;

extern UDPSocket udp_wdt_client;
const uint16_t EXTERNAL_WDT_SERVER_PORT = 9395;
const uint16_t EXTERNAL_WDT_HEADER_PORT = 6612;
const uint8_t MIN_CBX_IN_A_BRANCH = 2;
    
inline int init_wdt ()
{
  wdt.Configure ( 30.0 );
  wdt_timer.start ();
  return ( 0 );
}

inline int init_external_wdt() 
{
  udp_wdt_client.set_blocking( false, 0 );
  return ( udp_wdt_client.bind( 6612 ) );
}

inline void reconnect_extern_wdt_socket()
{
  udp_wdt_client.close();
  udp_wdt_client.bind( 6612 );
  udp_wdt_client.set_blocking( false, 0 );
}

#endif