%: include "vz_stdio.h"

Serial serial_pc ( USBTX, USBRX );

UDPSocket udp_client;

Endpoint udp_server;

TCPSocketServer tcp_server;

TCPSocketConnection tcp_client;

bool debug_io_eth = false;

bool udp_request = false;

bool udp_query = false;

bool tcp_session = false;

bool from_eth = false;

char io_msg1 [ IO_MSG_SIZE + IO_AUX_MSG_SIZE ];

char io_msg2 [ IO_MSG_SIZE ];

char io_debug_msg1 [ IO_MSG_SIZE + IO_AUX_MSG_SIZE ];

char io_debug_msg2 [ IO_MSG_SIZE ];

char io_msg_ [ IO_MSG_SIZE ];

int 
vz_io_eth_init ( void )
{
    int return_value = 0;

    int udp_bind = udp_client.bind ( u16_UDP_PORT_LISTENER );

    udp_client.set_blocking ( false, 0 );

    if ( debug_io_eth ) serial_pc.printf ( "udp_client.bind :: %d", udp_bind );

    if ( udp_bind == 0 ) return_value |= BIT0;

    int tcp_bind = tcp_server.bind ( u16_TCP_PORT_LISTENER );

    tcp_server.set_blocking ( false, 0 );

    tcp_server.listen ();  

    if ( debug_io_eth ) serial_pc.printf ( "tcp_server.bind :: %d", tcp_bind );

    if ( tcp_bind == 0 ) return_value |= BIT1;

    return ( return_value );
}

int
vz_printf ( const char * format, ... )
{
        va_list arg;

        va_start ( arg, format );

        int done = vsnprintf ( io_msg_, IO_MSG_SIZE -1, format, arg );
        
        snprintf ( io_msg1, sizeof ( io_msg1 ) - 1, "%s\r\n> ", io_msg_ );
        
        if ( debug_uart3 && !udp_query && !from_eth ) serial_pc.printf ( "%s",io_msg1 );
        
        if ( tcp_session && !udp_query )
        {
            while ( !( tcp_client.send_all ( io_msg1, strlen ( io_msg1 ) ) ) );
        }
        
        if ( udp_query )
        {
            int send = udp_client.sendTo ( udp_server, io_msg_, strlen ( io_msg_ ) );
            if ( send not_eq strlen ( io_msg_ ) )
            {
                if ( debug_reconnect && debug_uart3 ) serial_pc.printf ("\n\rReconnect udp_query client\n\r");
                reconnect_prompt_udp_socket ();
                miss_prompt_udp_send_pkg ++;
            }
        }
        
        va_end ( arg );
        
        return done;
}

void 
udp_query_send_msg ( char * msg )
{
    if ( ( msg != NULL ) && ( strlen ( msg ) > 0 ) )
    {   
        int send = udp_client.sendTo ( udp_server, msg, strlen ( msg ) );
        
        if( send not_eq strlen ( msg ) )
        {
            reconnect_prompt_udp_socket ();
            miss_prompt_udp_send_pkg ++;
        }
    }
}