#include "vz_protocol.h"

uint32_t pkg_ckserr = 0;
uint32_t pkg_zero = 0;
uint32_t pkg_cksok = 0;
int begin = 0;
int end = 0;

int init_ranges ( void )
{
    begin = cm -> get_min_ext ();
    end = cm -> get_max_ext ();
    
    return ( 0 );
}

uint8_t * 
parse_vz_pkg ( int * ext, int * port, volatile uint8_t * type, uint8_t * cb_buffer )
{   
    if ( ( ext and port and type and cb_buffer ) == NULL ) return ( NULL );
    
    //tratamento dos pacotes do tipo flood logo na chegada
    {    
        if ( cb_buffer [ TYPE_PLACE ] == FLOOD )
        {
            flood_counter++;
            static uint8_t flood_cnt = 0;
            static uint8_t first_run_flag = 0;
            static Timer t;
            if (first_run_flag == 0) {
                flood_cnt = cb_buffer[0];
                first_run_flag++;
                t.start();
            } else {
                if (cb_buffer[0] == 0x00){
                    if( debug_uart3 and enable_flood ) pc.printf("%d", t.read_us());
                    if( tcp_session and !udp_query and enable_flood ){
                        char tmp[ 16 ];
                        sprintf( tmp, "%d", t.read_us() );
                        tcp_client.send_all( tmp, strlen( tmp ) );
                    }
                }
                flood_cnt++;
                while (flood_cnt != cb_buffer[0]) {
                    if( debug_uart3 and enable_flood ) pc.printf("0");
                    flood_cnt++;
                    if( tcp_session and !udp_query and enable_flood ){
                        tcp_client.send_all( "0", strlen( "0" ) );
                    }
                }
                int i;
                int ok = 1;
                uint8_t cmp;
                for (i=0, cmp=cb_buffer[0]; (i<300) and (ok==1); i++, cmp++) {
                    if (i != 6) {
                        if (cb_buffer[i] != cmp) ok = 0;
                    }
                }
                if( ok ){
                    if( debug_uart3 and enable_flood ) pc.printf("+");
                    if( tcp_session and !udp_query and enable_flood ){
                        tcp_client.send_all( "+", strlen( "+" ) );
                    }
                }else{
                    if( debug_uart3 and enable_flood ) pc.printf("%02x",cb_buffer[0] );
                    if( debug_uart3 and enable_flood ) pc.printf("#");
                    if( debug_uart3 and enable_flood ) pc.printf("\n\r");
                    if( tcp_session and !udp_query and enable_flood ){
                        char tmp[ 16 ];
                        sprintf( tmp, "%02x#\n\r", cb_buffer[ 0 ] );
                        tcp_client.send_all( tmp, strlen( tmp ) );
                    }
                    for( int i = 0; i < 300 ; i++ ){
                        if( debug_uart3 and enable_flood ) pc.printf("%x", cb_buffer[ i ]);
                        if( tcp_session and !udp_query and enable_flood ){
                            char tmp[ 16 ];
                            sprintf( tmp, "%x", cb_buffer[ i ] );
                            tcp_client.send_all( tmp, strlen( tmp ) );
                        }
                    }
                }
            }
            return( NULL );
        }
    }//fim tratamento do flood
    
    uint16_t cc = ( uint16_t )cb_buffer[ 4 ] << 8 bitor cb_buffer[ 5 ];
    
    uint16_t cc_calculated = vz_checksum ( cb_buffer, CB_BUFFER_SIZE );
    
    if ( cc != cc_calculated )
    {
        if ( debug_cks_err ) vz_printf ( "Received PKG, but -- CKS ERROR: %d ( %d )", cc_calculated, cc );

        if ( cc_calculated == 30975 and cc == 0 ){
            pkg_zero++;
        }else{ 
            pkg_ckserr++;
        }
        return( NULL );
    } 
        else 
    {
        
        uint8_t e_lsb, e_msb;
        uint8_t p_lsb, p_msb;
        
        pkg_cksok ++;
        e_msb = cb_buffer [ 0 ];
        e_lsb = cb_buffer [ 1 ];
        *ext = ( (uint16_t )e_msb ) << 8  bitor e_lsb;
        
        //restriçao de controle para cbx malucos       
        if ( *ext < begin or *ext > end )
        {
            if ( debug_out_of_range ) vz_printf ("Trying from %d", *ext );
            out_of_range ++;
            return ( NULL );
        }
        
        p_msb = cb_buffer[ 2 ];
        p_lsb = cb_buffer[ 3 ];
        *port = ( (uint16_t )p_msb ) << 8 bitor p_lsb; 
        
        *type = cb_buffer [ TYPE_PLACE ];

        return ( cb_buffer + VZ_HEADER_OFFSET );    
    }
}

uint8_t * build_cb_package ( const int ext, const int port, const uint8_t type, const char * cb_buffer, const uint8_t seq_num, const int length,  uint8_t * pkg )
{
    //checa se o fuffer de src e dst dos dados estao alocados
    if( ( cb_buffer == NULL ) or ( pkg == NULL ) ) return NULL;
    
    //apaga as posicoes de memoria onde serah montado o pacote
    for( register int i = 0; i < CB_BUFFER_SIZE; i++ ) pkg[ i ] = 0;
    
    //coloca ramal ( MSB ), ramal ( LSB ), porta ( MSB ), porta ( LSB ) e tipo nas posicoes destino
    pkg[ 0 ] = ( uint8_t )( ( ext bitand 0xFF00 ) >> 8 );                                                                                      
    pkg[ 1 ] = ( uint8_t )( ext bitand 0x00FF );                                                                                                                                                                                                                                 
    pkg[ 2 ] = ( uint8_t )( ( port bitand 0xFF00 ) >> 8 );                      
    pkg[ 3 ] = ( uint8_t )( port bitand 0x00FF );
                                                                                                                                        
    pkg[ TYPE_PLACE ] = type;
    
    //preenche os dados de acordo com o tipo do pacote transmitido
    size_t fill = VZ_HEADER_OFFSET;
    switch( type )
    {
        case AUDIO  :{
                for( register int i = VZ_HEADER_OFFSET; i < length + VZ_HEADER_OFFSET; i++ )
                    pkg[ i ] = ( uint8_t )cb_buffer[ i - VZ_HEADER_OFFSET ];
                
                fill = length + VZ_HEADER_OFFSET;            
                break;
        }
        case INVITE :{
                pkg[ 7 ] = seq_num;
                print_clock( pkg + 8 );
                pkg[ TIMESLICE_PLACE ] = cb_buffer[ TIMESLICE_PLACE ];
                fill = TIMESLICE_PLACE + 1;
                break;
        }
        
        case REGISTRY  :{
                pkg[ 7 ] = seq_num;
                print_clock( pkg + 8 );
                fill = VZ_HEADER_OFFSET + CLOCK_SYNC_SIZE + SEQ_NUM_SIZE;
                break;
        }
        case BOOT :{
                pkg[ 7 ] = seq_num;
                print_clock( pkg + 8 );
                fill = VZ_HEADER_OFFSET + CLOCK_SYNC_SIZE + SEQ_NUM_SIZE;
                break;
        }
        case CB_BYE :{
                pkg[ 7 ] = seq_num;
                print_clock( pkg + 8 );
                pkg[ TIMESLICE_PLACE ] = cb_buffer[ TIMESLICE_PLACE ];
                fill = TIMESLICE_PLACE + 1;
                break;
        }
        case PROMPT :{
                strcpy( ( char * )( pkg + VZ_HEADER_OFFSET ), cb_buffer );
                fill = strlen( cb_buffer ) + VZ_HEADER_OFFSET;
                break;
        }
        case TELEMETRY :{
                pkg[ 7 ] = seq_num;
                print_clock( pkg + 8 );
                //FIXME a header manda pacotes de tele pro cbx ?
                pkg[ TIMESLICE_PLACE ] = cb_buffer[ TIMESLICE_PLACE ];
                fill = TIMESLICE_PLACE + 1;
                break;
        }
        case BOOTLOADER_CBX :{
                xmemcpy((pkg + 7),(uint8_t *)cb_buffer,length);
                fill = VZ_HEADER_OFFSET + length;
                break;
        }
    }//fim switch
    
    //preenche o final do pacote com 0
    for( register uint16_t i = fill; i < CB_BUFFER_SIZE; i++ ) pkg[ i ] = 0x00;
    
    //colocando o terminador de pacotes estabelecido pelo protocolo
    pkg[ CB_BUFFER_SIZE - 4 ] = 0x5a;
    pkg[ CB_BUFFER_SIZE - 3 ] = 0x56;
    pkg[ CB_BUFFER_SIZE - 2 ] = 0x5a;
    pkg[ CB_BUFFER_SIZE - 1 ] = 0xe1;
    
    //calcula e preenche o checksum
    uint16_t cc = vz_checksum( pkg, CB_BUFFER_SIZE );
    pkg[ 4 ] =( uint8_t )( ( cc bitand 0xFF00 ) >> 8) ;
    pkg[ 5 ] =( uint8_t )( cc bitand 0x00FF );
    
    //retorna o ultimo paramentro recebido com o pacote montado.
    return pkg;
}

uint16_t vz_checksum ( uint8_t * buffer, size_t length )
{
    if( !buffer ) return( 0 );
    uint16_t cc = 0x00;
    buffer[ 4 ] = buffer[ 5 ] = 0x5a;
    for( register int i = 0; i < length; i++ ){
        cc += buffer[ i ];
        if( cc bitand BIT15 ){
            cc <<= 1;
            cc or_eq BIT0;
        }else{ cc <<= BIT0; }
    }
    cc ^= 0xffff;
    return cc; 
}

void print_clock ( uint8_t * buffer )
{
    if( buffer != NULL )
    {
        struct tm * result_tm;
        if( sizeof( time_t ) != sizeof( long ) )
        {
            if ( debug_print_clock ) vz_debug ( "sizeof( time_t ) : %lu -- sizeof( long int ) : %lu\n", sizeof( time_t ), sizeof( long ) );
        }
                                   
        if ( debug_print_clock ) vz_debug ( "current_time : %lu\t", current_time );
                                                                                                                                        
        if( current_time != 0 )
        {
            result_tm = localtime( ( const time_t *)&current_time );
            if ( result_tm )
            {
                char formated_time[ 16 ];
                
                /* Correcao "manual" do (GMT -3:00) */
                result_tm->tm_hour -= 3;
                if ( result_tm->tm_hour < 0 ) result_tm->tm_hour = 24 + result_tm->tm_hour;
                
                size_t formated_nbytes = strftime( formated_time, sizeof( formated_time ), "%Y%m%d%H%M%S", result_tm );
                
                if ( debug_print_clock ) vz_debug ("clock() : %s\n", formated_time );
                
                if( formated_nbytes != CLOCK_SYNC_SIZE ) vz_debug ("( %lu )\n", formated_nbytes );
                
                for( register int i = 0; i < CLOCK_SYNC_SIZE; i++ ) buffer[ i ] = formated_time[ i ];
            }
                else
            {
                for( register int i = 0; i < CLOCK_SYNC_SIZE; i++ ) buffer[ i ] = 0xfa;
            }
        }
            else
        {
            for( register int i = 0; i < CLOCK_SYNC_SIZE; i++ ) buffer[ i ] = 0xab;
        }
    }
}