/**
 * @file vector.h
 * @Synopsis A classe Vector representa uma lista de Objects. O objetivo dessa classe é manter de forma organizada na memória as 
 *  instâncias da classe Object.
 * @author Jhonatan Casale
 * @version 1
 * @date 2014-10-31
 * \class Vector
 * \note Não preserva ordem dos seus elementos.
 */

#ifndef __VECTOR_H__
#define __VECTOR_H__

#include "mbed.h"
#include <stdlib.h>
#include "object.h"
#include "debug.h"

class Vector{
    private:
        Object **objects;
        int elements;

    public: 
        /**
         * Cria um objeto do tipo vetor pronto para uso.
         *
         * Exemplo: 
         * @code
         * ...
         *  Vector * v = new Vector();
         * ...
         * @endcode
         */
        Vector();

        /**
         * Deleta todos os elementos do vetor
         * \note Preserva os elementos originais 
         */
        ~Vector();

        /**
         * @Synopsis Adiciona o elemento @f$e@f$ ao final do vetor
         *
         * @param e Um ponteiro para algum objeto da clase Object
         * 
         * Exemplo:
         * @code
         * ...
         *  v->add( new * Object );
         * ...
         * @endcode
         */
        void add( Object * e );

        /**
         * @Synopsis Retorna elementos contidos no vetor 
         *
         * @param position A posicao do elemento de interesse
         *
         * @return Um objeto da classe Object caso position seja 
         * maior do que zero e menor que o numero de elementos 
         * do vetor, NULL caso contrario
         *
         * Exemplo:
         * @code
         * ...
         *  Object obj = v->get_element( 0x01 );
         * ...
         * @endcode
         */
        Object * get_element( int position );

        /**
         * @Synopsis Remove elementos contidos no vetor
         *
         * @param position Remove o elemento na posição position, 
         * desde de, position seja maior do que 0 e menor do que o 
         * numero de elementos do vetor.
         *
         */
        void remove_element( int position );

        /**
         * @Synopsis Executa procedimento de busca nos elementos do vetor 
         *
         * @param ext Verifica se existe algum elemento com este ramal contido no vetor
         * @param port Verifica se existe algum elemento com esta porta contido no vetor
         * \note Este método não esta completamente implementado.
         *
         * @return Um ponteiro para o objeto de interesse. NULL, caso este objeto não tenha
         * sido encontrado.
         *
         * Exemplo:
         * @code
         * ...
         *  return( find_element( 1011, 1011 ); 
         * ...
         * @endcode
         */
        Object * find_element( int ext, int port );

        /**
         * @Synopsis Representa o numero de elementos contidos no vetor. 
         *
         * @return O numero de elementos contidos no vetor
         *
         * Exemplo:
         * @code
         * ...
         *  v->size();
         * ...
         * @endcode
         */
        int size ( void );
        int print_yourself ( void );
};
#endif