#ifndef __SHARED_VARIABLES_H__
#define __SHARED_VARIABLES_H__

#include "EthernetInterface.h"
#include "mbed.h"
%: include "config_manager.h"

extern ConfigManager * cm;

extern uint16_t u16Who_is_your_pair;

extern bool boolWho_is_your_pair;

const uint16_t EXTERN_WDT_IDLE = 630;
///< Tempo maximo ( countdown em segundos ) que a Header espera por algum tick do wdt externo ( via UDP ), deixa de tickar o wdt quando chega em zero.

const uint8_t READ = 0x01;
///< Define o estado ( na main ) de que existe um dados disponivel para leitura.

const uint8_t WAITING = 0x00;
///< Define o estado ( na main ) de que esta apenas esperando por um novo pacote vindo dos CBx.

const uint16_t CB_BUFFER_SIZE = 300;
///< Indica o numero máximo de bytes recebidos ( por pacote ) do CBx.

extern bool debug_alive;
///< Variável de controle que ativa o debug de impressao periódica dos cbx registrados na lógica.

extern bool reset_cks;
///< Variável de controle que reseta os contadores de cks dos pacotes.

extern bool pcks_s;
///< Variável de controle que ativa a exibição dos contadores de cks dos pacotes.

extern bool pshowcb;
///< Variável de controle que ativa a exibição dos CBx registrados.

extern bool list;
///< Variável de controle para listar os CBx registrados na lógica da Header.
extern bool show_last_rx;
///< Variável de controle para exibição do ultima pacote recebido dos CBx
extern bool show_last_tx;
///< Variável de controle para exibição do ultimo pacote enviado para o CBx.
extern bool stats;
///< Variável de controle para exibição dos contadores de pacotes recebidos por tipo.
extern bool r_stats;
///< Variável de controle para resetar os contadores de pacotes recebidos por tipo.

extern uint32_t boot_counter;
///< Contador dos pacotes de BOOT recebidos

extern uint32_t registry_counter; 
///< Contador dos pacotes de REGISTRY recebidos

extern uint32_t invite_counter; 
///< Contador dos pacotes de INVITE recebidos

extern uint32_t audio_counter; 
///< Contador dos pacotes de AUDIO recebidos

extern uint32_t telemetry_counter; 
///< Contador dos pacotes de TELEMETRY recebidos

extern uint32_t cb_stats_counter;

extern uint32_t cb_bye_counter; 
///< Contador dos pacotes de CB_BYE recebidos

extern uint32_t prompt_counter; 
///< Contador dos pacotes de PROMPT recebidos

extern uint32_t flood_counter;
///< Contador dos pacotes de FLOOD recebidos

extern uint32_t bootloader_cbx_counter;
///< Contador dos pacotes de BOOTLOADER_CBX recebidos

extern uint32_t out_of_range;
///< Contador de pacotes recebidos fora do range.

extern uint32_t fw_counter;

extern Serial pc;
///< Objeto que possibilita a excrita ( via printf ) de texto na serial

extern volatile uint8_t status;

extern uint16_t external_wdt;

extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;
extern DigitalOut led4;
extern DigitalOut CAB_LED;

extern int max_ext;
extern int min_ext;
extern uint32_t missed_pkg;
extern uint32_t cpld_pkg_tx_counter;
extern uint32_t cpld_pkg_rx_counter;
extern uint8_t cb_new_counter;
extern uint8_t cb_delete_counter;
extern uint8_t sip_new_counter;
extern uint8_t sip_delete_counter;
extern uint16_t rtp_header_new_counter;
extern uint16_t rtp_body_new_counter;
extern uint16_t rtp_header_delete_counter;
extern uint16_t rtp_body_delete_counter;
extern uint16_t call_new_counter;
extern uint16_t call_delete_counter;
extern volatile uint16_t received_cpld_pkg;
extern bool memory_is_over;
extern uint16_t sip_socket_send_failure;
extern bool show_sip;
extern uint32_t delayed_pkg_to_cb;
extern uint16_t miss_prompt_udp_send_pkg;
extern uint16_t miss_prompt_udp_rcv_pkg;
extern uint16_t miss_power_source_send_pkg;
extern uint16_t miss_bl_udp_send_pkg;
extern int print_this_cb;
extern int print_hex_this_cb;
extern uint16_t miss_prompt_udp_rcv_pkg;
extern int print_this_sip;
extern uint16_t miss_prompt_udp_send_pkg;
extern int print_hex_this_sip;
extern int print_this_call;
extern int print_hex_this_call;
extern int print_this_rtp;
extern int print_hex_this_rtp;
extern int frtp_target;
extern int rescue_rtp_target;
extern int rescue_rtp_value;
extern uint32_t uptime;
extern uint8_t drop_this_amount_of_ack_to_ast;
extern bool extern_process;
extern uint16_t string_msg_overflow;
extern bool test_flag_unusual;
extern bool show_time;
extern bool disable_wdt_from_cbx;
extern bool show_invites;
extern bool dont_say_hello_again;
extern bool reverse_list;
extern bool show_hello_status;
extern bool request_clock_now;
extern bool show_wake_all_up_status;
extern bool wake_all;
extern uint16_t end_call_ext;
extern bool end_call;
extern bool do_not_refresh;
extern bool do_not_show_this_invite_pkg;
extern bool show_wdt_string;
extern bool enable_flood;
extern bool wake_all_disable;
extern bool need_registry_someone;
extern int ext_to_be_registered;
extern bool simulate;
extern int ext_to_simulate;
extern int port_to_simulate;
extern int seq_num_to_simulate;
extern uint8_t num_type_to_simulate;

const uint8_t RTP_HEADER_OFFSET = 12;
///< Identifica o inicio dos dados de audio ( payload )
const uint8_t RTP_HEADER_SIZE = 12;
///< Indica o tamanho ( em bytes ) ocupado pelo cabeçalho rtp.

#endif