#include "ring_buffer.h"

ring_buffer * ring_buffer_init( ring_buffer * rb ){
    if( rb == NULL ){
        rb = ( ring_buffer * )malloc( sizeof( ring_buffer ) );
        rb->begin = 0;
        rb->end = 0;
        rb->size = 0;
        rb->data = ( uint8_t * )malloc( sizeof( uint8_t ) * CB_BUFFER_SIZE * RING_BUFFER_SIZE );
        return( rb );
    }else return( rb );
}

uint8_t ring_buffer_add( ring_buffer * rb, uint8_t * data ){
    if( rb == NULL ) return 0x99;

    if( data == NULL ) return 0x98;
    
    if( rb->size >= RING_BUFFER_SIZE ) return 0x01;

    else{
        rb_xmemcpy( rb->data + ( CB_BUFFER_SIZE * rb->end ), data, CB_BUFFER_SIZE );           
        if( ++( rb->end ) >= RING_BUFFER_SIZE ) rb->end = 0;
        rb->size++;
    }

    return( 0x00 );
}

uint8_t * ring_buffer_get_next( ring_buffer * rb ){
    if( rb == NULL ) return( NULL );

    if( rb->size == 0 ) return( NULL );

    uint8_t * ret = rb->data + ( rb->begin * CB_BUFFER_SIZE );
    
    if( ++( rb->begin ) >= RING_BUFFER_SIZE ) rb->begin = 0;

    if( rb->size > 0 ) rb->size--;
    
    return( ret );
}

void rb_xmemcpy (uint8_t * dest, uint8_t * src, uint16_t size)
{
  while ( size-- ) *dest++ = *src++;
}