#include "main_app_functions.h"
#include "main_app_var_configs.h"

int main()
{
    debug_uart3 = true;
    
    int header_app_init_ret = header_app_init ();
    
    vz_printf ( "header_app_init %s" , ( header_app_init_ret  == 0 ) ? "Ok" : "Failure" );
    
    if ( header_app_init_ret == 0 ) vz_printf ("Ready");
    
    debug_uart3 = false;
    
    power_source_timer.start ();
    
    bool init_test = true;
    bool end_test = false;
    
    bool init_test_mean = true;
    bool end_test_mean = false;
    Timer timer;
    
    /*------------------------------------------ main loop ---------------------------------------------------------------*/
    
    while( true )
    {   
        if ( main_test_mean )
        {
            const uint16_t u16_COUNT_TIMES = 60000;
            
            static uint16_t count = u16_COUNT_TIMES;
            
            static uint64_t u_sum = 0;
            
            if ( init_test_mean )
            {
                u_sum = 0;
                count = u16_COUNT_TIMES;
                
                init_test_mean = false;
                
                timer.start ();
                timer.reset ();
            } 
                else if ( count  )
            {
                count--;
                
                timer.stop ();
                
                u_sum += timer.read_us ();
                
                timer.start ();
                timer.reset ();
                   
                if ( count == 0 ) end_test_mean = true;
            } 
                else if ( end_test_mean )
            {
                vz_printf ( "Elapsed_time_mean : [ %.2lfu ]", double ( u_sum / u16_COUNT_TIMES ) );
                
                end_test_mean = false;    
                init_test_mean = true;
                main_test_mean = false;
                
                timer.stop ();
            }
        }
        
        if ( main_test )
        {
            if ( init_test )
            {
                init_test = false;
                end_test = true;    
                timer.start ();
                timer.reset ();
            } else if ( end_test )
            {
                timer.stop ();
                int u_elapsed_time = timer.read_us ();
                int m_elapsed_time = timer.read_ms ();
                int s_elapsed_time = timer.read ();
                
                vz_printf ( "Elapsed_time : [ %du, %dm, %ds ]", u_elapsed_time, m_elapsed_time, s_elapsed_time );
                
                end_test = false;    
                init_test = true;
                main_test = false;
            }
        }
    
        prompt_process ( NULL, 0 );
        
        if ( cm -> was_modified () ) 
        { 
            update_config_values (); 
            cm -> set_modified_false ();
        }
        
        if ( show_last_rx )
        {
            if ( v_call -> size () == 0 ) show_last_rx_pkg_from_cbx ();
            show_last_rx = false;    
        }
        
        if ( show_last_tx )
        {
            if ( v_call -> size () == 0 ) show_last_tx_pkg_from_cbx ();
            show_last_tx = false;    
        }
        
        if ( show_hello_status )
        {
            show_hello_status_function ();
            show_hello_status = false;    
        }
        
        if( v_cb->size() > max_registered_cbx ) max_registered_cbx = v_cb->size();

        if ( sync_timer.read() > 5 )
        {
            sync_timer.reset();

            if( debug_cks == true ) { pcks_s = true; }

            if( debug_alive == true ) { pshowcb = true; }
            
            if( !( ++count % 15 ) ) {
                if( eth_status ) {
                    try_reconnect_with_eth ();
                }
            }
            
            //35 sec.
            if( ( count > 7 ) and ( wake_all == false ) and ( not wake_all_disable ) and ( cm -> get_cbx_wake_mode () ) ) {
                wake_all = true;
                if( debug_wake == true ) vz_printf ( "Time to wake" );
            }
            
            // enable na variavel que exibe lista com estatisticas de pacotes que falharam ao serem enviados via interface eth
            if ( debug_missed ) { missed_send_udp_pkg = true; }

        }
        
        if ( show_wake_all_up_status )
        {
            vz_printf ( "wake_all_up status :: %s", ( wake_all ) ? "Enable" : "Disable" );
            show_wake_all_up_status = false;    
        }
        
        check_clock ();

        if ( r_stats )
        {
            reset_stats ();
            stats = true;
            r_stats = false;
        }

        if ( stats )
        { 
            show_stats ();
            stats =false;
        }

        if ( list ) 
        {
            show_cb_list ( v_cb );
            list = false;
        }

        if ( long_list ) 
        {
            show_cb_long_list ( v_cb, show_time, show_invites );
            long_list = false;
            show_time = false;
            show_invites = false;
        }
        
        if ( pshowcb ) 
        {
            show_cb ( v_cb );
            pshowcb = false;
        }
        
        if ( request_clock_now )
        {
            request_clock_to_server ();
            show_current_time = true;
            request_clock_now = false;    
        }
        
        if ( show_current_time ) 
        {  
            show_clock ();
            show_current_time = false;;
        }
        
        if( show_sip ){
            show_cb_sip ( v_cb );
            show_sip = false;
        } 

        if( pflood == true ) flood();

        if( debug_eth ) {
            vz_printf ("Eth status %s", ( eth_status == 0 ) ? "Connected" : "Disconnected" );
            debug_eth = false;
        }
          

        // chechando se existe um pacote vindo do cbx pendente
        if( status != WAITING ) 
        {
            process_received_pkg_from_cbx ();
        } 
            else if ( test_ts and test_ts_timer.read_ms () > 10 )
        {
            if ( v_cb -> size () not_eq 0 )
            {
                Call_Box * cb = ( Call_Box * ) v_cb -> get_element ( 0 );
                if ( cb not_eq NULL )
                {
                    ext = cb -> get_ext ();
                    port = cb -> get_port ();     
                } 
            }
                else
            {
                ext = 5000;
                port = 5000;
            }
                
            type = INVITE;
            data = buffer;
            
            test_ts_timer.reset ();
        }
            else if ( simulate )
        {
            simulate = false;
            
            data = buffer;
            
            data [ SEQ_NUM_PLACE ] = seq_num_to_simulate;
            
            ext = ext_to_simulate;
            
            port = port_to_simulate;
            
            type = num_type_to_simulate;
        }

        if( sizes == true )
        {
            show_sizes ();
            sizes = false;
        }
        
        // usado pra testes
        {
            if ( registra )
            {
                int internal_ext = 8000;
                registra = false;
                for( register uint8_t i = 0; i < u8_MAX_CB_IN_A_BRANCH - 2; i++ ) {
                    v_cb -> add ( new Call_Box ( internal_ext, internal_ext++ ) );
                }    
            }
            
            if ( registra4 )
            {
                int internal_ext = 8000;
                registra4 = false;
                for( register uint8_t i = 0; i < 4; i++ )
                {
                    v_cb -> add ( new Call_Box ( internal_ext, internal_ext++ ) );
                }    
            }
            
            if ( need_registry_someone )
            {
                need_registry_someone = false;
                
                v_cb -> add ( new Call_Box ( ext_to_be_registered, ext_to_be_registered ) );
                
                ext_to_be_registered = 0;
            }
        }
        
        check_udp_packages_pending ( v_cb );
        
        if( dshow_rtp == true )
        {
            show_rtp ();
            dshow_rtp = false;
        }
            
        // usado pra test
        if ( frtp )
        {
            fuck_rtp ( v_cb );
            frtp = false;
        }
        
        // usado pra test
        if ( rescue_rtp )
        {
            rescue_rtp = false;
            Call_Box * cb = find_CB( v_cb, rescue_rtp_target );
            if ( cb != NULL )
            {
                cb -> set_rtp_port ( rescue_rtp_value );
            }
                else
            {
                vz_debug ("rescue rtp fail");
            }
        }
        
        if ( print_v_cb )
        {
            v_cb->print_yourself ();
            print_v_cb = false;
        }
        
        if ( print_v_call )
        {
            v_call->print_yourself ();
            print_v_call = false;         
        }
        
        if ( print_cb_var )
        {
            show_cb_content ();
            print_cb_var = false;
        }
        
        if ( print_cb_all )
        {
            show_cb_content_all ();
            print_cb_all = false;
        }
        
        if ( print_hex_cb_var )
        {
            show_hex_cb_content ();
            print_hex_cb_var = false;
        }
        
        if ( print_hex_cb_all )
        {
            show_hex_cb_content_all ();
            print_hex_cb_all = false;
        }
         
        if ( print_sip_var )
        {
            show_cb_sip ();
            print_sip_var = false;
        }
        
        if ( print_sip_all )
        {
            show_cb_sip_all ();
            print_sip_all = false;
        }
        
        if ( print_hex_sip_var )
        {
            show_cb_hex_sip ();
            print_hex_sip_var = false;
        }
         
        if( dcallshow_rtp == true ){
            show_rtp_on_call ();
            dcallshow_rtp = false;
        }
        
        if ( print_call_var )
        {
            show_call ();
            print_call_var = false;
            
        }
        
        if ( print_hex_call_var )
        {   
            show_hex_call ();
            print_hex_call_var = false;
        }
        
        
        if ( print_hex_rtp_var )
        {   
            show_cb_rtp ();
            print_hex_rtp_var = false;
        }
        
        if ( print_rtp_var )
        {
            show_cb_hex_rtp ();
            print_rtp_var = false;
        }

        if( reset_cks == true )
        {
            reset_stats_cks ();
            pcks_s = true;
            reset_cks = false;
        }

        if( pcks_s == true ) {
            show_cb_stats ();
            pcks_s = false;
        }
        
        if ( show_wdt_string )
        {
            char wdt_msg [ 1024 ];
            build_wdt_string ( wdt_msg, sizeof ( wdt_msg ) - 1 );
            
            int siRet = strlen ( wdt_msg );
            
            vz_printf ( "wdt_msg.length::%d\r\n%s", siRet, wdt_msg );
            
            show_wdt_string = false;    
        }
        
        if( reset_missed_send_udp_pkg )
        {
            reset_missed_send_udp ();
            missed_send_udp_pkg = true;
            reset_missed_send_udp_pkg = false;
        }
        
        if ( missed_send_udp_pkg )
        {
            show_missed_send_udp_pkg ();
            missed_send_udp_pkg = false;
        }
            
        // usado pra test
        if ( flood_bug_pkg ){
            static int id = 0x10;
            if( id < 10 ) id = 0x0b;
            send2callboxes( build_cb_package( 5828, 5123, REGISTRY,
                ( char * )buffer, id++, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );    
        }
        
        if ( led_sync_timer.read() > 1 ) {
            led_sync_timer.reset();
            led3 = !led3;
            CAB_LED = !CAB_LED;
        }
        
        if ( boolWho_is_your_pair )
        {
            boolWho_is_your_pair = false;
            
            Call_Box * cb = find_CB ( v_cb, u16Who_is_your_pair );
            
            if ( cb not_eq NULL )
            {
                cb = cb -> get_pair_cbx ();
                
                if ( cb not_eq NULL ) vz_printf ( "[%d] pair [%d]", u16Who_is_your_pair, cb -> get_ext () );
                
                else vz_printf ( "[%d] pair nao encontrado", u16Who_is_your_pair );
                
            } else vz_printf ( "[%d] nao encontrado", u16Who_is_your_pair );
            
            u16Who_is_your_pair = 0;    
        }
        
        switch ( type ) 
        {
            case DO_NOTHING :{}
            break;

            case CB_BYE : 
            {
                cb_bye_counter ++;
                Call_Box * cb = find_CB ( v_cb, ext );
                if ( cb != NULL )
                {
                    if ( debug_invite or debug_main ) vz_debug ("[%d] Bye pkg - msg_id %d e pkg_id %d", ext, cb -> get_msg_id (), data [ 0 ] );
                    
                    bool already_removed = true;
                    
                    if ( cb -> get_status () != cb_idle )
                    {
                        already_removed = false;
                    
                        data [ TIMESLICE_PLACE ] = 0;
                    
                        send2callboxes ( build_cb_package ( ext, port, CB_BYE,
                            ( char * )data, data [ 0 ] or_eq BIT7, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
                    
                        ts -> return_timeslice ( cb -> call_end () );
                    }
    
                    if ( already_removed ) if ( debug_main or debug_invite ) vz_debug ( "[%d] Already removed from inviting queue", ext );
                    
                    already_removed = true;
                    
                    for ( register uint8_t i = 0; i < v_call->size(); i++ )
                    {
                        VZ_call * call = (VZ_call *)v_call->get_element( i );
                        if( call->get_cb_ext() == ext )
                        {
                            already_removed = false;
                            
                            data[ TIMESLICE_PLACE ] = 0;

                            v_call->remove_element( i );

                            send2callboxes( build_cb_package( ext, port, CB_BYE,
                                ( char * )data, data[ 0 ] or_eq BIT7, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
                            
                            delete( call );
                            
                            ts -> return_timeslice ( cb -> call_end () );
                        }
                    }
   
                    if( already_removed ) if( debug_main or debug_invite ) vz_debug ( "[%d] Already removed from vector call", ext );

                    cb -> registry ();
                    
                } else if ( debug_invite or debug_main ) vz_debug ("[%d] Bye from who ?", ext );
            }
            break;

            case INVITE : 
            {
                if ( drop_invite_pkg )
                {
                    vz_debug ("[%d] Dropando invite pck - msg id :: %d", ext, data[ 0 ] );
                    break;
                }
                
                invite_counter ++;
                
                if ( debug_invite ) vz_debug ("[%d] Invite request", ext );
                
                Call_Box * cb = find_CB ( v_cb, ext );
              
                if ( cb == NULL ) cb = try_add_new_cbx ( v_cb, ext );
                
                if ( cb == NULL ) {
                    if ( debug_memory or debug_invite ) vz_debug ("[%d] Invite allocation cb fail", ext );
                } else {
                    cb -> update_invite_counter ();
                    
                    cb -> invite_retry_count_reset ();
                    
                    cb -> set_msg_id ( data [ 0 ] );
                    
                    if ( cb -> get_status () == cb_idle ) { 
                        cb -> call_config ();
                        if ( test_ts ) vz_debug ("TST::IDLE");
                    } else {
                        data [ TIMESLICE_PLACE ] = cb -> get_timeslice ();
                        
                        cb -> set_invite_response_pending ();    
                        
                        if ( test_ts ) vz_debug ("TST::%u ", data [ TIMESLICE_PLACE ]);
                        
                        send2callboxes ( build_cb_package ( ext, port, INVITE, 
                            ( char * )data, cb->msg_id_update (), CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );    
                    }
                    
                    invite_handler ( v_call, v_cb, ts, cb );
                }
            }
            
            break;
            
            case REGISTRY : {
                /*
                    Colocar um if, de que se o cbx já existia, e tinha dado timeout
                    ou por slave ou por mestre, resetar o timer dos 2
                */
                registry_counter ++;
                Call_Box * cb = find_CB ( v_cb, ext );
                
                if ( cb == NULL ) cb = try_add_new_cbx ( v_cb, ext );
                
                if ( cb == NULL and debug_memory ) vz_debug ( "[%d] Registry cb allocation fail", ext );
                
                int registry_ret = -1;
                
                if ( cb not_eq NULL ) registry_ret = cb -> registry ();
                
                if ( ( registry_ret > 0 ) and eth_status ) try_reconnect_with_eth ();
                
                if ( debug_main and registry_ret ) vz_debug ( "[%d %d] Registered", ext, port );
                
                pkg_wdt = RX_CB_IDLE;
            }
            break;
            
            case BOOT : {
                boot_counter++;
                if( debug_boot == true ){
                    vz_printf ("[%d %d] Boot pkg -- pkg-id %d", ext, port, data[ 0 ] );    
                }
                send2callboxes( build_cb_package( ext, port, REGISTRY,
                    ( char * )data, data[ 0 ] bitor BIT7, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
            }
            break;
            
            case FW : {
                if ( debug_fw_print ) vz_printf ("[%d %d]::FW pkg::", ext, port );
                fw_cbx_pkg ( ext, ( char *) buffer );
            }
            break;

            case BOOTLOADER_CBX : {
                uint16_t bl_cnt2 = 0;
                if (debug_bootloader) {
                    pc.printf("\r\npacote CBX->HDR {");
                    for (bl_cnt2 = 0;bl_cnt2 < BL_SIZE + 1;bl_cnt2++) {
                        if ((bl_cnt2 % 30) == 0) {
                            pc.printf("\r\n  ");
                            pc.printf(hex16(bl_cnt2));
                            pc.printf(" : ");
                        }
                        pc.printf(hex8(data[bl_cnt2]));
                        pc.printf(", ");
                    }
                    pc.printf("\r\n}");
                }
                bootloader_cbx_counter++;
                bl_send_buffer[0] = (char)(ext >> 8);
                bl_send_buffer[1] = (char)(ext & 0xff);
                for (bl_cnt2 = 0; bl_cnt2 < BL_SIZE; bl_cnt2++) {
                    bl_send_buffer[bl_cnt2 + 2] = data[bl_cnt2 + 1];
                }
                if (debug_bootloader) {
                    pc.printf("\r\npacote HDR->SRV {");
                    for (bl_cnt2 = 0;bl_cnt2 < UDP_BL_SIZE;bl_cnt2++) {
                        if ((bl_cnt2 % 30) == 0) {
                            pc.printf("\r\n  ");
                            pc.printf(hex16(bl_cnt2));
                            pc.printf(" : ");
                        }
                        pc.printf(hex8(bl_send_buffer[bl_cnt2]));
                        pc.printf(", ");
                    }
                    pc.printf("\r\n}");
                }
                int udp_bl_client_ret = udp_bl_client.sendTo ( udp_bl_server, bl_send_buffer, UDP_BL_SIZE );
                if ( udp_bl_client_ret not_eq UDP_BL_SIZE )
                {
                        reconnect_bl ();
                        miss_bl_udp_send_pkg ++;
                        if ( debug_reconnect ) vz_printf ( "[%d] Reconnect BL - %d", ext, udp_bl_client_ret );
                }
            }
            break;

            case PROMPT : {
                Call_Box * cb = find_CB ( v_cb, ext );

                if ( cb == NULL ) cb = try_add_new_cbx ( v_cb, ext );

                if( cb != NULL ) cb -> registry ();

                if ( ( strncasecmp ( ( const char * )data, "ping", 4 ) == 0 ) or ( strncasecmp ( ( const char * )data, "pong", 4 ) == 0 ) )
                {
                    if( debug_ping ) vz_printf ( "[%d %d] Prompt pkg :: Ping", ext, port );
                } 
                    else 
                {
                    prompt_counter++;
                    
                    vz_printf ( "[%i, %i] Prompt pkg::", ext, port );
                    
                    for( register uint8_t i = 0; i < 32; i++ ) {
                        if( debug_uart3 ) pc.printf("%c", data[ i ] );
                        if( i == 15 ) if( debug_uart3 ) pc.printf( "\r\n" );
                    }
                    if( debug_uart3 ) pc.printf("\n\r> ");

                    if( tcp_session ) {
                        char aux[ CB_BUFFER_SIZE + 3 ];
                        strncpy( aux, (char * )data, CB_BUFFER_SIZE );
                        strcat( aux, "\n\r\0" );
                        tcp_client.send_all( ( char *)data, strlen( (char * )data ) );
                        tcp_client.send_all( "\r\n> ", strlen( "\r\n> " ) );
                    }
                }
            }
            break;
            
            case AUDIO : {
                audio_counter++;
                if ( received_audio_from_cb ) {
                    vz_debug ("[%d] audio pkg", ext );    
                }
                
                VZ_call * call = find_Call ( v_call, ext );
                if ( call != NULL )
                {
                    if ( drop_rtp_from_cbx_pkg )
                    {
                        led2 = !led2;
                        break;
                    } else {
                        char * pkg = call -> build_eth_package ( data + 2 );
                        call -> send_message ( pkg );
                        call -> cbx_pkg_idle_timer_reset ();
                    }
                } 
                
                Call_Box * cb = find_CB ( v_cb, ext );       
                if ( cb != NULL )
                {
                    if ( cb -> get_invite_response () == false )
                    {
                        cb -> set_invite_response_ok ();
                        cb -> invite_retry_count_reset ();
                    } 
                } else {
                    if ( debug_main ) vz_debug ("[%d] received missed package", ext );
                }
            }
            break;
        }// fim switch
        
        // rajada
        if( invite_retry_timer.read_ms() >= 20 )
        {
            invite_ack_to_cb_handler ( v_cb, v_call );
            
            invite_retry_timer.reset();
        }    
    
        check_audio_from_ast ( v_cb, v_call );        

        wake_up_or_refresh_handler ( v_cb );

        check_sip_messages_from_ast ( v_cb, v_call );
        
        /* Verifica andamento de ligações para eventualmente encerra-las por timeout */
        call_manager( v_call, v_cb, ts );

        invite_handler( v_call, v_cb, ts, NULL );

        check_for_runaways_ts ( v_cb, ts );
        
        check_for_unwanted_rtp_ports ( v_cb );
        
        tx_buffer_ring_buffer_handler();

        type = DO_NOTHING;

        if( eth_status == 0 ) eth_wdt = ETH_CONNECT_TIMEOUT;

        if( wdt_timer.read() >= 1 ) {
            if ( -1 == wdt_update () ) vz_debug ("Erro!!!!!");
            wdt_timer.reset();
        }

        if( debug_wdt )
        {
            show_wdt_status ();
            debug_wdt = false;   
        }
        
        update_all_cb_timer ( v_cb );
        
        if ( !dont_say_hello_again ) send_hello_to_cbx ();
        
        /* Verificacao da fonte de alimentacao */
        if ( power_source_timer.read () > 1 )
        {
            check_power_source ();
        }
        
%: ifdef MODE_TEST
        wdt.kick();
%: endif
    }// fim while
}// fim main \o/