#include "file_system_manager.h"

QSPIFileSystem qspifs("qspi");

extern Serial pc;

char file_buffer [ FILE_BUFFER_SIZE ];

int fset_header_ip ( const char * new_header_ip )
{
    FILE * fip = fopen("/qspi/myip.txt", "w");
    if ( fip )
    {
        fprintf( fip, "%s\n\r", new_header_ip  );
        fclose( fip );
        return ( 0 );
    }
        else
    {
        return ( -1 );
    }
}

int fget_ip ( char * header_ip, const size_t length )
{
    FILE * fip = fopen ("/qspi/myip.txt", "r" );
    if ( fip != NULL )
    {
        int read = fread ( header_ip, 1, length, fip );
        if( read > 0 )
        {
            for ( register int i = 0; i < read; i++ )
            {
                if( header_ip [ i ] == '\n' || header_ip [ i ] == '\r' )
                {
                    header_ip [ i ] = '\0';
                    break;
                }
            }
        } else {
            if ( fip ) fclose ( fip );
            return ( -3 );
        }
        
        header_ip [ length ] = 0;

        if ( fip ) fclose ( fip );
        
        return ( read );
    } 
    
    return ( -1 );
}

int fget_fw_ip ( char * fw_ip, const size_t length )
{
    FILE *ffw_ip = fopen( "/qspi/fw_ip.txt", "r");
    if( ffw_ip == NULL ){
        return ( -1 );
    }else{
        int read = fread( fw_ip, 1, 512, ffw_ip );
        if( read > 0 ){
            for( int i = 0; i < read; i++ ) 
                if( fw_ip[ i ] == '\n' || fw_ip[ i ] == '\r' ){
                    fw_ip[ i ] = '\0';
                    break;
                }           
        }else{
           if ( ffw_ip ) fclose ( ffw_ip );
           return ( -3 );
        }
        
       if ( ffw_ip ) fclose ( ffw_ip );
       
       fw_ip [ length ] = 0;
       
       return ( read );
    }
 }

int fget_server_ip ( char * server_ip, const size_t length )
{
    FILE * fsip = fopen ("/qspi/serverip.txt", "r" );
    if ( fsip != NULL )
    {
        int read = fread ( server_ip, 1, length, fsip );
        if( read > 0 )
        {
            for ( register int i = 0; i < read; i++ )
            {
                if( server_ip [ i ] == '\n' || server_ip [ i ] == '\r' )
                {
                    server_ip [ i ] = '\0';
                    break;
                }
            }
        } else {
            if ( fsip ) fclose ( fsip );
            return ( -3 );
        }
        
        server_ip [ length ] = 0;

        fclose ( fsip );
        
        return ( read );
    } 
    
    return ( -1 );
}

int fget_mask ( char * eth_mask, const size_t length )
{
    FILE * fmsk = fopen("/qspi/mymask.txt", "r");
    if ( fmsk != NULL )
    {
        int read = fread ( eth_mask, 1, length, fmsk );
        if( read > 0 )
        {
            for ( register int i = 0; i < read; i++ )
            {
                if( eth_mask [ i ] == '\n' || eth_mask [ i ] == '\r' )
                {
                    eth_mask [ i ] = '\0';
                    break;
                }
            }
        } else {
            if ( fmsk ) fclose ( fmsk );
            return ( -3 );
        }
        
        eth_mask [ length ] = 0;

        if ( fmsk ) fclose ( fmsk );
        
        return ( read );
    } 
    
    return ( -1 );    
}

int fget_gateway ( char * eth_gw, const size_t length )
{
    FILE * fgw = fopen("/qspi/mygateway.txt", "r");
    if ( fgw != NULL )
    {
        int read = fread ( eth_gw, 1, length, fgw );
        if( read > 0 )
        {
            for ( register int i = 0; i < read; i++ )
            {
                if( eth_gw [ i ] == '\n' || eth_gw [ i ] == '\r' )
                {
                    eth_gw [ i ] = '\0';
                    break;
                }
            }
        } else { 
            if ( fgw ) fclose ( fgw );
            return ( -3 );
        }
        
        eth_gw [ length ] = 0;

        if ( fgw ) fclose ( fgw );
        
        return ( read );
    } 
        
    return ( -1 );        
}

int fset_header_ext ( const int new_header_ext )
{
    FILE * fext = fopen( "/qspi/myext.txt", "w" );
    if ( fext )
    {
        fprintf( fext, "%i\n\r", new_header_ext );
        fclose( fext );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fset_acceptable_delay ( const int new_acceptable_delay )
{
    FILE * fad = fopen( "/qspi/acceptable_delay.txt", "w" );
    if ( fad )
    {
        fprintf ( fad, "%i\n\r", new_acceptable_delay );
        fclose ( fad );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fget_acceptable_delay ( void )
{
    char get_acceptable_delay_buffer [ 32 ] = "";
    
    FILE * fad = fopen ( "/qspi/acceptable_delay.txt", "r" );
    if ( fad == NULL )
    {   
        return ( -3 );
    } else {
        if( fread ( ( void * ) get_acceptable_delay_buffer, 1, sizeof ( get_acceptable_delay_buffer ) - 1, fad ) > 0 )
        {
            if ( fad ) fclose ( fad );
            return ( atoi ( get_acceptable_delay_buffer ) );
        } else {
            if ( fad ) fclose ( fad );
            return ( -5 );
        }
    }
}

int fget_header_ext ( void )
{
    char get_header_ext_buffer [ 32 ] = "";
    
    FILE * fext = fopen ( "/qspi/myext.txt", "r" );
    if ( fext == NULL )
    {   
        return ( -3 );
    } else {
        if( fread ( ( void * ) get_header_ext_buffer, 1, sizeof ( get_header_ext_buffer ) - 1, fext ) > 0 )
        {
            if ( fext ) fclose ( fext );
            return ( atoi ( get_header_ext_buffer ) );
        } else {
            if ( fext ) fclose ( fext );
            return ( -5 );
        }
    }
}

int fset_header_sip_port ( const int new_header_sip_port )
{
    FILE * fport = fopen("/qspi/mysipport.txt", "w");
    if ( fport )
    {
        fprintf( fport,"%i\n\r", new_header_sip_port );
        fclose( fport );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fget_header_sip_port ( void )
{
    char get_header_sip_port_buffer [ 32 ] = "";
    
    FILE * fport = fopen ( "/qspi/mysipport.txt", "r" );
    if ( fport == NULL )
    {
        return ( -1 );
    } else {
        if( fread ( ( void * ) get_header_sip_port_buffer, 1, sizeof ( get_header_sip_port_buffer ) - 1, fport ) > 0 )
        {
            if ( fport ) fclose ( fport );
            return ( atoi ( get_header_sip_port_buffer ) );
        } else {
            if ( fport ) fclose ( fport );
            return ( -3 );
        }
    }
}

int fset_server_ip ( const char * new_server_ip )
{
    FILE * fsip = fopen("/qspi/serverip.txt", "w");
    if ( fsip )
    {
        fprintf( fsip,"%s\n\r", new_server_ip );
        fclose( fsip );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fset_server_ext ( const int new_server_ext )
{
    FILE * fserext = fopen("/qspi/peerext.txt", "w");
    if ( fserext )
    {
        fprintf( fserext , "%i\n\r", new_server_ext );
        fclose( fserext );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fget_server_ext ( void )
{
    char get_server_ext_buffer [ 32 ] = "";
    
    FILE * fserver_ext = fopen ( "/qspi/peerext.txt", "r" );
    if ( fserver_ext == NULL )
    {   
        return ( -3 );
    } else {
        if( fread ( ( void * ) get_server_ext_buffer, 1, sizeof ( get_server_ext_buffer ) - 1, fserver_ext ) > 0 )
        {
            if ( fserver_ext ) fclose ( fserver_ext );
            return ( atoi ( get_server_ext_buffer ) );
        } else {
            if ( fserver_ext ) fclose ( fserver_ext );
            return ( -5 );
        }
    }
}

int fset_server_port ( const int new_server_port )
{
    FILE * fsport = fopen("/qspi/serverport.txt", "w");   
    if ( fsport )
    {
        fprintf(fsport,"%i\n\r", new_server_port );
        fclose( fsport );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fget_server_port ( void )
{
    char get_server_sip_port_buffer [ 32 ] = "";
    
    FILE * fserver_port = fopen ( "/qspi/serverport.txt", "r" );
    if ( fserver_port == NULL )
    {
        return ( -1 );
    } else {
        if( fread ( ( void * ) get_server_sip_port_buffer, 1, sizeof ( get_server_sip_port_buffer ) - 1, fserver_port ) > 0 )
        {
            if ( fserver_port ) fclose ( fserver_port );
            return ( atoi ( get_server_sip_port_buffer ) );
        } else {
            if ( fserver_port ) fclose ( fserver_port );
            return ( -3 );
        }
    }
}

int fset_mask ( const char * new_mask )
{
    FILE * fmask = fopen("/qspi/mymask.txt", "w");
    if ( fmask )
    {
        fprintf(fmask,"%s\n\r",new_mask );
        fclose( fmask );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fset_gateway ( const char * new_gateway )
{
    FILE * fgate = fopen("/qspi/mygateway.txt", "w");
    if ( fgate )
    {
        fprintf(fgate,"%s\n\r", new_gateway );
        fclose( fgate );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int set_udp_port_listener ( const int new_udp_port_listener )
{
    FILE * fudpport = fopen( "/qspi/udpport.txt", "w" );
    if ( fudpport )
    {
        fprintf( fudpport, "%i\n\r",new_udp_port_listener );
        fclose( fudpport );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fget_udp_port_listener ( void )
{
    char get_udp_port_listener_buffer [ 32 ] = "";
    
    FILE * fudp_port_listener = fopen ( "/qspi/udpport.txt", "r" );
    if ( fudp_port_listener == NULL )
    {
        return ( -1 );
    } else {
        if( fread ( ( void * ) get_udp_port_listener_buffer, 1, sizeof ( get_udp_port_listener_buffer ) - 1, fudp_port_listener ) > 0 )
        {
            if ( fudp_port_listener ) fclose ( fudp_port_listener );
            return ( atoi ( get_udp_port_listener_buffer ) );
        } else {
            if ( fudp_port_listener ) fclose ( fudp_port_listener );
            return ( -3 );
        }
    }
}

int set_tcp_port_listener ( const int new_tcp_port_listener )
{
    FILE * ftcpport = fopen( "/qspi/tcpport.txt", "w" );
    if ( ftcpport )
    {
        fprintf( ftcpport, "%i\n\r",new_tcp_port_listener );
        fclose( ftcpport );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fget_tcp_port_listener ( void )
{
    char get_tcp_port_listener_buffer [ 32 ] = "";
    
    FILE * ftcp_port_listener = fopen ( "/qspi/tcpport.txt", "r" );
    if ( ftcp_port_listener == NULL )
    {
        return ( -1 );
    } else {
        if( fread ( ( void * ) get_tcp_port_listener_buffer, 1, sizeof ( get_tcp_port_listener_buffer ) - 1, ftcp_port_listener ) > 0 )
        {
            if ( ftcp_port_listener ) fclose ( ftcp_port_listener );
            return ( atoi ( get_tcp_port_listener_buffer ) );
        } else {
            if ( ftcp_port_listener ) fclose ( ftcp_port_listener );
            return ( -3 );
        }
    }
}

int fset_fw_ip ( const char * new_fw_ip )
{
    FILE * ffwip = fopen("/qspi/fw_ip.txt", "w" );
    if ( ffwip )
    {
        fprintf(ffwip,"%s\n\r", new_fw_ip );
        fclose( ffwip );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fset_fw_port ( const int new_fw_port )
{
    FILE * ffwport = fopen("/qspi/fw_port.txt", "w" );
    if ( ffwport )
    {
        fprintf(ffwport,"%i\n\r", new_fw_port );
        fclose( ffwport );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fget_fw_port ( void )
{
    char get_fw_server_port_buffer [ 32 ] = "";
    
    FILE * ffw_server_port = fopen ( "/qspi/fw_port.txt", "r" );
    if ( ffw_server_port == NULL )
    {
        return ( -1 );
    } else {
        if( fread ( ( void * ) get_fw_server_port_buffer, 1, sizeof ( get_fw_server_port_buffer ) - 1, ffw_server_port ) > 0 )
        {
            if ( ffw_server_port ) fclose ( ffw_server_port );
            return ( atoi ( get_fw_server_port_buffer ) );
        } else {
            if ( ffw_server_port ) fclose ( ffw_server_port );
            return ( -3 );
        }
    }
}

int fset_max_ext ( const int new_max_ext )
{
    FILE * fmex = fopen( "/qspi/maxext.txt", "w" );
    if ( fmex ){
        fprintf( fmex, "%i\n\r", new_max_ext );
        fclose( fmex );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fget_max_ext ( void )
{
    char get_max_ext_buffer [ 32 ] = "";
    
    FILE * fmax_ext = fopen ( "/qspi/maxext.txt", "r" );
    if ( fmax_ext == NULL )
    {
        return ( -1 );
    } else {
        if( fread ( ( void * ) get_max_ext_buffer, 1, sizeof ( get_max_ext_buffer ) - 1, fmax_ext ) > 0 )
        {
            if ( fmax_ext ) fclose ( fmax_ext );
            return ( atoi ( get_max_ext_buffer ) );
        } else {
            if ( fmax_ext ) fclose ( fmax_ext );
            return ( -3 );
        }
    }
}

int fset_min_ext ( const int new_min_ext )
{
    FILE * fmin = fopen( "/qspi/minext.txt", "w" );
    if ( fmin ){
        fprintf( fmin, "%i\n\r", new_min_ext );
        fclose( fmin );
        return ( 0 );
    }
        else
    {
        return ( -1 );    
    }
}

int fget_min_ext ( void )
{
    char get_min_ext_buffer [ 32 ] = "";
    
    FILE * fmin_ext = fopen ( "/qspi/minext.txt", "r" );
    if ( fmin_ext == NULL )
    {
        return ( -1 );
    } else {
        if( fread ( ( void * ) get_min_ext_buffer, 1, sizeof ( get_min_ext_buffer ) - 1, fmin_ext ) > 0 )
        {
            if ( fmin_ext ) fclose ( fmin_ext );
            return ( atoi ( get_min_ext_buffer ) );
        } else {
            if ( fmin_ext ) fclose ( fmin_ext );
            return ( -3 );
        }
    }
}

// Print the content of a given file
int cat ( const char * fname )
{
    char buff[513];
    int num;
    
    FILE * fp = fopen( fname, "r" );
    if ( fp == NULL )
    {
        pc.printf( "Failed to open %s", fname);
        return ( -3 );
    }
    
    while( ( num = fread( buff, 1, 512, fp ) ) > 0 )
    {
        buff[ num ] = '\0';
        pc.printf( "%s", buff );
    }
    
    if ( fp ) fclose ( fp );
    
    return ( 0 );
}

int fset_shift_port ( const int new_shift_port )
{
    FILE * shift_port = fopen("/qspi/shift_port.txt", "w" );
    if( shift_port )
    {
        fprintf( shift_port,"%i\n\r", new_shift_port );
        fclose( shift_port );
        return ( 0 );
    }
        else
    {
        return ( -1 );
    }
}


int fget_shift_port ( void )
{
    char get_shift_port_buffer [ 32 ] = "";
    
    FILE * fshift_port = fopen ( "/qspi/shift_port.txt", "r" );
    if ( fshift_port == NULL )
    {
        return ( -1 );
    } else {
        if( fread ( ( void * ) get_shift_port_buffer, 1, sizeof ( get_shift_port_buffer ) - 1, fshift_port ) > 0 )
        {
            if ( fshift_port ) fclose ( fshift_port );
            return ( atoi ( get_shift_port_buffer ) );
        } else {
            if ( fshift_port ) fclose ( fshift_port );
            return ( -3 );
        }
    }
}

int files ( const char type )
{       
    if ( type == 's' ) {     
        pc.printf("Header IP " );
        cat ("/qspi/myip.txt");

        pc.printf("Header ext ");
        cat("/qspi/myext.txt");

        pc.printf("Header port ");
        cat("/qspi/mysipport.txt");

        pc.printf("Server IP ");
        cat("/qspi/serverip.txt");

        pc.printf("Server ext ");
        cat("/qspi/peerext.txt");

        pc.printf("Server port ");
        cat("/qspi/serverport.txt");

        pc.printf("Mascara de rede ");
        cat("/qspi/mymask.txt");

        pc.printf("Gateway IP ");
        cat("/qspi/mygateway.txt");

        pc.printf("UDP Port ");
        cat("/qspi/udpport.txt");

        pc.printf("TCP Port ");
        cat("/qspi/tcpport.txt");

        pc.printf("FW Server IP ");
        cat("/qspi/fw_ip.txt");

        pc.printf("FW Server Port ");
        cat("/qspi/fw_port.txt");

        pc.printf("Max Ext ");
        cat("/qspi/maxext.txt");

        pc.printf("Min Ext ");
        cat("/qspi/minext.txt");
        
        pc.printf("Shift Port ");
        cat("/qspi/shift_port.txt");

        pc.printf("Clock Server IP ");
        cat("/qspi/serverip.txt");
            
        return ( 0 );
    }
    
    return ( -1 );
}

int init_fsystem ( void )
{
    //  init file system and check if files exist
    int return_value = 0;
    
    if (!qspifs.isformatted()) {
        qspifs.format();
        return_value |= BIT0;
    }
    
    return ( return_value |= BIT1 );
}

int fset_cbx_detach_mode ( const bool new_cbx_detach_mode )
{
    FILE * file_cbx_detach_mode = fopen ("/qspi/cbx_detach_mode.txt", "w" );
    if ( file_cbx_detach_mode )
    {
        fprintf ( file_cbx_detach_mode,"%i\n\r", ( new_cbx_detach_mode ) ? 1 : 0 );
        fclose ( file_cbx_detach_mode );
        return ( 0 );
    }
        else
    {
        return ( -1 );
    }
}

bool fget_cbx_detach_mode ( int * err )
{
    char get_cbx_detach_mode_buffer [ 32 ] = "";
    
    FILE * file_cbx_detach_mode = fopen ( "/qspi/cbx_detach_mode.txt", "r" );
    if ( file_cbx_detach_mode == NULL )
    {
        *err = -1;
    } else {
        if( fread ( ( void * ) get_cbx_detach_mode_buffer, 1, sizeof ( get_cbx_detach_mode_buffer ) - 1, file_cbx_detach_mode ) > 0 )
        {
            if ( file_cbx_detach_mode ) fclose ( file_cbx_detach_mode );
            int tmp = atoi ( get_cbx_detach_mode_buffer );
            
            return ( ( tmp == 1 ) ? true : false );
        } else {
            if ( file_cbx_detach_mode ) fclose ( file_cbx_detach_mode );
            *err = -3;
        }
    }
    
    return false;
}

int fset_cbx_wake_mode ( const bool new_cbx_wake_mode )
{
    FILE * file_cbx_wake_mode = fopen ("/qspi/cbx_wake_mode.txt", "w" );
    if ( file_cbx_wake_mode )
    {
        fprintf ( file_cbx_wake_mode,"%i\n\r", ( new_cbx_wake_mode ) ? 1 : 0 );
        fclose ( file_cbx_wake_mode );
        return ( 0 );
    }
        else
    {
        return ( -1 );
    }
}

bool fget_cbx_wake_mode ( int * err )
{
    char get_cbx_wake_mode_buffer [ 32 ] = "";
    
    FILE * file_cbx_wake_mode = fopen ( "/qspi/cbx_wake_mode.txt", "r" );
    if ( file_cbx_wake_mode == NULL )
    {
        *err = -1;
    } else {
        if( fread ( ( void * ) get_cbx_wake_mode_buffer, 1, sizeof ( get_cbx_wake_mode_buffer ) - 1, file_cbx_wake_mode ) > 0 )
        {
            if ( file_cbx_wake_mode ) fclose ( file_cbx_wake_mode );
            int tmp = atoi ( get_cbx_wake_mode_buffer );
            
            return ( ( tmp == 1 ) ? true : false );
        } else {
            if ( file_cbx_wake_mode ) fclose ( file_cbx_wake_mode );
            *err = -3;
        }
    }
    
    return false;
}

int fset_cbx_mode ( const uint8_t new_cbx_mode )
{
    FILE * file_cbx_mode = fopen ("/qspi/cbx_mode.txt", "w" );
    if ( file_cbx_mode )
    {
        fprintf ( file_cbx_mode,"%i\n\r", new_cbx_mode );
        fclose ( file_cbx_mode );
        return ( 0 );
    }
        else
    {
        return ( -1 );
    }
}

int fget_cbx_mode ( void )
{
    char get_cbx_mode_buffer [ 32 ] = "";
    
    FILE * file_cbx_mode = fopen ( "/qspi/cbx_mode.txt", "r" );
    if ( file_cbx_mode == NULL )
    {
        return ( -1 );
    } else {
        if( fread ( ( void * ) get_cbx_mode_buffer, 1, sizeof ( get_cbx_mode_buffer ) - 1, file_cbx_mode ) > 0 )
        {
            if ( file_cbx_mode ) fclose ( file_cbx_mode );
            return ( atoi ( get_cbx_mode_buffer ) );
        } else {
            if ( file_cbx_mode ) fclose ( file_cbx_mode );
            return ( -3 );
        }
    }
}