#include "eth.h"

EthernetInterface eth;

int __init_eth__ ( void )
{    
    static bool initialized = false;
    char buffer_header_ip [ 16 ] = "";
    char buffer_header_mask [ 16 ] = "";
    char buffer_header_gateway [ 16 ] = "";
    if( debug_uart3 ) pc.printf("\n\r");
    
    cm -> get_header_ip ( buffer_header_ip ); 
    cm -> get_net_mask ( buffer_header_mask );
    cm -> get_gateway ( buffer_header_gateway );
    
    if( !initialized ){
        eth.init( buffer_header_ip, buffer_header_mask, buffer_header_gateway );
        initialized = true;
        return eth.connect();
    }
    if( !eth.disconnect() ){
        return eth.connect();
    }
    else{
        return eth.connect();
    }
}

void __reconnect ( void )
{
    eth.disconnect ();
    __init_eth__ ();
}