#include "configs.h"

//*****************************************************************************
//                             Pins/Modules Config
//***************************************************************************** 

InterruptIn NextData(p8);                   // IO 96
InterruptIn FrameSync(p17);                 // GCLK1

//Ticker ticker;                            // Timer para Debug

DigitalOut RST(p29);                        // Pino de reset para o CPLD
DigitalIn PPD(p25);                         // Pino de conexao com o cristal do CPLD

DigitalOut ENABLE_F_REG(p18);               // Configuracao da Alimentacao do CPLD
DigitalOut ENABLE_F_RX(p19);
DigitalOut ENABLE_F_TX(p20);

Serial  Uart3(p9,p10);  // default baudrate = 9600; Sem paridade, 8bits, 1 stop-bit 

int start_cpld( void ) {                        //CPLD Start
    static uint16_t reset = 10000;
    ENABLE_F_REG = 1;                                
    ENABLE_F_TX = 1;
    ENABLE_F_RX = 1;
    DataReady = 0;
    RST = 1;
    while( reset-- > 1 ){}
    RST = 0;
    return ( 0 );
}

///< Configure LPC4088
int config_lpc( void ){
    // UART3_IRQ configuration
    Uart3.attach(&SerialRecvInterrupt, Uart3.RxIrq);
    
    // UART3 mode configuration
    Uart3.format(8,SerialBase::Forced1,1);
    
    Uart3.baud(2000000);                                
    
    NVIC_SetPriority(UART3_IRQn,1);
    
    // USART to PC USB USART
    pc.baud(115200);
    
    // Extern Pin Interrupt
    NextData.rise(&get2);
    
    // FrameSync for RX - Interrupt
    FrameSync.rise(&RXFrameSync);
    
    __enable_irq();
    
    // iniciando o pin de controle do arduino
    hw_extern_wdt = 0;
    
    return ( 0 );
}