#include "call_box.h"

Call_Box::Call_Box( const int ext, const int port )
{
    this -> ext = ext;
    this -> port = port;
    
    t.start ();
    msg_id = 0x10;
    timeslice = 0x00;
    status = cb_idle;
    
    shift_port = cm -> get_shift_port ();
        
    sip = new Sip( ext, ext + shift_port );
    
    if ( sip == NULL )
    {
        memory_is_over = true;
        if ( debug_memory ) vz_debug ("[%d] Sip allocation fail", this->ext );
    } else {
        sip_socket_fd = sip->get_socket_fd ();
    }
    
    invite_response = true;
    bye_response = true;
    invite_retry_count = MAX_INVITE_RETRY;
    cb_new_counter++;
    invite_try_number = 0;
    overflow = false;
    overflow_times = 0;
    invite_counter = 0;
    
    pair = NULL;
}

int Call_Box::get_status ( void ) { return this->status; }

void Call_Box::cb_set_status ( const uint8_t status ){ this->status = status; }

int Call_Box::get_sip_status ( void )
{
    if ( sip == NULL ) return ( -1 );
    
    return ( sip -> get_status () );
}

Call_Box::~Call_Box( void ){
    if ( sip not_eq NULL ) delete ( sip );
    cb_delete_counter++;
}

int Call_Box::get_port ( void ) { return ( this->port ); }

int Call_Box::get_ext ( void ) { return ( this->ext ); }

uint16_t Call_Box::get_elapsed_time ( void ) {  return ( ( uint16_t ) this -> t.read_ms () ); }

void Call_Box::reset_elapsed_time ( void )
{ 
    this -> t.stop ();
    this -> t.reset (); 
    this -> t.start ();
    overflow = false;
    overflow_times = 0;
}

int Call_Box::registry ( void )
{
    if ( drop_registry_pkg )
    {
        vz_printf ("[%d] Dropando registry pck", this->ext );
        return -5;
    }    
    
    reset_elapsed_time ();
    
    if ( this -> sip not_eq NULL )
    {
        int return_value = sip -> registry ();
        
        if ( return_value > 0 ) 
        {   
            if ( debug_aging ) vz_printf ( "[%d] Registered", this->ext );
            
            return ( return_value );
        }
    } else {
        vz_debug ("[%d] Eu definitivamente nao deveria estar aqui!!!", this->ext );
        deleted_sip++;
        return ( -3 );
    }
    
    return ( 0 );
}

VZ_call * Call_Box::invite ( void )
{
    VZ_call * call = NULL;
    
    if ( this->sip not_eq NULL )
    {
        call = sip->invite ();
    } else {   
        vz_debug ("[%d] Eu definitivamente nao deveria estar aqui!!!", this->ext );
        
        deleted_sip++;
    }
    
    if ( debug_cb ) vz_printf ("[%d] Call returned value :: %p ", this->ext, ( void * ) call );
    
    if ( call == NULL ) t.start ();
    
    return ( call );
}

/*  Retorna 
    = 0 :: ok
    < 0 :: tive problemas
    > 0 :: devo remover essa call do vetor de calls 
*/
int Call_Box::listen_SIP_server ( void )
{
    if ( this->sip == NULL )
    {
        vz_debug ("[%d] Eu definitivamente nao deveria estar aqui!!!", this->ext );
        
        deleted_sip++;
        
        return ( -3 );
    } else {
        if ( status == cb_on_call or status == cb_idle )
        {
            return ( sip -> listen_SIP_server () );
        } else return ( 0 );
    }
}

void Call_Box::set_msg_id ( const uint8_t msg_id ) { 
    this->msg_id = ( msg_id > 0x10 ) ? msg_id : 0x11;
}
uint8_t Call_Box::get_msg_id ( void ) { return ( this->msg_id ); }

void Call_Box::set_timeslice ( const uint8_t timeslice ) { 
    this->timeslice = timeslice;
}

uint8_t Call_Box::get_timeslice ( void ) { return ( this->timeslice ); }

void Call_Box::send_bye ( void )
{ 
    if ( this -> sip == NULL )
    {
        vz_debug ("[%d] Eu definitivamente nao deveria estar aqui!!!", this -> ext );
        
        deleted_sip ++;
    } else {
        sip -> send_bye ();
    }
}

void Call_Box::set_sip_status ( const uint8_t new_sip_status )
{
    if ( this->sip not_eq NULL )
    {
        this -> sip -> sip_set_status ( new_sip_status );
    } else 
    {
        if ( debug_cb) vz_debug ("[%d] Sip equals NULL o.O", this->ext );
        deleted_sip++;
        vz_debug ("[%d] Sip equals NULL o.O", this->ext );
    }        
}

void Call_Box::set_invite_response_ok ( void )
{ 
    this -> invite_response = true; 
    if ( debug_invite ) vz_debug ("[%d] Invite response :: ok", this->ext );
}

void Call_Box::set_invite_response_pending ( void ) { this->invite_response = false; }

bool Call_Box::get_invite_response ( void ) { return ( this->invite_response ); }

void Call_Box::invite_retry_count_reset ( void ) { invite_retry_count = MAX_INVITE_RETRY; }

uint16_t Call_Box::get_invite_retry_count( void ){ 
    return ( invite_retry_count ) ? invite_retry_count-- : 0;
}

void Call_Box::set_bye_response_ok ( void ) { this->bye_response = true; }

int Call_Box::get_sip_socket_fd ( void ) { return ( sip_socket_fd ); }

int Call_Box::sip_udp_incomming_pkg ( void ) {
    return sip -> udp_incomming_pkg ();
}

void Call_Box::reset_cb_status ( void ) { if ( sip not_eq NULL ) sip -> reset_call (); }

int Call_Box::get_sip_ext ( void ) { return this -> sip->get_ext (); }

int Call_Box::get_sip_port ( void ) { return this -> sip->get_port (); }

int Call_Box::get_timer ( void )
{
    int now = t.read ();

    if ( now >= 1500 or now < 0 ) 
    {        
        this -> t.stop ();
        this -> t.reset ();
        this -> t.start ();
        overflow = true;
        if ( overflow_times not_eq 0xfe ) overflow_times++;
    }
    
    return ( now );
}

int Call_Box::get_rtp_port ( void )
{
    if ( this -> sip not_eq NULL )
    {
        return this -> sip -> get_sip_rtp_port ();
    } else {
        vz_debug ("[%d] Eu definitivamente nao deveria estar aqui!!!", this->ext );
        
        deleted_sip++;
        
        return -1;
    }
}

void Call_Box::set_rtp_port ( const int new_rtp_port )
{
    if ( this->sip not_eq NULL )
    {
        this->sip->set_sip_rtp_port( new_rtp_port );
    }else{
        vz_debug ("[%d] Eu definitivamente nao deveria estar aqui!!!", this->ext );
        
        deleted_sip++;
    }
}

void Call_Box::init_rtp_timer ( void )
{
    this -> rtp_timer.start ();   
}

void Call_Box::reset_rtp_timer ( void )
{
    this -> rtp_timer.stop ();
    this -> rtp_timer.reset ();
}

bool Call_Box::is_rtp_timer_timeout ( void )
{
    return ( rtp_timer.read () > RTP_REQUEST_PORT_TIMEOUT ) ? true : false;  
}

int Call_Box::print_yourself ( void )
{   
    vz_printf ("\r\n");
    vz_printf ("Values ::\r\n");
    switch( status ) {
        case cb_idle : {
            vz_printf ("status :: cb_idle" );
            break;
        }
        case cb_ringing : {
            vz_printf ("status :: cb_ringing" );
            break;
        }
        case cb_trying : {
            vz_printf ("status :: cb_trying" );
            break;
        }
        case cb_on_call : {
            vz_printf ("status :: cb_on_call" );
            break;
        }
        case cb_busy : {
            vz_printf ("status :: cb_busy" );
            break;
        }
        case cb_denied : {
            vz_printf ("status :: cb_denied" );
            break;
        }
    }
    vz_printf ("ext :: %i", ext );
    vz_printf ("port :: %i", port );
    vz_printf ("Timer t :: %d", ( int )t.read () );
    vz_printf ("overflow_times :: %u", overflow_times );
    vz_printf ("msg_id :: %d", msg_id );
    vz_printf ("timeslice :: %u", timeslice );
    vz_printf ("next_aging_type :: %u", next_aging_type );
    vz_printf ("invite_response :: %s", ( invite_response ) ? "true" : "false" );
    vz_printf ("invite_retry_count :: %u", invite_retry_count );
    vz_printf ("bye_response :: %s", ( bye_response ) ? "true" : "false" );
    vz_printf ("sip_socket_fd :: %d", sip_socket_fd );
    vz_printf ("\r\n");
    
    return ( sizeof( Call_Box ) );
}

int Call_Box::call_init ( const int timeslice )
{
    invite_timer.reset ();
 
    invite_timer.start ();
    
    this -> timeslice = timeslice;
    
    this -> status = cb_ringing;
    
    set_invite_response_pending ();            
    
    invite_try_number = 0;

    msg_id_update ();
    
    return 0;    
}

int 
Call_Box::call_end ( const bool send_bye_to_ast )
{
    uint8_t timeslice = this -> timeslice;
    
    this -> timeslice = 0;
    
    this -> status = cb_idle;
    
    if ( sip not_eq NULL ) {
        sip -> sip_set_status ( sip_idle );
    } else {
        if( debug_cb ) vz_debug ( "[%d] Sip equals NULL o.O", this -> ext );
    }
    
    set_rtp_port ( 0 );
    
    reset_rtp_timer ();
    
    if ( send_bye_to_ast )
    {
        if ( timeslice not_eq 0 ) send_bye ();
    }
    
    reset_cb_status ();
    
    invite_timer.stop ();
    
    invite_timer.reset ();
    
    invite_try_number = 0;
    
    msg_id_update ();
    
    reset_elapsed_time ();
    
    if ( pair not_eq NULL ) pair -> reset_elapsed_time ();
    
    return timeslice;
}

Call_Box * Call_Box::get_pair_cbx ( void ) { return ( this -> pair ); }

int 
Call_Box::set_pair_cbx ( Call_Box * new_cbx )
{
    int ret = 0;
    
    if ( new_cbx not_eq NULL )
    {
        if ( pair not_eq NULL ) ret = -3;
    
        else ret = 0;
        
        pair = new_cbx;
    } else { 
        ret = -1; 
    }
    
    return ( ret );
}

int Call_Box::call_confirmed ( void )
{
    set_invite_response_pending ();
    
    this -> status = cb_on_call;
    
    msg_id_update ();
    
    return 0;
}

uint8_t Call_Box::msg_id_update ( void )
{
    uint8_t update = ( msg_id + 1 ) bitand ( uint8_t ) compl BIT7;
    
    this -> msg_id = ( update > 0x10 ) ? update : 0x11;
    
    return this -> msg_id;
}

void Call_Box::call_config ( void )
{
    set_invite_response_ok (); 
    reset_rtp_timer ();
    init_rtp_timer ();    
}

bool Call_Box::time_to_retry ( void )
{
    if ( invite_timer.read_ms () > 1000 )
    {
        invite_timer.reset ();
        return true;
    } else {
        return false;    
    }
}

uint8_t Call_Box::get_invite_try_number ( void ) {return invite_try_number; }

int Call_Box::retry_send_invite_pkg_to_ast ( void )
{   
    if ( this -> sip not_eq NULL )
    {
        invite_try_number++;
        return (  sip -> retry_send_last_invite_pkg_to_ast () );
    } else {
        vz_debug ("[%d] Eu definitivamente nao deveria estar aqui!!!", this->ext );
        
        deleted_sip++;
        
        return ( 0 );
    }
}

int Call_Box::sip_print_yourself ( void )
{
    if ( this -> sip not_eq NULL )
    {
        return sip -> print_yourself ();
    } else {
        vz_debug ("[%d] Eu definitivamente nao deveria estar aqui!!!", this->ext );
        
        return ( -1 );
    }
    
}

Sip * Call_Box::get_sip ( void ) { return this -> sip ; }

bool Call_Box::get_overflow_flag ( void ) { get_timer () ; return ( this -> overflow ); }

uint8_t Call_Box::get_overflow_times ( void ) { return ( this -> overflow_times ); }

void Call_Box::update_time ( void ){ get_timer (); }

uint16_t Call_Box::get_invite_counter ( void ) { return ( this -> invite_counter ); }

uint16_t Call_Box::update_invite_counter ( void ) { return ( this -> invite_counter++ ); }

int Call_Box::update ( void )
{
    shift_port = cm -> get_shift_port ();
    
    if ( sip not_eq NULL )
    {
        sip -> set_port ( ext + shift_port );
        sip -> update ();
    }
    return ( 0 );    
}