#include "call.h"

VZ_call::VZ_call( int cb_ext, int cb_port, int rtp_server_ext, int rtp_server_port ){
    this->cb_ext = cb_ext;
    this->cb_port = cb_port;
    
    this->rtp_server_ext = rtp_server_ext;
    this->rtp_server_port = rtp_server_port;
    this->rtp_server.set_address( SERVER_IP, rtp_server_port );
    rtp_sock.set_blocking( false, 0 );
    this->rtp_sock.bind( cb_port ); // rtp port
    this->rtp_sock.init();
    this->rtp = new RTP( this->cb_ext );
    
    if( rtp == NULL )
    { 
        memory_is_over = true;
        if( debug_memory ) vz_debug ("[%d] Call_Box cb allocation fail", this->cb_ext );
    }
    
    t.start();
    finish.start();
    rtpbuf_clear( &( this->rtpbuf ) );
    call_new_counter++;
}

VZ_call::~VZ_call(){
    rtp_sock.close();
    delete( this->rtp );
    call_delete_counter++;
}

char * 
VZ_call::get_eth_message ( int * length )
{
    uint8_t * pkg;
    Endpoint rtp_from;
    
    *length = rtp_sock.receiveFrom ( rtp_server, server2cb, sizeof( server2cb ) );
    t.reset();
    
    rtpbuf_next ( &rtpbuf );
    
    if ( *length > 0 )
    {
        rtpbuf_put ( &rtpbuf, *length - ( RTP_HEADER_SIZE + ( server2cb [ 0 ] & 0xf ) ), 
            ( uint8_t * )server2cb + ( RTP_HEADER_OFFSET + ( server2cb [ 0 ] & 0xf ) ) );
    } 
        else if ( *length == -1 )
    {
        miss_rtp_udp_rcv_pkg ++;
        reconnect ();
    }
    
    pkg = rtpbuf_get ( &rtpbuf );
    
    if ( pkg != NULL )
    {
        *length = 240;
        return (char *)pkg;
    }
    
    *length = 0;
    return NULL;
}

int 
VZ_call::send_message ( char * buffer  )
{
    this -> t.reset ();
    const uint16_t SEND_MSG_SIZE = CB_AUDIO_DATA_SIZE + this -> rtp -> header_size ();
    
    int send = this -> rtp_sock.sendTo ( this -> rtp_server, buffer, SEND_MSG_SIZE );
    
    if ( send not_eq SEND_MSG_SIZE )
    {   
        miss_rtp_udp_send_pkg ++;
        
        reconnect ();
    }
    
    return ( send );
}

char * VZ_call::build_eth_package( uint8_t * buffer ){
    return this->rtp->build_eth_package( ( char * )buffer );    
}

int VZ_call::get_cb_ext ()
{ 
    return this->cb_ext; 
}

int VZ_call::get_cb_port ()
{ 
    return this->cb_port; 
}

int VZ_call::get_rtp_server_ext(){ return rtp_server_ext; }
int VZ_call::get_rtp_server_port(){ return rtp_server_port; }

bool VZ_call::is_timetofinish( void ){
    return ( finish.read() > __MAX_CALL_TIME__ ) ? true : false;
}

uint16_t VZ_call::get_elapsed_time( void ){
    return ( finish.read_ms() );
}

void VZ_call::cbx_pkg_idle_timer_reset ( void ){
    cbx_pkg_idle_timer.reset();
}

bool VZ_call::cbx_pkg_is_idle( void ){
    return ( cbx_pkg_idle_timer.read() > CBX_PKG_IDLE_MAX_TIME ) ? true : false;
}

void VZ_call::init_cbx_pkg_idle_timer(){
    cbx_pkg_idle_timer.start();
}

int VZ_call::print_yourself ( void )
{
    vz_printf ("t :: %d", ( int  ) t.read () );
    vz_printf ("finish :: %d", ( int ) finish.read () );
    vz_printf ("cbx_pkg_idle_timer :: %d", ( int ) cbx_pkg_idle_timer.read () );
    vz_printf ("cb_port :: %d", cb_port );
    vz_printf ("cb2server :: %p", ( void * ) cb2server );
    vz_printf ("server2cb :: %p", ( void * ) server2cb );
    vz_printf ("buffer :: %p", ( void * ) buffer );
    vz_printf ("rtp_sock :: %p", ( void * )&rtp_sock );
    vz_printf ("rtp_server_ext :: %d", rtp_server_ext );
    vz_printf ("rtp_server_port :: %d", rtp_server_port );
    vz_printf ("rtp_server :: %p", &rtp_server );
    vz_printf ("rtp :: %p", ( void * ) rtp );
    vz_printf ("rtpbuf :: %p", ( void * ) &rtpbuf );
    return ( sizeof( VZ_call ) );
}

void * VZ_call::check_rtp ( void ) { return rtp; }

int VZ_call::rtp_print_yourself ( void )
{
    return rtp -> print_yourself ();
}

void 
VZ_call::reconnect ( void )
{
    this -> rtp_sock.close ();
    
    this -> rtp_sock.bind ( cb_port );
    
    this -> rtp_sock.set_blocking ( false, 0 );
}