/**
 * @file wdt.h
 * @Synopsis Implementa funcionalidade de watchdog 
 * @author Imported from MBED
 * @version 1
 * @date 2014-11-06
 */
#ifndef __WDT_H__
#define __WDT_H__

#include "EthernetInterface.h"
#include "mbed.h"
#include <stdint.h>

class Watchdog {
public:
    /// Create a Watchdog object
    ///
    /// example:
    /// @code
    /// Watchdog wd;    // placed before main
    /// @endcode
    Watchdog();
    
    /// Configure the timeout for the Watchdog
    ///
    /// This configures the Watchdog service and starts it. It must
    /// be serviced before the timeout, or the system will be restarted.
    ///
    /// example:
    /// @code
    ///     ...
    ///     wd.Configure(1.4);  // configure for a 1.4 second timeout
    ///     ...
    /// @endcode
    ///
    /// @param timeout in seconds, as a floating point number
    /// @returns none
    ///
    void Configure ( float timeout );
    
    /// Service the Watchdog so it does not cause a system reset
    ///
    /// example:
    /// @code
    ///    wd.Service();
    /// @endcode
    /// @returns none
    void kick ();
    
    /// WatchdogCausedReset identifies if the cause of the system
    /// reset was the Watchdog
    ///
    /// example:
    /// @code
    ///    if ( wd.WatchdogCausedReset() ){
    /// @endcode
    ///
    /// @returns true if the Watchdog was the cause of the reset
    bool WatchdogCausedReset ();
private:
    bool wdreset;
};
 
#endif