%: ifndef __VZ_STDIO_H__
%: define __VZ_STDIO_H__

%: include "mbed.h"
%: include <stdarg.h>
%: include <stdio.h>
%: include "shared_variables.h"
%: include "EthernetInterface.h"

extern Serial serial_pc;

extern UDPSocket udp_client;

extern Endpoint udp_server;

extern TCPSocketServer tcp_server;
///< Socket responsavel por ouvir determinado porta TCP.

extern TCPSocketConnection tcp_client;
///< Representa a presença de algum cliente logado em uma sessão TCP.

extern bool udp_request;

extern bool udp_query;

extern bool tcp_session;

extern bool from_eth;

extern bool debug_io_eth;
///< Variável de controle que ativa o debug do prompt eth.

int vz_io_eth_init ( void );

int vz_printf ( const char * format, ... );

void udp_query_send_msg ( char * msg );

const uint8_t PROMPT_UDP_COMMAND_SIZE = 64;

const uint16_t TCP_IDLE_MAX_TIME = 360;
///< Define o tempo maximo de espera por um novo comando via eth, dado que já estamos em uma sessão TCP.

const uint16_t PROMPT_ETH_BUFFER_SIZE = 1024;
///< Representa o tamanho máximo do pacote recebido pelo prompt da Header.

const uint16_t IO_MSG_SIZE = 1024;

const uint8_t IO_AUX_MSG_SIZE = 64;

extern char io_msg1 [ IO_MSG_SIZE + IO_AUX_MSG_SIZE ];
///< Buffer usado na composisão da mensagem enviada pela macro debug_msg

extern char io_debug_msg1 [ IO_MSG_SIZE + IO_AUX_MSG_SIZE ];

extern char io_msg2 [ IO_MSG_SIZE ];
///< Buffer usado na composisão da mensagem enviada pela macro debug_msg

extern char io_debug_msg2 [ IO_MSG_SIZE ];

extern char io_msg_ [ IO_MSG_SIZE ];
///< Buffer utilizado pela macro send_msg

const uint16_t DEBUGBUFSIZE = PROMPT_ETH_BUFFER_SIZE;
///< Define o tamanho do buffer de entrada de dados.

extern bool debug_reconnect;

inline void reconnect_prompt_udp_socket ( void )
{
  udp_client.close ();
  udp_client.bind ( ( int ) cm -> get_udp_port_listener () );
  udp_client.set_blocking ( false, 0 );
}

extern bool debug_uart3;


#define vz_debug(...) _vz_debug(__VA_ARGS__)
#define _vz_debug(...) { \
  snprintf ( io_debug_msg1, ( IO_MSG_SIZE + IO_AUX_MSG_SIZE ) -1, "%s:%d ", __FILE__, __LINE__); \
  snprintf ( io_debug_msg2, IO_MSG_SIZE - 1 , __VA_ARGS__); \
  strncat ( io_debug_msg1, io_debug_msg2, IO_MSG_SIZE - 1 ); \
  vz_printf ( "%s", io_debug_msg1 ); \
}

%: endif