#include "vector.h"

Vector::Vector ()
{
    this -> objects = NULL;
    this -> elements = 0;
}

Vector::~Vector ()
{
    if ( this -> objects != NULL ) free ( this -> objects );  
}

void Vector::add ( Object * e )
{
    if ( e != NULL )
    {
        this -> objects = ( Object ** ) realloc ( this -> objects, sizeof ( Object * ) * ++( this -> elements ) );
        if ( this -> objects == NULL )
        {
            memory_is_over = true;
            if ( debug_memory ) vz_debug ( "Vector add fail" );
        } else {
            this -> objects [ this -> elements - 1 ] = e;
        }
    }
}

Object * Vector::get_element ( int position )
{
    return ( position > -1 && position < this->elements ) ? ( Object * ) * ( this -> objects + position ) : NULL;
}

void Vector::remove_element ( int position )
{
    if ( debug_vector ) vz_debug ( "Removing element %d", position );
    if ( position > -1 && position < this -> elements )
    {
        if ( position == 0 && this -> elements == 1 )
        {
            this -> elements = 0;
            free ( this -> objects );
            this -> objects = NULL;
        } else {
            this -> objects [ position ] = this -> objects[ -- ( this -> elements ) ];
            this -> objects = ( Object ** ) realloc ( this -> objects, sizeof ( Object * ) * this -> elements );
            if ( this -> objects == NULL ) memory_is_over = true;
            if ( debug_memory ) vz_debug ( "Resize Vector fail" );
        }
    }
    if ( debug_vector ) vz_debug ( "Removed" );
}

int Vector::size ( void ) { return this -> elements; }

int Vector::print_yourself ( void )
{   
    vz_printf ("\r\n");
    vz_printf ("Elements :: %d ( %p )", this -> elements, &( this->elements ) );   
    vz_printf ("Values ::\r\n");
    
    if ( this -> elements == 0 )
    {
        vz_printf ( "Objects :: %p", this -> objects );
    }
        else
    {
        for ( register int i = 0; i < this -> elements; i++ )
        {
            vz_printf ("[ %i ] :: %p", i, ( this -> objects +  i ) );
        }
    }
    vz_printf ("\r\n");
    
    return ( sizeof ( Vector ) );
}