/**
 * @file rtpbuf.h
 * @Synopsis Implementa funcionalidades de conversão entre u-law e a-law
 * @author Jhonatan Casale / PedroZN 
 * @version 1
 * @date 2014-11-05
 * \note IMPORTANT: sizes must be multiple of 4 
 */
#ifndef __RTPBUF_H__
#define __RTPBUF_H__

#include <stdint.h>
#include <stdlib.h>
#include "utils.h"

const uint16_t RTPBUF_PKGSIZE = 240;
///< 30ms @ 8Ksamples/sec
const uint16_t RTPBUF_BUFSIZE = 320;
///< 40ms @ 8Ksamples/sec

#if (RTPBUF_PKGSIZE & 0x03)
# error OPS... value forbidden
#endif
#if (RTPBUF_BUFSIZE & 0x03)
# error OPS... value forbidden
#endif

struct rtpbuf {
  uint32_t b[ RTPBUF_BUFSIZE>>2 ];
    ///< A fila de audio.
  int size; 
    ///< Representa o tamanho da fila.
};
typedef struct rtpbuf rtpbuf_t;

/** clear the buffer, useful at the start of a new phone call 
 */
void rtpbuf_clear (rtpbuf_t * self);

/** use this function to put audio into the fifo
 */
void rtpbuf_put (rtpbuf_t * self, int size, uint8_t * data);

/** use this function to check if there is audio available
 * returns NULL if there is no audio available
 * or returns a pointer to the audio package 
 */
uint8_t * rtpbuf_get (rtpbuf_t * self);

/** 
 * use this function to tell rtpbuf that you already consumed
 * the data supplied by rtpbuf_get() 
 */
void rtpbuf_next (rtpbuf_t * self);

#endif