#include "prompt.h"

bool flood_silence = false;
bool delayed_flood = false;

int start_ext =0;
int end_ext = 0;
int ext_count = 0;

Timer tcp_timer;
bool tcp_alive = false;
bool serial_pc_pending = false;

volatile char b = 0;
uint8_t bufret = 0;

char __debug_buf__[ DEBUGBUFSIZE ];
char * debug_buf = __debug_buf__;
char last_cmd[ DEBUGBUFSIZE ];
char tmp_cmd[ DEBUGBUFSIZE ] = "help";
char last_debug_buf[ DEBUGBUFSIZE ] = "help";
char eth_udp_buffer[ PROMPT_ETH_BUFFER_SIZE ];
char gp_buff[ DEBUGBUFSIZE ];
uint8_t prompt_write_buffer [ CB_BUFFER_SIZE ];

uint16_t bufptr = 0;
uint16_t last_bufptr = 0;

Timer flood_timeout;
Timer flood_silence_timer;
uint8_t id_msg = 0x10;

char * 
prompt_process ( char * msg_from_cb, int length )
{
    char eth_buffer [ PROMPT_ETH_BUFFER_SIZE ];

    if ( id_msg < 0x11 ) id_msg = 0x11;

    if( flood_timeout.read() > 60 ) {
        pflood = false;
        flood_timeout.stop();
        flood_timeout.reset();
    }

    if( tcp_timer.read() >= TCP_IDLE_MAX_TIME ) {
        tcp_alive = false;
        tcp_timer.stop();
        tcp_timer.reset();
        tcp_session = false;
        debug_buf = __debug_buf__;
        bufptr = last_bufptr;
        bufret = 0;
        from_eth = false;
        tcp_client.close();
        return( NULL );
    }

    if( udp_query ) {
        if( msg_from_cb != NULL ) {
            last_bufptr = bufptr;
            if( ( length > 2 ) && ( msg_from_cb[ length - 2 ]  == '\r' ) ) msg_from_cb[ length - 2 ] = 0;

            if( ( length > 1 ) && ( msg_from_cb[ length - 1 ]  == '\n' ) ) msg_from_cb[ length - 1 ] = 0;

            if( ( length == 1 ) && msg_from_cb[ 0 ] == 0x0A ) strcpy( msg_from_cb, "\r" );

            bufptr = strlen( msg_from_cb );
            debug_buf = msg_from_cb;
            from_eth = true;
            bufret = 1;
        }
    } else {
        if ( !tcp_server.accept ( tcp_client ) ) {
            tcp_session = true;
            tcp_timer.start ();
            last_bufptr = bufptr;
            for ( register int i = 0; i < PROMPT_ETH_BUFFER_SIZE; i++ ) eth_buffer [ i ] = 0;
        }
        if ( tcp_session && !udp_query ) {
            tcp_client.set_blocking ( false, 0 );
            int n = tcp_client.receive ( eth_buffer, sizeof ( eth_buffer ) - 1 );
            if( n > 0 ) {
                tcp_timer.reset ();

                if( ( n > 2 ) && ( eth_buffer[ n - 2 ]  == '\r' ) ) eth_buffer[ n - 2 ] = 0;

                if( ( n > 1 ) && ( eth_buffer[ n - 1 ]  == '\n' ) ) eth_buffer[ n - 1 ] = 0;

                if( ( n == 1 ) && eth_buffer[ 0 ] == 0x0A ) strcpy( eth_buffer, "\r> " );

                bufptr = strlen( eth_buffer );
                debug_buf = eth_buffer;
                from_eth = true;
                bufret = 1;
                
                if ( n > 2 ) 
                {
                    char tmp[] = "> ";
                
                    while ( !( tcp_client.send_all ( tmp, strlen ( tmp ) ) ) );
                }

                if( !( strcmp( eth_buffer, "quit" ) ) ) {
                    tcp_timer.stop();
                    tcp_timer.reset();
                    debug_buf = __debug_buf__;
                    bufptr = last_bufptr;
                    from_eth = false;
                    tcp_session = false;
                    tcp_client.close();
                    bufret = 0;
                    return( NULL );
                }
            } else {
                debug_buf = __debug_buf__;
                bufptr = last_bufptr;
                from_eth = false;
            }
        }
    }

    if( ( !from_eth ) && ( !udp_query ) ) {
        if( pc.readable() ) {
            b = pc.getc();
            if( b == 0x0D ) {
                // enter
                bufret = 1;
                if ( debug_uart3 ) serial_pc_pending = true;
                
                // formatação manual da saída
                if ( bufptr > 0 ) serial_pc.printf ( "%s","\r\n> " );
            } else {
                pc.putc( b );
                if( b == 0x08 || b == 0x7F ) {
                    // BS | DEL
                    if( bufptr > 0 ) {
                        __debug_buf__[ --bufptr ] = 0;
                    }
                } else if( b == 0x09 ) {
                    // ignore tab
                } else {
                    __debug_buf__[ bufptr ] = b;
                    bufptr++;
                }
                last_bufptr = bufptr;
            }
        }
    }

    if ( flood_silence )
    {
        if ( flood_silence_timer.read_ms () > 250 )
        {
            char cmd[ 16 ] = "flood off";
            int str_end = strlen( cmd );
            cmd[ str_end ] = 0x0D;
            cmd[ str_end + 1 ] = 0x00;

            int port = convert_ext_to_port( ext_count );
            
            send2callboxes( build_cb_package( ext_count, port, PROMPT, cmd, id_msg++, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );
            
            vz_printf ("Silence sent to ext=%d port=%d", ext_count, port );
        
            flood_silence_timer.reset();

            // importante para o uso da funçao silence
            if( ++ext_count > end_ext ) {
                flood_silence = false;
                flood_silence_timer.stop();
                flood_silence_timer.reset();

                if( debug_uart3 && !( from_eth ) ) pc.printf("\r\n> " );
                if( tcp_session && !udp_query ) {
                    snprintf( eth_buffer, PROMPT_ETH_BUFFER_SIZE, "\r\n> " );
                    tcp_client.send_all( eth_buffer, strlen( eth_buffer ) );
                } else if( udp_query ) {
                    snprintf( eth_buffer, PROMPT_ETH_BUFFER_SIZE, "\r\n> " );
                    udp_query_send_msg( eth_buffer );
                }
            }
        }
    }

    if ( delayed_flood ) 
    {
        tflood.start();
        tflood.reset();
        floodcount =0;
        pflood = true;
        flood_timeout.start();
        delayed_flood = false;
        if( debug_uart3 ) pc.printf("\n\rFlood ON\n\r" );
        if( from_eth ) {
            snprintf( debug_buf, PROMPT_ETH_BUFFER_SIZE, "Flood On\n\r" );
        }
    }

    char * tmp_return = NULL;
    
    if ( bufret == 1 ) 
    {
        tmp_return = command_process ( debug_buf, bufptr );
    
        if( b == 0x0D || bufret == 1 || bufptr > DEBUGBUFSIZE ) {
            bufret = 0;
    
            if( debug_uart3 && !( from_eth ) ) pc.putc(0x0A);
            if( debug_uart3 && !( from_eth ) ) pc.putc(0x0D);
            if( debug_uart3 && !( from_eth ) ) pc.printf("> " );
    
            if( from_eth ) {
                if( strlen( debug_buf ) > 0 ) {
    
                    if( debug_buf[ strlen( debug_buf ) - 1 ] == '\r' || debug_buf[ strlen( debug_buf ) - 1 ] == '\n' ) {
                        strcpy( debug_buf, "> " );
                    } else {
                        strcpy( debug_buf, "\n\r> " );
                    }
                } else {
    
                }
    
                if( tcp_session && !udp_query ) {
                    tcp_client.send_all( debug_buf, strlen( debug_buf ) );
                } else if( udp_query ) {
    
                    udp_query_send_msg( debug_buf );
    
                }
                for( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf[ i ] = 0;
    
                debug_buf = __debug_buf__;
    
                bufptr = last_bufptr;
    
            } else {
                bufptr = 0;
                last_bufptr = 0;
                for( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf[ i ] = 0;
            }
        }
    }
    
    return ( tmp_return );
}
    
char * 
command_process ( char * debug_buf, size_t bufptr )
{   
    bool miss_match = true;
    
    static unsigned int promptcb_last_ext = 0;
    static unsigned int promptcb_last_port = 0;
    static char promptcb_last_cmd [ 300 ];
    
    // removendo espacos em branco no inicio da string
    uint16_t shift_blank_spaces = 0;
    for ( register uint16_t i = 0; i < DEBUGBUFSIZE; i++ ) {
        if ( debug_buf [ i ] == 0x20 ) shift_blank_spaces++;

        if ( debug_buf [ i ] != 0x20 ) break;
    }
    debug_buf += shift_blank_spaces;

    strcpy( tmp_cmd, debug_buf );
    if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "." ) ) {
        miss_match = false;
        strcpy( debug_buf, last_cmd );
        strcpy( tmp_cmd, debug_buf );
    } else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "+" ) ) {
        miss_match = false;
        strcpy( debug_buf, "flood on" );
        strcpy( tmp_cmd, debug_buf );
    } else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "-" ) ) {
        miss_match = false;
        strcpy( debug_buf, "flood off" );
        strcpy( tmp_cmd, debug_buf );
    } else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "++ ", 3 ) ) {
        miss_match = false;
        delayed_flood = true;
        int ext = atoi( debug_buf + 3 );
        sprintf( debug_buf, "pcb %i flood on", ext );
    } else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "-- ", 3 ) ) {
        miss_match = false;
        int ext = atoi( debug_buf + 3 );
        if( debug_uart3 ) pc.printf("\n\rFlood OFF\n\r" );
        if( from_eth ) {
            snprintf( debug_buf, PROMPT_ETH_BUFFER_SIZE, "Flood OFF\n\r" );
        }
        pflood = false;
        tflood.stop();
        flood_timeout.reset();
        sprintf( debug_buf, "pcb %i flood off", ext );
    }

    //tratamento dos enters
    if( !bufptr ) {
        miss_match = false;
    } else if( bufptr == 1 ) {
        if( debug_buf [ 0 ] == '\r' || debug_buf [ 0 ] == '\n' ) miss_match = false;
    }

        if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "show_configs" ) )
    {
        miss_match = false;
        
        if( debug_uart3 ) pc.printf("\n\r" );
        
        files('s');
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "rx" ) ) {
        miss_match = false;
        show_last_rx = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "tx" ) ) {
        miss_match = false;
        show_last_tx = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "stats" ) ) {
        miss_match = false;
        stats = true;
    } 
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "reset_stats" ) ) {
        miss_match = false;
        r_stats = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "rtp" ) )
    {
        miss_match = false;
        dshow_rtp = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "callrtp" ) ) {
        miss_match = false;
        dcallshow_rtp = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "format" ) ) {
        miss_match = false;

        if( from_eth ) {
            vz_printf ( "Not Allowed" );
        } else {
            if ( debug_uart3 ) pc.printf("\n\rFormatando o sistema de arquivos... espere o sistema reiniciar\n\r" );
            files('e');
            files('w');
            __disable_irq();
            NVIC_SystemReset();
        }
    }

    // nao apresentou comportamento esperado
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "ipset ", 6 ) )
    {
        miss_match = false;
        cm -> set_header_ip ( debug_buf + 6 );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "extset ", 7 ) ) 
    {
        miss_match = false;
        cm -> set_header_ext ( atoi ( debug_buf + 7 ) );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "serextset ", 10 ) )
    {
        miss_match = false;
        cm -> set_server_ext ( atoi ( debug_buf + 10 ) );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "shift_port ", 11 ) )
    {
        miss_match = false;
        cm -> set_shift_port( atoi ( debug_buf + 11 ) );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "maskset ", 8 ) )
    {
        miss_match = false;
        cm -> set_net_mask ( debug_buf + 8 );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "gatewayset ", 11 ) )
    {
        miss_match = false;
        cm -> set_gateway ( debug_buf + 11 );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "msipport ",9 ) ) 
    {
        miss_match = false;
        cm -> set_header_sip_port ( atoi ( debug_buf + 9 ) );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "serverip ",9 ) )
    {
        miss_match = false;
        cm -> set_server_ip ( debug_buf + 9 );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "maxext ", 7 ) )
    {
        miss_match = false;
        cm -> set_max_ext ( atoi ( debug_buf + 7 ) );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "minext ", 7 ) ) 
    {
        miss_match = false;
        cm -> set_min_ext ( atoi ( debug_buf + 7 ) );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "ssport ", 7 ) )
    {
        miss_match = false;
        cm -> set_server_port ( atoi ( debug_buf + 7 ) );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "fw_ip ", 6 ) )
    {
        miss_match = false;
        cm -> set_fw_server_ip ( debug_buf + 6 );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "fw_port ", 8 ) )
    {
        miss_match = false;
        cm -> set_fw_server_port ( atoi ( debug_buf + 8 ) );
    }
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "set_acceptable_delay ", 21 ) )
    {
        miss_match = false;
        cm -> set_acceptable_delay ( atoi ( debug_buf + 21 ) );
    }
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "set_cbx_detach_mode ", 20 ) )
    {
        miss_match = false;
        
        bool new_cbx_detach_mode;
        
        char * tmp = NULL;
        
        if ( ( tmp = strstr ( ( debug_buf + 20 ), "true" ) ) != NULL ) new_cbx_detach_mode = true;
        
        else if ( ( tmp = strstr ( ( debug_buf + 20 ), "false" ) ) != NULL ) new_cbx_detach_mode = false;
        
        if ( tmp != NULL ) cm -> set_cbx_detach_mode ( new_cbx_detach_mode );
        
        else vz_printf ("Usage: set_cbx_detach_mode < true | false >");
    }
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "set_cbx_wake_mode ", 18 ) )
    {
        miss_match = false;
        
        bool new_cbx_wake_mode;
        
        char * tmp = NULL;
        
        if ( ( tmp = strstr ( ( debug_buf + 18 ), "true" ) ) != NULL ) new_cbx_wake_mode = true;
        
        else if ( ( tmp = strstr ( ( debug_buf + 18 ), "false" ) ) != NULL ) new_cbx_wake_mode = false;
        
        if ( tmp != NULL ) cm -> set_cbx_wake_mode ( new_cbx_wake_mode );
        
        else vz_printf ("Usage: set_cbx_wake_mode < true | false >");
    }
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "set_cbx_mode ", 13 ) )
    {
        miss_match = false;
        
        int tmp = 0;
        
        uint8_t new_cbx_mode = 0;
        
        char * ref = debug_buf + 13;
        
        while ( *ref == 0x20 ) ref++;
        
        if ( ( tmp = strcasecmp ( ref, "fibra" ) ) == 0 ) new_cbx_mode = u8_FIBRA_MODE;
        
        else if ( ( tmp = strcasecmp ( ref, "radio" ) ) == 0 ) new_cbx_mode = u8_RADIO_MODE;
        
        else if ( ( tmp = strcasecmp ( ref, "custom" ) ) == 0 ) new_cbx_mode = u8_CUSTOM_MODE;
        
        if ( tmp == 0 ) cm -> set_cbx_mode ( new_cbx_mode );
        
        else vz_printf ( "Usage: set_cbx_wake_mode < fibra | radio | custom >" );
    }
    

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dconfig" ) )
    {
        miss_match = false;
        cm -> restore_defaults_settings ();
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "reset" ) )
    {
        miss_match = false;
        
        if ( tcp_session and from_eth ) tcp_client.close ();
        
        vz_printf ( "Job is done" );
        
        __disable_irq ();
        
        NVIC_SystemReset ();
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "test" ) )
    {
        miss_match = false;
        char msg[] = "This is another test";
        vz_printf ("-->%s<--", msg );
        vz_printf ("-->%d<--", 28 );
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dog" ) )
    {
        miss_match = false;
        
        vz_printf ( "MUUUUUUUuuuuUUUUUU - I'm not a dog!!!!" );
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "get_acceptable_delay" ) )
    {
        miss_match = false;
        
        vz_printf ( "get_acceptable_delay :: %u", cm -> get_acceptable_delay () );
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "get_cbx_detach_mode" ) )
    {
        miss_match = false;
        
        vz_printf ( "get_cbx_detach_mode :: %s", ( cm -> get_cbx_detach_mode () ) ? "true" : "false" );
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "get_cbx_wake_mode" ) )
    {
        miss_match = false;
        
        vz_printf ( "get_cbx_wake_mode :: %s", ( cm -> get_cbx_wake_mode () ) ? "true" : "false" );
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "get_cbx_mode" ) )
    {
        miss_match = false;
        
        char mode_buffer [ 32 ] = "";
        
        uint8_t u8mode = cm -> get_cbx_mode ();
        
        if ( u8mode == u8_FIBRA_MODE ) strcpy ( mode_buffer, "Fibra Fibra" );
        
        else if ( u8mode == u8_RADIO_MODE ) strcpy ( mode_buffer, "Fibra RADIO" );
        
        else strcpy ( mode_buffer, "Custom" );
        
        vz_printf ( "get_cbx_mode :: %s", mode_buffer );
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "show_mode" ) )
    {
        miss_match = false;
        
        vz_printf ( "get_cbx_detach_mode :: %s", ( cm -> get_cbx_detach_mode () ) ? "true" : "false" );
        
        vz_printf ( "get_cbx_wake_mode :: %s", ( cm -> get_cbx_wake_mode () ) ? "true" : "false" );
        
        char mode_buffer [ 32 ] = "";
        
        uint8_t u8mode = cm -> get_cbx_mode ();
        
        if ( u8mode == u8_FIBRA_MODE ) strcpy ( mode_buffer, "Fibra Fibra" );
        
        else if ( u8mode == u8_RADIO_MODE ) strcpy ( mode_buffer, "Fibra RADIO" );
        
        else strcpy ( mode_buffer, "Custom" );
        
        vz_printf ( "get_cbx_mode :: %s", mode_buffer );
    }
    
    

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "request_clock" ) )
    {
        miss_match = false;
        request_clock_now = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "hello" ) )
    {
        miss_match = false;
        show_hello_status = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "date" ) )
    {
        miss_match = false;
        vz_printf (" %s %s", __DATE__, __TIME__ );
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "clock" ) )
    {
        miss_match = false;
        show_current_time = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "overflow" ) )
    {
        miss_match = false;
        vz_printf ( "Overflow messages :: %d", string_msg_overflow );
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dep" ) )
    {
        miss_match = false;
        
        drop_entendi_pkg = !drop_entendi_pkg;
        
        if ( drop_entendi_pkg ) {
            vz_debug ("Entendi pkgs will be droped" );
        } else {
            vz_debug ("Entendi pkgs don't will be droped" );
        }
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dita" ) )
    {
        miss_match = false;
        
        drop_invite_to_ast_pkg = !drop_invite_to_ast_pkg;
        
        if ( drop_invite_to_ast_pkg ) {
            vz_debug ("Invite pkgs to ast will be droped" );
        } else {
            vz_debug ("Invite pkgs to ast don't will be droped" );
        }
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "refresh_on" ) )
    {
        miss_match = false;
        
        vz_printf ( "Refresh function :: Enable" );
        
        do_not_refresh = false;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "refresh_off" ) )
    {
        miss_match = false;
        
        vz_printf ( "Refresh function :: Disable" );
        
        do_not_refresh = true;
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "refresh_status" ) )
    {
        miss_match = false;
        
        vz_printf ( "Refresh function :: %s", ( do_not_refresh == true ) ? "Disable" : "Enable" );
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dop" ) )
    {
        miss_match = false;
        
        drop_ok_pkg = !drop_ok_pkg;
        
        if ( drop_ok_pkg ) {
            vz_debug ( "Ok pkgs will be droped" );
        } else {
            vz_debug ( "Ok pkgs don't will be droped" );
        }
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dip" ) )
    {
        miss_match = false;
        
        drop_invite_pkg = !drop_invite_pkg;
        
        if ( drop_invite_pkg ) {
            vz_debug ( "invite pkgs from cbx will be droped" );
        } else {
            vz_debug ( "invite pkgs from cbx don't will be droped" );
        }

    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "drp" ) )
    {
        miss_match = false;
        
        drop_registry_pkg = !drop_registry_pkg;
        
        if ( drop_registry_pkg ) {
            vz_debug ( "registrys pkgs from cbx will be droped" );
        } else {
            vz_debug ( "registrys pkgs from cbx don't will be droped" );
        }

    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "rafc" ) )
    {
        miss_match = false;
        
        received_audio_from_cb = !received_audio_from_cb;
        
        if ( received_audio_from_cb ) {
            vz_debug ( "audio pkgs from cbx will printed" );
        } else {
            vz_debug ( "audio pkgs from cbx don't will printed" );
        }

    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dap" ) )
    {
        miss_match = false;
        
        drop_ack_pkg = !drop_ack_pkg;
        
        if ( drop_ack_pkg ) {
            vz_debug ( "ack pkgs will be droped" );
        } else {
            vz_debug ( "ack pkgs don't will be droped" );
        }
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "drfa" ) )
    {
        miss_match = false;
        
        drop_rtp_from_ast_pkg = !drop_rtp_from_ast_pkg;
        
        if ( drop_rtp_from_ast_pkg ) {
            vz_debug ( "rtp pkgs from ast will be droped" );
        } else {
            vz_debug ( "rtp pkgs from ast don't will be droped" );
        }
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "drfc" ) )
    {
        miss_match = false;
        
        drop_rtp_from_cbx_pkg = !drop_rtp_from_cbx_pkg;
        
        if ( drop_rtp_from_cbx_pkg ) {
            vz_debug ( "rtp pkgs from cbx will be droped" );
        } else {
            vz_debug ( "rtp pkgs from cbx don't will be droped" );
        }
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "uptime" ) )
    {
        miss_match = false;

        uint32_t local_uptime = uptime;
        uint16_t h = local_uptime / ( 60 * 60 );
        uint16_t m = ( local_uptime - ( h * 60 * 60 ) ) / 60;
        uint16_t s = ( local_uptime - ( ( h * 60 * 60 ) + m * 60 ) );
       vz_printf ( "\r\n%ih%im%is", h, m, s );
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "wake" ) )
    {
        miss_match = false;
        show_wake_all_up_status = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "wake_on" ) )
    {
        miss_match = false;
        
        vz_printf ( "Function wake_all_up : Enable" );
        
        wake_all = true;
        
        wake_all_disable = false;
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "wake_off" ) )
    {
        miss_match = false;
        
        vz_printf ("Function wake_all_up : Disable" );
        
        wake_all = false;
        
        wake_all_disable = true;
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "get_wdt_string" ) )
    {
        miss_match = false;
        show_wdt_string = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "ifconfig" ) ) 
    {
        miss_match = false;
        
        vz_printf ("Configs :: " );
        char buffer[ 128 ];

        cm -> get_header_ip ( buffer );
        vz_printf ("Header IP :: %s", buffer );

        vz_printf ("Header ext :: %u", cm -> get_ext () );

        vz_printf ("Header port :: %u", cm -> get_port () );

        cm -> get_server_ip ( buffer );
        vz_printf ("Server IP :: %s", buffer );

        vz_printf ("Server ext :: %u", cm -> get_server_ext () );

        vz_printf ("Server port :: %u", cm -> get_server_port () );

        cm -> get_net_mask ( buffer );
        vz_printf ("Mascara de rede :: %s", buffer );

        cm -> get_gateway ( buffer );
        vz_printf ("Gateway IP :: %s", buffer );

        vz_printf ("UDP Port :: %u", cm -> get_udp_port_listener () );

        vz_printf ("TCP Port :: %u", cm -> get_tcp_port_listener () );

        cm -> get_fw_server_ip ( buffer );
        vz_printf ("FW Server IP :: %s", buffer );

        vz_printf ("FW Server Port :: %u", cm -> get_fw_server_port () );

        vz_printf ("Max Ext :: %u", cm -> get_max_ext () );

        vz_printf ("Min Ext :: %u", cm -> get_min_ext () );

        vz_printf ("Shift Port :: %u", cm -> get_shift_port () );
        
        cm -> get_clock_server_ip ( buffer );
        vz_printf ("Clock Server IP :: %s", buffer );
        
%: ifdef MODE_TEST
        vz_printf ("on MODE_TEST" );
%: endif            
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "sizes" ) )
    {
        miss_match = false;
        sizes = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "ftq" ) )
    {
        miss_match = false;
        
        vz_printf ( "FTQ On" );
        
        big_bug_pkg = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "ktq" ) )
    {
        miss_match = false;
        
        vz_printf ( "FTQ!!!" );

        flood_bug_pkg = !flood_bug_pkg;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "wdt_pkg_cbx_disable" ) )
    {
        miss_match = false;
        
        vz_printf ( "wdt_pkg_cbx status :: disable" );
        
        disable_wdt_from_cbx = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "wdt_pkg_cbx_enable" ) )
    {
        miss_match = false;
        
        vz_printf ( "wdt_pkg_cbx status :: enable" );
        
        disable_wdt_from_cbx = false;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "wdt_pkg_cbx_status" ) )
    {
        miss_match = false;
        
        vz_printf ( "wdt_pkg_cbx status :: %s", ( disable_wdt_from_cbx ) ? "disable" : "enable" );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "ls", 2 ) )
    {
        miss_match = false;
        reverse_list = false;
        list = true;

        if ( strlen ( debug_buf ) != 2 )
        {
            if ( strstr ( ( debug_buf + 2 ), "r" ) ) 
            {
                reverse_list = true;
            }

            
            if ( strstr ( ( debug_buf + 2 ), "l" ) ) 
            {
                list = false;
                long_list = true;
            }
            
            if ( strstr ( ( debug_buf + 2 ), "t" ) ) 
            {
                long_list = true;
                list = false;
                show_time = true;
            }
            
            if ( strstr ( ( debug_buf + 2 ), "i" ) ) 
            {
                long_list = true;
                list = false;
                show_invites = true;
            }
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "drtp ", 5 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Rtp Debug On" );
            
            debug_rtp = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Rtp Debug Off" );
            
            debug_rtp = false;
        }
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "print_v_cb" ) ) 
    {
        miss_match = false;
        print_v_cb = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "print_v_call" ) ) 
    {
        miss_match = false;
        print_v_call = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "tt" ) ) 
    {
        miss_match = false;
        main_test = !main_test;
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "ttt" ) ) 
    {
        miss_match = false;
        main_test_mean = !main_test_mean;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "registra" ) ) 
    {
        miss_match = false;
        registra = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "registra4" ) ) 
    {
        miss_match = false;
        registra4 = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "show_sip" ) ) 
    {
        miss_match = false;
        show_sip = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "reset_cks" ) ) 
    {
        miss_match = false;
        reset_cks = true;
    }

    //replaced by ls
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "status" ) ) 
    {
        miss_match = false;
        list = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "wdt" ) ) 
    {
        miss_match = false;
        debug_wdt = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "eth" ) ) 
    {
        miss_match = false;
        debug_eth = true;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "deleted" ) ) 
    {
        miss_match = false;
        vz_printf ( "::deleted_sip [ %5i ]::", deleted_sip );
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "help_setup" ) ) 
    {
        miss_match = false;
    
        vz_printf ( "ifconfig                        - mostra o arquivo de configuracao do sistema" );
        vz_printf ( "dconfig                         - volta as configuracoes do sistema para o padrao de fabrica" );
        vz_printf ( "ipset [ip]                      - Configura o IP da cabeceira" );
        vz_printf ( "extset [ext]                    - Configura a ext da cabeceira" );
        vz_printf ( "msipport [port]                 - Configura a porta SIP da cabeceira" );
        vz_printf ( "serverip [ip]                   - Configura o ip do servidor asterisk" );
        vz_printf ( "serextset [ext]                 - Configura a server ext da cabeceira" );
        vz_printf ( "ssport [port]                   - Configura a porta SIP do servidor asterisk" );
        vz_printf ( "maskset [mask]                  - Configura a mascara da cabeceira" );
        vz_printf ( "gatewayset [gateway]            - Configura o gateway da cabeceira" );
        vz_printf ( "fw_ip                           - Configura o IP do servidor de fw" );
        vz_printf ( "fw_port                         - Configura a porta do servidor de fw" );                
        vz_printf ( "maxext                          - Configura o maior ramal possivel de ser registrado nesse ramo" );
        vz_printf ( "minext                          - Configura o menor ramal possivel de ser registrado nesse ramo" );
        serial_pc.printf("format                          - formata o sistema de arquivos" );
    }
    
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "help_debug" ) ) 
    {
        miss_match = false;
            
        vz_printf ( "debug [on|off|show]             - seleciona debugs gerais | lista de debugs" );
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "help_command_to_cbx" ) ) 
    {
        miss_match = false;
        
        vz_printf ( "callme [ramal porta]            - envia o pedido de ligacao para o callbox com o ramal e porta indicada" );
        vz_printf ( "pcb ramal comando               - envia o <comando> para o cbx <ramal> e <porta = ramal sem a centane> executar" );
        vz_printf ( "pcc ramal porta comando         - envia o <comando> para o cbx <ramal> e <porta> executar" );
        vz_printf ( "cc ramal comando                - envia o <comando> para o cbx <ramal> e <porta = ramal> executar" );
        vz_printf ( "silence <start_ext end_ext>     - envia comando de flood off para os ramais no intervalo end_ext - start_ext" );
        vz_printf ( "-- ext                          - Header flood off, ext flood off" );
        vz_printf ( "++ ext                          - Header flood on, ext flood on" );
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "help_protocol" ) ) 
    {
        miss_match = false;
        
        vz_printf ( "types                           - Lista os types usados no protocolo de comunicacao Header -- CBx" );
        vz_printf ( "protocol                        - Exibe formato do pacote seguindo o protocolo de comunicacao Header -- CBx" );
        
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "help_cbx_list" ) ) 
    {
        miss_match = false;
        
        vz_printf ( "ls [lrti] | status              - Exibe uma lista ordenada por ext do CBx registrados na Header" );
        vz_printf ( "showcb                          - lista os Cbx registrados na header" );
        vz_printf ( "show_sip                        - lista os Cbx registrados na header com suas portas SIP" );
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "help_io" ) ) 
    {
        miss_match = false;
        
        vz_printf ( "cks                             - exibe estatisticas de check sum" );
        vz_printf ( "reset_cks                       - reseta estatisticas de check sum" );
        vz_printf ( "stats                           - exibe estatisticas de pacotes recidos" );
        vz_printf ( "reset_stats                     - reseta estatisticas de pacotes recidos" );
        vz_printf ( "{ [+|-] | flood [ on | off ] }  - simula envio de pacotes de audio" );
        vz_printf ( "rx                              - Exibe ultimo pacote recebido dos CBx" );
        vz_printf ( "tx                              - Exibe ultimo pacote enviado para os CBx" );
    }
    
    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "types" ) ) 
    {
        miss_match = false;

        vz_printf (
                "  hex  ::   dec  :: Type \n\r"
                "0x%02x   :: %5i  :: BOOT\n\r"
                "0x%02x   :: %5i  :: REGISTRY\n\r"
                "0x%02x   :: %5i  :: REGISTRY_ACK\n\r"
                "0x%02x   :: %5i  :: INVITE\n\r"
                "0x%02x   :: %5i  :: INVITE_ACK\n\r"
                "0x%02x   :: %5i  :: AUDIO\n\r"
                "0x%02x   :: %5i  :: TELEMETRY\n\r"
                "0x%02x   :: %5i  :: BOOTLOADER_CBX\n\r"
                "0x%02x   :: %5i  :: CB_BYE\n\r"
                "0x%02x   :: %5i  :: CB_BYE_ACK\n\r"
                "0x%02x   :: %5i  :: PROMPT\n\r"
                "0x%02x   :: %5i  :: FLOOD\n\r"
                "0x%02x   :: %5i  :: FW\n\r"
                "0x%02x   :: %5i  :: FW1\n\r"
                "0x%02x   :: %5i  :: FW2\n\r"
                "0x%02x   :: %5i  :: FW3\n\r"
                "0x%02x   :: %5i  :: FW4\n\r"
                "0x%02x   :: %5i  :: FW5\n\r"
                "0x%02x   :: %5i  :: FW6\n\r"
                "0x%02x   :: %5i  :: CB_STATS\n\r"
                "0x%02x   :: %5i  :: CB_STATS_ACK\n\r"
                "0x%02x   :: %5i  :: DO_NOTHING\n\r\n\r"

                "0x%02x :: %5i  :: BROADCAST_EXT\n\r"
                "NOTA - Os types TELEMETRY, CB_STATS, e FW1 ate FW6 sao repassados para o servidor como type FW\n\r",
                BOOT, BOOT,
                REGISTRY, REGISTRY,
                REGISTRY_ACK, REGISTRY_ACK,
                INVITE, INVITE,
                INVITE_ACK, INVITE_ACK,
                AUDIO, AUDIO,
                TELEMETRY, TELEMETRY,
                BOOTLOADER_CBX, BOOTLOADER_CBX,
                CB_BYE, CB_BYE,
                CB_BYE_ACK, CB_BYE_ACK,
                PROMPT, PROMPT,
                FLOOD, FLOOD,
                FW, FW,
                FW1, FW1,
                FW2, FW2,
                FW3, FW3,
                FW4, FW4,
                FW5, FW5,
                FW6, FW6,
                CB_STATS, CB_STATS,
                CB_STATS_ACK, CB_STATS_ACK,
                DO_NOTHING, DO_NOTHING,
                BROADCAST_EXT, BROADCAST_EXT
            );
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "protocol" ) )
    {
        miss_match = false;
        vz_printf ( "| E | E | P | P | C | C | T | [ Seq_num | Audio ] | 14[ Clock | Audio ] | [ TS | Audio ] | ... |\n\r \n\rE = Ext = Ramal\n\r \n\rP = Port = Porta\n\r \n\rC = Checksum\n\r \n\rT = Type = Tipo\n\r \n\rSeq_num = Sequence Number = Numero de sequencia\n\r \n\rClock = 14 bytes to sync\n\r \n\r... = demais CB_BUFFER_SIZE - __VZ_HEADER_OFFSET__  bytes" );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "flood ", 6 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Flood On" );
            
            tflood.start ();
            tflood.reset ();
            floodcount =0;
            pflood = true;
            flood_timeout.start ();
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "more", 4 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Flood On" );
            
            tflood.start ();
            tflood.reset ();
            floodcount = 0;
            pflood = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Flood Off" );
            
            pflood = false;
            tflood.stop ();
            flood_timeout.reset ();
        }

    }

    // precisa ser refatorado pra mandar pro ramo inteiro, dado a lista de cbx
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "silence ", 8 ) )
    {
        miss_match = false;
        
        char *ref, *split;

        strcpy ( promptcb_last_cmd, debug_buf );

        if( !( strcmp ( debug_buf + 8, "-h" ) && strcmp ( debug_buf + 8, "--help" ) ) ) {
            vz_printf ( "Usage: silence start_ext end_ext | start_ext must be greater than end_ext\n\rObs : ( end_ext - start_ext ) < 50 " );
        } else {
            ref = debug_buf;

            split = strtok ( debug_buf + 8, " " );

            start_ext = atoi ( split );

            split += strlen ( split ) + 1;

            end_ext = atoi ( split );

            debug_buf = ref;

            if ( start_ext < end_ext && ( end_ext - start_ext ) < 50 )
            {
                if ( start_ext % 2 ) start_ext --;
                if ( !( end_ext % 2 ) ) end_ext ++;

                ext_count = start_ext;
                flood_silence_timer.start ();
            } else {
                vz_printf ( "Usage Error : silence start_ext end_ext | start_ext must be greater than end_ext\n\rObs : ( end_ext - start_ext ) < 50 " );
            }
            
            flood_silence = true;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "debug ", 6 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug ON" );
            
            debug_alive = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 6), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug Off\n\r" );
            
            debug_alive = false;
        }
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "show", 4 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "dsip \n\r"
                        "debug_alive \n\r"
                        "debug_prompt \n\r"
                        "debug_vector \n\r"
                        "debug_cb \n\r"
                        "debug_main \n\r"
                        "dcks \n\r"
                        "debug_cb_rx \n\r"
                        "debug_cb_tx* \n\r"
                        "debug_eth_rx* \n\r"
                        "debug_eth_tx* \n\r"
                        "debug_file" 
            );
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dsip ", 5 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Sip Debug On" );
            
            debug_sip = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Sip Debug Off" );
            
            debug_sip = false;
        }
    }
    
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "flood_", 6 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "enable", 6 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Flood Packages Enable" );
            
            enable_flood = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "disable", 7 ) )
        {
            miss_match = false;
            
            vz_printf ( "Flood Packages Disable" );
            
            enable_flood = false;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "status", 6 ) )
        {
            miss_match = false;
            
            vz_printf ( "Flood Packages %s", ( enable_flood ) ? "Enable" : "Disable" );
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "ddrefresh ", 10 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 10 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Don't Refresh Debug On" );
            
            debug_dont_refresh = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 10 ), ( uint8_t * ) "off",3 ) )
        {
            miss_match = false;
        
            vz_printf ( "Don't Refresh Debug Off" );
                
            debug_dont_refresh = false;
        }
    }
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "drajada ", 8 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug Rajada on" );
            
            debug_resend_invite = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "off",3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug Rajada off" );
            
            debug_resend_invite = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * ) debug_buf, ( uint8_t * ) "dsqn ", 5 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Sequence Number Debug On" );
            
            debug_sqn = true;
        }

        if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "off",3 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Sequence Number Debug Off" );
            
            debug_sqn = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * ) debug_buf, ( uint8_t * ) "test_ts ", 8 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "TS testing On" );
            
            test_ts = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "off",3 ) ) 
        {
            miss_match = false;
         
            vz_printf ( "TS testing Off" );
            
            test_ts = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dhello ", 7 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Hello Debug On" );
            
            debug_hello = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "off",3 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Hello Debug Off" );
            
            debug_hello = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dmissedwdt ", 11 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 11 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Wdt missed Debug On" );
            
            dmissed_wdt = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 11 ), ( uint8_t * ) "off", 3 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Wdt missed Debug Off" );
            
            dmissed_wdt = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dclock ", 7 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf( "Clock Debug On" );
            
            debug_clock = true;
        }
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf( "Clock Debug Off" );
            
            debug_clock = false;
        }
    }
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dprintclock ", 12 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 12 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Clock Debug <VZ PKG PRINT> On" );
            
            debug_print_clock = true;
        }
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 12 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Clock Debug <VZ PKG PRINT> Off" );
            
            debug_print_clock = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dlength ", 8 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "String length debug On" );
            
            debug_string_length = true;
        }
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "String length debug Off" );
            
            debug_string_length = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dbind ", 6 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "UDP Bind Debug On" );
            
            debug_bind = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "off",3 ) )
        {
            miss_match = false;
            
            vz_printf ( "UDP Bind Debug Off" );
            
            debug_bind = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dresetrtp ", 10 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 10 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Reset RTP Debug On" );
            
            debug_reset_rtp = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 10 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Reset RTP Debug Off" );
            
            debug_reset_rtp = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "duart ", 6 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Enable UART3 usage" );
            
            debug_uart3 = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Disable UART3 usage" );
            
            debug_uart3 = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dprint ", 7 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug print On" );
            
            print_values = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "off", 3 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Debug print Off" );
            
            print_values = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dmissed ", 8 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug Missed On" );
            
            debug_missed = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug Missed Off" );
            
            debug_missed = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dreconnect ", 11 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 11 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Reconnecet Debug On" );
            
            debug_reconnect = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 11 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Reconnecet Debug Off" );
            
            debug_reconnect = false;
        }
    }
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dpair ", 6 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Pair Debug On" );
            
            debug_pair = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Pair Debug Off" );
            
            debug_pair = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dmatch ", 7 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Port Match Debug On" );
            
            debug_port_match = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Port Match Debug Off" );
            
            debug_port_match = false;
        }
    }


    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dmuted ", 7 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Muted Debug On" );
            
            debug_muted = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Muted Debug Off" );
            
            debug_muted = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dwdt ", 5 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Wdt Debug On" );
            
            wdt_show = true;
        }
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "off",3 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Wdt Debug Off" );
    
            wdt_show = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "drefresh ", 9 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 9 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Refresh Debug On" );
            
            debug_refresh= true;
        }
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 9 ), ( uint8_t * ) "off",3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Refresh Debug Off" );
                
            debug_refresh = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dping ", 6 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Ping Debug On" );
            
            debug_ping = true;
        }
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Ping Debug Off" );
                
            debug_ping= false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dwu ", 4 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 4 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Wake Up Debug On" );
            
            debug_wake = true;
        }
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 4 ), ( uint8_t * ) "off", 3 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Wake Up Debug Off" );
            
            debug_wake = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "tcp_alive ", 10 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 10 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "TCP don't drop mode on" );
            
            tcp_alive = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 10 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "TCP don't drop mode off" );
            
            tcp_alive = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "daging ",7 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Aging Debug On" );
            
            debug_aging = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "off",3 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Aging Debug Off" );
            
            debug_aging = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dcpld ", 6 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "DCPLD Debug On" );
            
            debug_cpld = true;
            debug_cb_rx = true;
            debug_cb_tx = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "off",3 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "DCPLD Debug Off" );
            
            debug_cpld = false;
            debug_cb_rx = false;
            debug_cb_tx = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dtxshow ", 8 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "DCPLD Show TX Debug On" );
            
            debug_show_tx_cpld = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "off",3 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "DCPLD Show TX Debug Off" );
            
            debug_show_tx_cpld = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dshowcpld ", 10 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 10 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "DCPLD Show Debug On" );
            
            debug_show_tx_cpld = true;
            debug_show_rx_cpld = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 10 ), ( uint8_t * ) "off", 3 ) ) 
        {
            miss_match = false;
            vz_printf ( "DCPLD Show Debug Off" );
            
            debug_show_tx_cpld = false;
            debug_show_rx_cpld = false;
        }
    }


    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "drxshow ", 8 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "DCPLD Show RX Debug On" );
            
            debug_show_rx_cpld = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "off",3 ) )
        {
            miss_match = false;
            
            vz_printf ( "DCPLD Show RX Debug Off" );
            
            debug_show_rx_cpld = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dcks_err ", 9 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 9 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "CKS_ERR Debug On" );
            
            debug_cks_err = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 9 ), ( uint8_t *) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "CKS_ERR Debug Off" );
            
            debug_cks_err = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * )"dinvite ", 8 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Invite Debug ON" );
            
            debug_invite = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 8 ), ( uint8_t * ) "off",3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Invite Debug ON" );
            
            debug_invite = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dparallel ", 10 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 10 ), ( uint8_t * )"on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Parallel Write Debug On" );
            
            dparallel = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 10 ), ( uint8_t *)"off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Parallel Write Debug Off" );
    
            dparallel = false;
        }
    } 
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dtelos ", 7 ) ) 
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Telemetry Debug On" );
            
            debug_telemetry = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 7 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Telemetry Debug Off" );
            
            debug_telemetry = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dcks ", 5 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "CKS Debug On" );
            
            debug_cks = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * )"off",3 ) )
        {
            miss_match = false;
            
            vz_printf ( "CKS Debug Off" );
            
            debug_cks = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "cc ", 3 ) )
    {
        miss_match = false;
        
        int ext,port;
        char *split, *ref, *cmd;

        ref = debug_buf;

        strcat ( debug_buf, "\r" );

        split = strtok ( debug_buf + 3, " " );
        ext = atoi ( split );

        port = ext;

        split += strlen ( split ) + 1;
        cmd = split;

        promptcb_last_ext = ext;
        promptcb_last_port = port;

        strcpy ( promptcb_last_cmd, cmd );

        for ( register int i = strlen ( cmd ); i < DEBUGBUFSIZE; i++ ) cmd [ i ] = 0;

        send2callboxes( build_cb_package( ext, port, PROMPT, cmd, id_msg++, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );
        
        vz_printf ( "ext=%d port=%d cmd=%s\r\nComando enviado", ext, port, cmd );

        debug_buf = ref;
        
        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "bc ", 3 ) )
    {
        miss_match = false;

        strcat ( debug_buf, "\r" );

        char * cmd = debug_buf + 3;

        for ( register int i = strlen( cmd ); i < DEBUGBUFSIZE; i++ ) cmd [ i ] = 0;

        send2callboxes ( build_cb_package ( BROADCAST_EXT, BROADCAST_EXT, PROMPT, cmd, id_msg++, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );
        
        vz_printf ( "ext=%x port=%x cmd=%s\r\nComando enviado", BROADCAST_EXT, BROADCAST_EXT, cmd );

        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }


    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "pcb ", 4 ) )
    {
        miss_match = false;
        
        int ext,port;
        char *split, *ref, *cmd;

        ref = debug_buf;

        strcat ( debug_buf, "\r" );

        split = strtok ( debug_buf + 4, " " );
        ext = atoi ( split );

        port = convert_ext_to_port ( ext );
        split += strlen ( split ) + 1;
        cmd = split;

        promptcb_last_ext = ext;
        promptcb_last_port = port;

        strcpy ( promptcb_last_cmd, cmd );

        for ( register int i = strlen ( cmd ); i < DEBUGBUFSIZE; i++ ) cmd [ i ] = 0;

        send2callboxes( build_cb_package( ext, port, PROMPT, cmd, id_msg++, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );
        
        vz_printf ( "ext=%d port=%d cmd=%s\r\nComando enviado", ext, port, cmd );
        
        debug_buf = ref;
        
        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "pend_all" ) )
    {
        miss_match = false;

        char cmd_msg [ CB_BUFFER_SIZE ] = "pend\r";

        for ( register int i = strlen ( cmd_msg ); i < CB_BUFFER_SIZE; i++ ) cmd_msg [ i ] = 0;

        send2callboxes ( build_cb_package ( BROADCAST_EXT, BROADCAST_EXT, PROMPT, cmd_msg, id_msg++, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );
        
        vz_printf ( "ext=%x port=%x cmd=%s\r\nComando enviado", BROADCAST_EXT, BROADCAST_EXT, cmd_msg );
        
        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "bye ", 4 ) )
    {
        miss_match = false;
        
        int ext,port;
        char * ref;

        ref = debug_buf;

        strcat ( debug_buf, "\r" );

        ext = atoi ( strtok ( debug_buf + 4, " " ) );

        port = ext;

        promptcb_last_ext = ext;
        promptcb_last_port = port;

        char msg [ CB_BUFFER_SIZE ] = "";

        for ( register int i = 0; i < CB_BUFFER_SIZE; i ++ ) msg [ i ] = 0;

        strcpy ( msg, "bye" );

        send2callboxes ( build_cb_package ( ext, port, CB_BYE, msg, ( id_msg++ & ~BIT7 ), CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );

        vz_printf ( "Send BYE to ext=%d port=%d\r\nComando enviado", ext, port );

        debug_buf = ref;
        
        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "end_call ", 9 ) )
    {
        miss_match = false;
        
        char * ref;

        ref = debug_buf;

        end_call_ext = atoi ( strtok ( debug_buf + 9, " " ) );
        
        end_call = true;

        debug_buf = ref;
        
        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;

        vz_printf( "kill call :: %u\r\n> ", end_call_ext );
    }
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "pair", 4 ) )
    {
        miss_match = false;
        
        char * ref = debug_buf;
        
        char * split = strtok ( debug_buf + 4, " " );
        
        u16Who_is_your_pair = atoi ( split );
        
        boolWho_is_your_pair = true;
        
        debug_buf = ref;
        
        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }
    
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "registra", 8 ) )
    {
        miss_match = false;
        
        char * ref = debug_buf;
        
        char * split = strtok ( debug_buf + 9, " " );
        
        ext_to_be_registered = atoi ( split );
        
        need_registry_someone = true;
        
        debug_buf = ref;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "msg", 3 ) )
    {
        miss_match = false;

        char * ref = debug_buf;

        if ( ( strlen ( debug_buf ) == strlen ( "msg" ) ) or ( strstr ( debug_buf + 4, "help" ) not_eq ( NULL ) ) )
        {
           vz_printf ("usage: msg < ext > < msg_id > < type >" );
        } else {

            char * split = strtok ( debug_buf + 4, " " );
            int ext = atoi ( split );
            int port = ext;

            // <msg_id>
            split += strlen ( split ) + 1;
            split = strtok( NULL, " " );

            int seq_num = ( strncasecmp ( split, "0x", 2 )  ) ? atoi ( split ) : ( int ) strtol ( split + 2, NULL, 16 );

            // <type>
            split += strlen ( split ) + 1;
            split = strtok ( NULL, " " );

            uint8_t num_type = 0;

            char type [ 16 ];

            strncpy ( type, split, sizeof ( type ) - 1 );

            if ( not ( strcasecmp ( type, "REGISTRY" ) ) ) num_type = REGISTRY;

            else if ( not ( strcasecmp ( type, "INVITE" ) ) ) num_type = INVITE;

            else if ( not ( strcasecmp ( type, "BOOT" ) ) ) num_type = BOOT;

            else if ( not ( strcasecmp ( type, "TELEMETRY" ) ) ) num_type = TELEMETRY;

            else if ( not ( strcasecmp ( type, "bye" ) ) ) num_type = CB_BYE;

            else if ( not ( strcasecmp ( type, "PROMPT" ) ) ) num_type = PROMPT;

            char cmd [ 32 ] = "";

            if ( num_type not_eq PROMPT ) for( register int i = 0; i < 32; i++ ) cmd [ i ] = 0;

            else strcpy ( cmd, "ping\r" );

            send2callboxes( build_cb_package( ext, port, num_type, cmd, seq_num, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );
            
            vz_printf ( "ext=%d port=%d msg_id=%#x type=%#x", ext, port, seq_num, num_type );
        }

        debug_buf = ref;
        
        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "simula", 6 ) )
    {
        miss_match = false;

        char * ref = debug_buf;

        if ( ( strlen ( debug_buf ) == strlen ( "simula" ) ) or ( strstr ( debug_buf + 6, "help" ) not_eq ( NULL ) ) )
        {
           vz_printf ("usage: simula < ext > < msg_id > < type>" );
        } else {
            simulate = true;
            
            char * split = strtok ( debug_buf + 6, " " );
            ext_to_simulate = atoi ( split );
            port_to_simulate = ext_to_simulate;

            // <msg_id>
            split += strlen ( split ) + 1;
            split = strtok( NULL, " " );

            seq_num_to_simulate = ( strncasecmp ( split, "0x", 2 )  ) ? atoi ( split ) : ( int ) strtol ( split + 2, NULL, 16 );

            // <type>
            split += strlen ( split ) + 1;
            split = strtok ( NULL, " " );

            num_type_to_simulate = 0;

            char type [ 16 ];

            strncpy ( type, split, sizeof ( type ) - 1 );

            if ( not ( strcasecmp ( type, "REGISTRY" ) ) ) num_type_to_simulate = REGISTRY;

            else if ( not ( strcasecmp ( type, "INVITE" ) ) ) num_type_to_simulate = INVITE;

            else if ( not ( strcasecmp ( type, "BOOT" ) ) ) num_type_to_simulate = BOOT;

            else if ( not ( strcasecmp ( type, "TELEMETRY" ) ) ) num_type_to_simulate = TELEMETRY;

            else if ( not ( strcasecmp ( type, "bye" ) ) ) num_type_to_simulate = CB_BYE;

            else if ( not ( strcasecmp ( type, "PROMPT" ) ) ) num_type_to_simulate = PROMPT;
            
            vz_printf ( "ext=%d port=%d msg_id=%#x type=%#x", ext_to_simulate, port_to_simulate, seq_num_to_simulate, num_type_to_simulate );
        }

        debug_buf = ref;
        
        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }
    

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "pcc ", 4 ) ) 
    {
        miss_match = false;
        
        int ext,port;
        char *split, *ref, *cmd;

        ref = debug_buf;

        strcat ( debug_buf, "\r" );

        split = strtok ( debug_buf + 4, " " );
        ext = atoi ( split );

        split += strlen ( split ) + 1;
        split = strtok ( NULL, " " );
        port = atoi ( split );

        split += strlen ( split ) + 1;
        cmd = split;

        promptcb_last_ext = ext;
        promptcb_last_port = port;

        strcpy ( promptcb_last_cmd, cmd );

        for ( register int i = strlen( cmd ); i < DEBUGBUFSIZE; i++ ) cmd [ i ] = 0;
        
        send2callboxes ( build_cb_package( ext, port, PROMPT, cmd, id_msg++, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );
        
        vz_printf ( "ext=%d port=%d cmd=%s\r\nComando enviado", ext, port, cmd );

        debug_buf = ref;
        
        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "print_cb ", 9 ) )
    {
        miss_match = false;
        char *split;

        split = strtok ( debug_buf + 9, " " );
        if( 0 == ( strcasecmp( split, "all" ) ) )
        {
            print_cb_all = true;
        } else {
            print_cb_var = true;
            print_this_cb = atoi ( split );
        }

        bufptr = 0;
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "drop_ack ", 9 ) )
    {
        miss_match = false;
        char *split;

        split = strtok( debug_buf + 9, " " );

        drop_this_amount_of_ack_to_ast = atoi( split );

        vz_printf ("Will be droped %d acks", drop_this_amount_of_ack_to_ast );

        bufptr = 0;
        for( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf[ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "frtp ", 5 ) )
    {
        miss_match = false;
        char *split;

        split = strtok ( debug_buf + 5, " " );
        frtp = true;
        frtp_target = atoi ( split );

        bufptr = 0;
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "rrtp ", 5 ) )
    {
        miss_match = false;
        char *split;

        split = strtok ( debug_buf + 5, " " );
        rescue_rtp = true;
        rescue_rtp_target = atoi ( split );

        split += strlen ( split ) + 1;
        split = strtok( NULL, " " );
        rescue_rtp_value = atoi ( split );

        bufptr = 0;
        for ( register uint16_t i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "print_hex_cb ", 13 ) )
    {
        miss_match = false;
        char *split;

        split = strtok ( debug_buf + 13, " " );
        if( 0 == ( strcasecmp ( split, "all" ) ) )
        {
            print_hex_cb_all = true;
        } else {
            print_hex_cb_var = true;
            print_hex_this_cb = atoi ( split );
        }

        bufptr = 0;
        for ( register uint16_t i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * )"print_sip ", 10 ) )
    {
        miss_match = false;
        
        char *split;

        split = strtok ( debug_buf + 10, " " );
        if ( 0 == ( strcasecmp ( split, "all" ) ) ) 
        {
            print_sip_all = true;
        } else {
            print_sip_var = true;
            print_this_sip = atoi ( split );
        }

        bufptr = 0;
        for ( register uint16_t i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * )"print_hex_sip ", 14 ) )
    {
        miss_match = false;
        char *split;

        split = strtok ( debug_buf + 14, " " );
        if ( 0 == ( strcasecmp ( split, "all" ) ) )
        {
            print_hex_sip_all = true;
        } else {
            print_hex_sip_var = true;
            print_hex_this_sip = atoi ( split );
        }

        bufptr = 0;
        for ( register uint16_t i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * )"print_call ", 11 ) )
    {
        miss_match = false;
        char *split;

        split = strtok ( debug_buf + 11, " " );
        if ( 0 == ( strcasecmp ( split, "all" ) ) )
        {
            print_call_all = true;
        } else {
            print_call_var = true;
            print_this_call = atoi ( split );
        }

        bufptr = 0;
        for ( register uint16_t i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t *)debug_buf, ( uint8_t * ) "print_hex_call ", 15 ) )
    {
        miss_match = false;
        
        char *split;

        split = strtok( debug_buf + 15, " " );
        if ( 0 == ( strcasecmp ( split, "all" ) ) )
        {
            print_hex_call_all = true;
        } else {
            print_hex_call_var = true;
            print_hex_this_call = atoi ( split );
        }

        bufptr = 0;
        for ( register uint16_t i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "print_rtp ", 10 ) ) 
    {
        miss_match = false;
        char *split;

        split = strtok ( debug_buf + 10, " " );
        if ( 0 == ( strcasecmp ( split, "all" ) ) )
        {
            print_rtp_all = true;
        } else {
            print_rtp_var = true;
            print_this_rtp = atoi ( split );
        }

        bufptr = 0;
        for ( register uint16_t i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "print_hex_rtp ", 14 ) )
    {
        miss_match = false;
        
        char *split;

        split = strtok ( debug_buf + 14, " " );
        if ( 0 == ( strcasecmp ( split, "all" ) ) )
        {
            print_hex_rtp_all = true;
        } else {
            print_hex_rtp_var = true;
            print_hex_this_rtp = atoi ( split );
        }

        bufptr = 0;
        for ( register uint16_t i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "log ", 4 ) )
    {
        miss_match = false;

        char * split = strtok ( debug_buf + 4, " " );

        {
            print_cb_var = true;
            print_this_cb = atoi ( split );
            print_sip_var = true;
            print_this_sip = print_this_cb;
            print_call_var = true;
            print_this_call = print_this_cb;
            print_rtp_var = true;
            print_this_rtp = print_this_cb;
        }

        bufptr = 0;
        for ( register uint16_t i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }


    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "rush ", 5 ) ) 
    {
        miss_match = false;
        
        int ext,port;
        char *split, *ref, cmd [ 32 ];

        ref = debug_buf;

        strcat ( debug_buf, "\r" );

        split = strtok ( debug_buf + 5, " " );
        ext = atoi ( split );

        split += strlen ( split ) + 1;
        split = strtok ( NULL, " " );
        port = atoi ( split );

        strcpy ( cmd, "ping\r\n" );

        promptcb_last_ext = ext;
        promptcb_last_port = port;

        strcpy ( promptcb_last_cmd, cmd );
        strcat ( cmd, "\r\r\r\n" );

        for ( register uint8_t i = 0; i < 3; i++ )
        {
            
            send2callboxes ( build_cb_package ( ext, port, PROMPT, cmd, id_msg++, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );
            
            vz_printf ( "ext=%d port=%d cmd=%s\r\nComando enviado", ext, port, cmd );
        }

        debug_buf = ref;
        bufptr = 0;
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }


    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "_", 4 ) )
    {
        miss_match = false;
        
        debug_buf [ bufptr++ ] = 0x0D;
        debug_buf [ bufptr++ ] = 0x00;

        send2callboxes ( build_cb_package ( promptcb_last_ext, promptcb_last_port, PROMPT, debug_buf + 4, id_msg++, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );
        
        vz_printf ( "ext=%d port=%d\r\ncmd=%s\r\nComando enviado",promptcb_last_ext, promptcb_last_port, debug_buf + 4 );
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "cks",3 ) )
    {
        miss_match = false;
        pcks_s = true;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "showcb",6 ) )
    {
        miss_match = false;
        pshowcb = true;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "debug_main ", 11 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 11 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug Main On" );
            
            debug_main = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 11 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug Main Off" );
            
            debug_main = 0;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dout ", 5 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;

            vz_printf ( "Out Debug On" );

            debug_out_of_range = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Out Debug Off" );
            
            debug_out_of_range = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dboot ", 6 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Boot Debug On" );
            
            debug_boot = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 6 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Boot Debug Off" );
            
            debug_boot = false;
        }
    }
    
    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dnewcall ", 9 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 9 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Allocation VZ_Call Debug On" );
            
            debug_alloc_vz_call = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 9 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Allocation VZ_Call Debug Off" );
            
            debug_alloc_vz_call = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dbloader ", 9 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 9 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Bootloader Debug On" );
            
            debug_bootloader = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 9 ), ( uint8_t * ) "off", 3 ) ) {
            miss_match = false;
            
            vz_printf ( "Bootloader Debug Off" );
                
            debug_bootloader = false;
        }
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dpower" ) )
    {
        miss_match = false;
        
        if ( !power_source_status )
        {
            vz_printf ( "Main power is UP" );
        } else {
            vz_printf ( "Main power is DOWN" );
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dfw ", 4 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 4 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "FW Debug On" );
            
            debug_fw = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 4 ), ( uint8_t * ) "off", 3 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "FW Debug Off" );
                
            debug_fw = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dfwp ", 5 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ("FWPrint Debug On" );
            
            debug_fw_print = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 5 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ("FWPrint Debug Off" );
            
            debug_fw_print = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "drx ", 4 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 4 ), ( uint8_t * ) "on", 2 ) ) 
        {
            miss_match = false;
            
            vz_printf ( "Debug Cbx Rx On" );
            
            debug_cb_rx = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 4 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug Cbx Rx Off" );
            
            debug_cb_rx = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "dtx ", 4 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 4 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug Cbx Tx On" );
            
            debug_cb_tx = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 4 ), ( uint8_t * ) "off", 3 ) )
        {
            
            miss_match = false;
            
            vz_printf ( "Debug Cbx Tx Off" );
            
            debug_cb_tx = false;
        }
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "debug_file ", 11 ) )
    {
        if ( xmemmatch ( ( uint8_t * )( debug_buf + 11 ), ( uint8_t * ) "on", 2 ) )
        {
            miss_match = false;
        
            vz_printf ( "Debug File On" );
            
            debug_file = true;
        }
        else if ( xmemmatch ( ( uint8_t * )( debug_buf + 11 ), ( uint8_t * ) "off", 3 ) )
        {
            miss_match = false;
            
            vz_printf ( "Debug File Off" );
            
            debug_file = false;
        }
    }

    else if ( xstrmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "help" ) )
    {
        miss_match = false;
        
        vz_printf ( "**************************** PROMPT HELP ****************************" );
        vz_printf ( "help_setup" );
        vz_printf ( "help_debug" );
        vz_printf ( "help_command_to_cbx" );
        vz_printf ( "help_protocol" );
        vz_printf ( "help_cbx_list" );
        vz_printf ( "help_io" );
        
        vz_printf ( "reset - resta o sistema" );
        vz_printf ( "PROMPT VERSION: V%d -- %s - %s", PVERSION, __DATE__, __TIME__);
        
        strcpy ( last_cmd, tmp_cmd );
        
        bufptr = 0;
        
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    else if ( xmemmatch ( ( uint8_t * )debug_buf, ( uint8_t * ) "callme ", 7 ) )
    {
        miss_match = false;
        int ext,port;
        char cmd[ 16 ];

        ext = atoi( debug_buf + 7 );
        port = convert_ext_to_port ( ext );

        strcpy( cmd, ( ext % 2 ) ? "call init B" : "call init A" );

        if( ext % 2 ) ext--;

        promptcb_last_ext = ext;
        promptcb_last_port = port;

        int tmp = strlen( cmd );
        cmd[ tmp ] = 0x0D;
        cmd[ tmp + 1 ] = 0x00;
        strcpy( promptcb_last_cmd, cmd );

        send2callboxes( build_cb_package( ext, port, PROMPT, cmd, id_msg++, CB_BUFFER_SIZE - VZ_HEADER_OFFSET, prompt_write_buffer ) );
        
        vz_printf ( "ext=%d port=%d\r\ncmd=%s\r\n\n\rComando enviado\n\r", ext, port, cmd );

        bufptr = 0;
        for ( register int i = 0; i < DEBUGBUFSIZE; i++ ) debug_buf [ i ] = 0;
    }

    if ( miss_match )
    {
        vz_printf ( "> %s: command not found", debug_buf );    
        
    } else {
        if ( from_eth && strlen ( debug_buf ) > 2 ) strcpy ( last_cmd, tmp_cmd );

        else if ( strlen ( debug_buf ) > 2 ) strcpy ( last_cmd, tmp_cmd );
    }
    
    return( NULL );
}