#ifndef __POWER_SOURCE_MONITORING_H__
#define __POWER_SOURCE_MONITORING_H__

#include "mbed.h"
#include "bits.h"
#include "EthernetInterface.h"
#include "debug.h"
#include "vz_protocol.h"
%: include "config_manager.h"
%: include "shared_variables.h"
%: include "string.h"

const uint16_t u16_POWER_SOURCE_PORT = 4000;
const uint8_t u8_WAIT_TO_WARN = 60;
const uint8_t u8_POWER_MSG_LENGTH = strlen ( "mainpowerisdown" );

extern Timer power_source_timer;
extern DigitalIn pwr_src_in;
extern UDPSocket power_source_client;
extern Endpoint pwr_src_server;
extern uint8_t power_source_status;

/* Inicializacao da comunicacao UDP com o servidor para monitoramento de fonte de alimentacao */
int init_power_source ();
int reconnect_power_source ( void );

#endif