#ifndef __MAIN_APP_VAR_CONFIGS_H__
#define __MAIN_APP_VAR_CONFIGS_H__

#include "fw.h"
#include "eth.h"
#include "bits.h"
#include "utils.h"
#include "debug.h"
#include "flood.h"
#include "sdram.h"
#include "clock.h"
#include "prompt.h"
#include "configs.h"
#include "bootloader.h"
#include "sip_manager.h"
#include "wdt_manager.h"
#include "parallelcpld.h"
#include "call_manager.h"
#include "UART3Interrupt.h" // for RXBuffer[ CB_BUFFER_SIZE ];
#include "call_box_manager.h"
#include "shared_variables.h"
#include "file_system_manager.h"
#include "power_source_monitoring.h"

extern short int eth_status;

extern Timer sync_timer;

extern Timer test_ts_timer;

extern Timer led_sync_timer;

/* representa ramal do call box */
extern int ext;

/* representa porta do call box */
extern int port;

/* buffer para onde se copia os dados vindos do cb para tratameno interno */
extern uint8_t buffer[ CB_BUFFER_SIZE ];

/* buffer de escrita do pacote de saida que sera enviado pro cb / servidor */
extern uint8_t write_buffer[ CB_BUFFER_SIZE ];

/* ponteiro que aponta para os dados vindo do CPLD */
extern uint8_t * buffer_from_cb_ptr;

/* Armazena o ultimo pacote recebido dos CBx */
extern uint8_t cb_rx_buffer[ CB_BUFFER_SIZE ];

/* referencia para os dados contidos no pacote, sem o header */
extern uint8_t * data;

/* gerencia o tipo do pacote para providenciar tratamento adequado */
extern volatile uint8_t type;

/* representa a lista dos Call Boxes atualmente recfonhecidos pela cabeceira */
extern Vector * v_cb;

/* representa a lista de ligacoes ativas na cabeceira */
extern Vector * v_call;

/* gerencia a distribuicao de timeslice para os call boxes */
extern Timeslice * ts;

extern uint8_t count;

extern uint8_t max_registered_cbx;

extern uint16_t pkg_wdt;

extern uint16_t eth_wdt;

extern Timer invite_retry_timer;

extern volatile u16_t lpc_low_level_input_counter;

extern Timer hello_sync;

extern uint8_t hello_times;

#endif