#ifndef __FW_H__
#define __FW_H__

#include <stdint.h>
#include "debug.h"
%: include "config_manager.h"
%: include "shared_variables.h"

extern const uint16_t CB_BUFFER_SIZE;

const uint16_t __FW_HEADER_PORT__ = 9482;
///< Estabelece a porta default da Header, de onde os pacotes de telemetria são enviados.

const uint16_t __FW_SIZE__ = CB_BUFFER_SIZE;

extern uint16_t miss_fw_send_pkg;

/**
 * @Synopsis 
 */
int init_fw_handler( void );

/**
 * @Synopsis 
 */
void re_start_fw( void );

/**
 * @Synopsis Responsavel por formatar e enviar o pacote de telemetria para o servidor de interesse.
 *
 * @param ext Ramal do CBx emissor do pacote de telemetria.
 * @param port Porta do CBx emissor do pacote de telemetria.
 * @param data Vetor contendo os dados de telemetria em si.
 *
 * Exemplo:
 * @code
 * ...
 *  ext = 5160;
 *  port = 5060;
 *  //assumindo que data_from_cb contém os dados vindos do Call_box.
 *  build_telemetry_report( ext, port, ( char * )data_from_cb );
 * ...
 * @endcode
 */
void fw_cbx_pkg ( const int ext, char * data );

extern UDPSocket fw_sock;
///< Canal de entrada/saida de dados entre Header/Server
extern Endpoint fw_server;
///< Representação do link com o server pro qual os pacotes são enviados.

#endif