%: include "config_manager.h"

extern Serial pc;

ConfigManager::ConfigManager ( void )
{   
    int siRet = fget_ip ( chHeader_ip, sizeof ( chHeader_ip ) );
    
    if ( siRet < 0 ) 
    {
        strncpy ( chHeader_ip, MY_IP, sizeof ( chHeader_ip ) - 1  );
        set_header_ip ( MY_IP );
    }
    
    siRet = fget_server_ip ( chServer_ip, sizeof ( chServer_ip ) );
    
    if ( siRet < 0 ) 
    {
        strncpy ( chServer_ip, SERVER_IP, sizeof ( chServer_ip ) - 1  );   
        set_server_ip ( SERVER_IP );
    }
    
    siRet = fget_mask ( chNet_mask, sizeof ( chNet_mask ) );
    
    if ( siRet < 0 ) 
    {
        strncpy ( chNet_mask, MY_MSK, sizeof ( chNet_mask ) - 1  );
        set_net_mask ( MY_MSK );
    }
    
    siRet = fget_gateway ( chGateway, sizeof ( chGateway ) );
    
    if ( siRet < 0 ) 
    {
        strncpy ( chGateway, MY_GTW, sizeof ( chGateway ) - 1  );
        set_gateway ( MY_GTW );
    }
    
    siRet = fget_fw_ip ( chFw_server_ip, sizeof ( chFw_server_ip ) );
    
    if ( siRet < 0 ) 
    {
        strncpy ( chFw_server_ip, FW_SERVER_IP, sizeof ( chFw_server_ip ) - 1  );
        set_fw_server_ip ( FW_SERVER_IP );
    }
    
    siRet = fget_header_ext ();
    
    if ( siRet < 0 ) 
    { 
        u16Ext = u16_MY_EXT; 
        set_header_ext ( u16_MY_EXT );
    } 
        else 
    {
        u16Ext = ( uint16_t ) siRet; 
    }
    
    siRet = fget_header_sip_port ();
    
    if ( siRet < 0 ) 
    {
        u16Port = u16_MY_PORT; 
        set_header_sip_port ( u16_MY_PORT );
    } 
        else 
    {
        u16Port = ( uint16_t ) siRet; 
    }
    
    siRet = fget_server_ext ();
    
    if ( siRet < 0 ) 
    { 
        u16Server_ext = u16_PEER_EXT; 
        set_server_ext ( u16_PEER_EXT );
    } 
        else 
    { 
        u16Server_ext = ( uint16_t ) siRet; 
    }
    
    siRet = fget_server_port ();
    
    if ( siRet < 0 ) 
    { 
        u16Server_port = u16_SERVER_PORT; 
        set_server_port ( u16_SERVER_PORT );
    } 
        else 
    { 
        u16Server_port = ( uint16_t ) siRet; 
    }
    
    siRet = fget_fw_port ();
    
    if ( siRet < 0 ) 
    { 
        u16Fw_server_port = u16_FW_SERVER_PORT;
        set_fw_server_port ( u16_FW_SERVER_PORT );
    } 
        else 
    { 
        u16Fw_server_port = ( uint16_t ) siRet; 
    }
    
    siRet = fget_max_ext ();
    
    if ( siRet < 0 ) 
    { 
        u16Max_ext = u16_MAX_EXT; 
        set_max_ext ( u16_MAX_EXT );
    } 
        else 
    { 
        u16Max_ext = ( uint16_t ) siRet; 
    }
    
    siRet = fget_min_ext ();
    
    if ( siRet < 0 ) 
    { 
        u16Min_ext = u16_MIN_EXT; 
        set_min_ext ( u16_MIN_EXT );
    } 
        else 
    { 
        u16Min_ext = ( uint16_t ) siRet; 
    }
    
    siRet = fget_shift_port ();
    
    if ( siRet < 0 ) 
    { 
        u16Shift_port = u16_SHIFT_PORT;
        set_shift_port ( u16_SHIFT_PORT );
    } 
        else 
    { 
        u16Shift_port = ( uint16_t ) siRet; 
    }
    
    siRet = fget_acceptable_delay ();
    
    if ( siRet < 0 ) 
    { 
        u8Acceptable_delay = u8_ACCEPTABLE_DELAY;
        fset_acceptable_delay ( u8_ACCEPTABLE_DELAY );
    } 
        else 
    { 
        u8Acceptable_delay = ( uint8_t ) siRet; 
    }
    
    
    siRet = fget_tcp_port_listener ();
    
    if ( siRet < 0 ) 
    { 
        u16Tcp_port_listener = u16_TCP_PORT_LISTENER; 
        set_tcp_port_listener ( u16_TCP_PORT_LISTENER );
    } 
        else 
    { 
        u16Tcp_port_listener = ( uint16_t ) siRet; 
    }
    
    siRet = fget_udp_port_listener ();
    
    if ( siRet < 0 ) 
    { 
        u16Udp_port_listener = u16_UDP_PORT_LISTENER;
        set_udp_port_listener ( u16_UDP_PORT_LISTENER );
    }
        else 
    { 
        u16Udp_port_listener = ( uint16_t ) siRet;
    }
    
    strcpy ( this -> chClock_erver_ip, this -> chServer_ip );
    
    boolCallBoxDetachMode = fget_cbx_detach_mode ( &siRet );
    
    if ( siRet < 0 ) 
    { 
        boolCallBoxDetachMode = false;
        set_cbx_detach_mode ( false );
    }
    
    boolCallBoxWakeMode = fget_cbx_wake_mode ( &siRet );
    
    if ( siRet < 0 ) 
    { 
        boolCallBoxWakeMode = true;
        set_cbx_wake_mode ( true );
    }
    
    siRet = fget_cbx_mode ();
    
    if ( siRet < 0 ) 
    { 
        u8CallBoxMode = u8_CUSTOM_MODE;
        fset_cbx_mode ( u8_CUSTOM_MODE );
    } 
        else 
    { 
        u8CallBoxMode = ( uint8_t ) siRet;
        
        if ( u8CallBoxMode == u8_FIBRA_MODE )
        {
            boolCallBoxWakeMode = true;
            boolCallBoxDetachMode = false;
        }
        else if ( u8CallBoxMode == u8_RADIO_MODE )
        {
            boolCallBoxWakeMode = false;
            boolCallBoxDetachMode = true;
        }
    }
    
    set_modified_false ();
}

ConfigManager::~ConfigManager ( void ) {}

void ConfigManager::restore_defaults_settings ( void )
{
    set_fw_server_ip ( FW_SERVER_IP );
    set_fw_server_port ( u16_FW_SERVER_PORT );
    set_gateway ( MY_GTW );
    set_header_ext ( u16_MY_EXT );
    set_header_ip ( MY_IP );
    set_header_sip_port ( u16_MY_PORT );
    set_max_ext ( u16_MAX_EXT );
    set_min_ext ( u16_MIN_EXT );
    set_net_mask ( MY_MSK );
    set_server_ext ( u16_PEER_EXT );
    set_server_ip ( SERVER_IP );
    set_server_port ( u16_SERVER_PORT );
    set_shift_port ( u16_SHIFT_PORT );
    set_tcp_port_listener ( u16_TCP_PORT_LISTENER );
    set_udp_port_listener ( u16_UDP_PORT_LISTENER );

    set_modified_true ();
}



char * ConfigManager::get_header_ip ( char * buffer )
{
    strcpy ( buffer, chHeader_ip );
    return ( buffer );
}

char * ConfigManager::get_server_ip ( char * buffer )
{
    strcpy ( buffer, chServer_ip );
    return ( buffer );
}

char * ConfigManager::get_clock_server_ip ( char * buffer )
{
    return ( get_server_ip ( buffer ) );
}

char * ConfigManager::get_net_mask ( char * buffer )
{
    strcpy ( buffer, chNet_mask );
    return ( buffer );
}

char * ConfigManager::get_gateway ( char * buffer )
{
    strcpy ( buffer, chGateway );
    return ( buffer );
}

char * ConfigManager::get_fw_server_ip ( char * buffer )
{
    strcpy ( buffer, chFw_server_ip );
    return ( buffer );
}
uint8_t ConfigManager::get_acceptable_delay ( void ) { return u8Acceptable_delay; }

uint16_t ConfigManager::get_ext ( void ) { return ( u16Ext ); }

uint16_t ConfigManager::get_port ( void ) { return ( u16Port ); }

uint16_t ConfigManager::get_server_ext ( void ) { return ( u16Server_ext ); }

uint16_t ConfigManager::get_server_port ( void ) { return ( u16Server_port ); }

uint16_t ConfigManager::get_fw_server_port ( void ) { return ( u16Fw_server_port ); }

uint16_t ConfigManager::get_max_ext ( void ) { return ( u16Max_ext ); }

uint16_t ConfigManager::get_min_ext ( void ) { return ( u16Min_ext ); }

uint16_t ConfigManager::get_shift_port ( void ) { return ( u16Shift_port ); }

uint16_t ConfigManager::get_udp_port_listener ( void ) { return ( u16Udp_port_listener ); }

uint16_t ConfigManager::get_tcp_port_listener ( void ) { return ( u16Tcp_port_listener ); }

bool ConfigManager::was_modified ( void ) { return boolModified; }

bool ConfigManager::get_cbx_detach_mode ( void ) { return boolCallBoxDetachMode; }

bool ConfigManager::get_cbx_wake_mode ( void ) { return boolCallBoxWakeMode; }

uint8_t ConfigManager::get_cbx_mode ( void ) { return u8CallBoxMode; }

void ConfigManager::set_header_ip ( const char * new_Header_ip ) 
{ 
    fset_header_ip ( new_Header_ip );
    strcpy ( chHeader_ip, new_Header_ip );
    set_modified_true ();
    boolHeader_ip_was_modified = true;
}

void ConfigManager::set_server_ip ( const char * new_Server_ip ) 
{
    fset_server_ip ( new_Server_ip );
    strcpy ( chServer_ip, new_Server_ip ); 
    set_modified_true ();
    boolServer_ip_was_modified = true;
}

void ConfigManager::set_net_mask ( const char * new_Net_mask ) 
{
    fset_mask ( new_Net_mask );
    strcpy ( chNet_mask, new_Net_mask ); 
    set_modified_true ();
    boolNet_mask_was_modified = true;
}

void ConfigManager::set_gateway ( const char * new_Gateway )
{
    fset_gateway ( new_Gateway );
    strcpy ( chGateway, new_Gateway ); 
    set_modified_true ();
    boolGateway_was_modified = true;
}

void ConfigManager::set_fw_server_ip ( const char * new_Fw_server_ip )
{ 
    fset_fw_ip ( new_Fw_server_ip );
    strcpy ( chFw_server_ip, new_Fw_server_ip ); 
    set_modified_true ();
    boolFw_server_ip_was_modified = true;
}

void ConfigManager::set_header_ext ( const uint16_t new_Ext )
{
    fset_header_ext ( new_Ext );
    u16Ext = new_Ext; 
    set_modified_true ();
    boolHeader_ext_was_modified = true;
}

void ConfigManager::set_header_sip_port ( const uint16_t new_Port )
{   
    fset_header_sip_port ( new_Port );
    u16Port = new_Port; 
    set_modified_true ();
    boolHeader_sip_port_was_modified = true;
}

void ConfigManager::set_server_ext ( const uint16_t new_Server_ext )
{ 
    fset_server_ext ( new_Server_ext );
    u16Server_ext = new_Server_ext; 
    set_modified_true ();
    boolServer_ext_was_modified = true;
}

void ConfigManager::set_server_port ( const uint16_t new_Server_port ) 
{ 
    fset_server_port ( new_Server_port );
    u16Server_port = new_Server_port; 
    set_modified_true ();
    boolServer_port_was_modified = true;
}

void ConfigManager::set_fw_server_port ( const uint16_t new_Fw_server_port ) 
{ 
    fset_fw_port ( new_Fw_server_port );
    u16Fw_server_port = new_Fw_server_port; 
    set_modified_true ();
    boolFw_server_port_was_modified = true;
}

void ConfigManager::set_max_ext ( const uint16_t new_Max_ext ) 
{ 
    fset_max_ext ( new_Max_ext );
    u16Max_ext = new_Max_ext; 
    set_modified_true ();
    boolMax_ext_was_modified = true;
}

void ConfigManager::set_min_ext ( const uint16_t new_Min_ext )
{ 
    fset_min_ext ( new_Min_ext );
    u16Min_ext = new_Min_ext; 
    set_modified_true ();
    boolMin_ext_was_modified = true;
}

void ConfigManager::set_shift_port ( const uint16_t new_Shift_port )
{ 
    fset_shift_port ( new_Shift_port );
    u16Shift_port = new_Shift_port; 
    set_modified_true ();
    boolShift_port_was_modified = true;
}

void ConfigManager::set_acceptable_delay ( const uint8_t new_acceptable_delay )
{
    u8Acceptable_delay = new_acceptable_delay;
    fset_acceptable_delay ( new_acceptable_delay );
}


void ConfigManager::set_udp_port_listener ( const uint16_t new_udp_port_listener )
{
    u16Udp_port_listener = new_udp_port_listener;
}

void ConfigManager::set_tcp_port_listener ( const uint16_t new_tcp_port_listener )
{
    u16Tcp_port_listener = new_tcp_port_listener;
}

void ConfigManager::set_cbx_detach_mode ( const bool new_cbx_detach_mode )
{
    boolCallBoxDetachMode = new_cbx_detach_mode;
    fset_cbx_detach_mode ( new_cbx_detach_mode );
    cbx_custom_mode_check ();
}

void ConfigManager::set_cbx_wake_mode ( const bool new_cbx_wake_mode )
{
    boolCallBoxWakeMode = new_cbx_wake_mode;
    fset_cbx_wake_mode ( new_cbx_wake_mode );
    cbx_custom_mode_check ();
}

void ConfigManager::set_cbx_mode ( const uint8_t new_cbx_mode )
{
    u8CallBoxMode = new_cbx_mode;
    fset_cbx_mode ( new_cbx_mode );
            
    if ( u8CallBoxMode == u8_FIBRA_MODE )
    {
        boolCallBoxWakeMode = true;
        boolCallBoxDetachMode = false;
    }
    else if ( u8CallBoxMode == u8_RADIO_MODE )
    {
        boolCallBoxWakeMode = false;
        boolCallBoxDetachMode = true;
    }
}

void ConfigManager::set_modified_true ( void ) { boolModified = true; }

void ConfigManager::set_modified_false ( void )
{
    boolModified = false; 
    boolHeader_ip_was_modified = false;
    boolServer_ip_was_modified = false;
    boolNet_mask_was_modified = false;
    boolGateway_was_modified = false;
    boolFw_server_ip_was_modified = false;
    boolHeader_ext_was_modified = false;
    boolHeader_sip_port_was_modified = false;
    boolServer_ext_was_modified = false;
    boolServer_port_was_modified = false;
    boolFw_server_port_was_modified = false;
    boolMax_ext_was_modified = false;
    boolMin_ext_was_modified = false;
    boolShift_port_was_modified = false;
}

bool ConfigManager::header_ip_was_modified ( void ) { return boolHeader_ip_was_modified; }
bool ConfigManager::server_ip_was_modified ( void ) { return boolServer_ip_was_modified; }
bool ConfigManager::net_mask_was_modified ( void ) { return boolNet_mask_was_modified; }
bool ConfigManager::gateway_was_modified ( void ) { return boolGateway_was_modified; }
bool ConfigManager::fw_server_ip_was_modified ( void ) { return boolFw_server_ip_was_modified; }
bool ConfigManager::header_ext_was_modified ( void ) { return boolHeader_ext_was_modified; }
bool ConfigManager::header_sip_port_was_modified ( void ) { return boolHeader_sip_port_was_modified; }
bool ConfigManager::server_ext_was_modified ( void ) { return boolServer_ext_was_modified; }
bool ConfigManager::server_port_was_modified ( void ) { return boolServer_port_was_modified; }
bool ConfigManager::fw_server_port_was_modified ( void ) { return boolFw_server_port_was_modified; }
bool ConfigManager::max_ext_was_modified ( void ) { return boolMax_ext_was_modified; }
bool ConfigManager::min_ext_was_modified ( void ) { return boolMin_ext_was_modified; }
bool ConfigManager::shift_port_was_modified ( void ) { return boolShift_port_was_modified; }

void ConfigManager::cbx_custom_mode_check ( void )
{
    uint8_t value = 0;
    if ( ( boolCallBoxWakeMode == true ) and ( boolCallBoxDetachMode == false ) ) value = ( u8_FIBRA_MODE );
    
    else if ( ( boolCallBoxWakeMode == false ) and ( boolCallBoxDetachMode == true ) ) value = ( u8_RADIO_MODE );
    
    else { value = u8_CUSTOM_MODE; }
    
    u8CallBoxMode = value;
    fset_cbx_mode ( value );
}