#ifndef __CALL_BOX_MANAGER_H__
#define __CALL_BOX_MANAGER_H__

#include "vector.h"
#include "call_box.h"
#include <stdlib.h>
#include "parallelcpld.h"
#include "utils.h"
#include "ring_buffer.h"

%: include "shared_variables.h"

const uint8_t __SLEEP_TIME__ = 45;

extern Timer timer_refresh;
extern Timer timer_aging;
extern Timer timer_sync_refresh;

const uint8_t TIME_TO_REFRESH = 1;
const uint8_t TIME_TO_WAKE_UP = 2;

/**
 * @Synopsis Busca por um determinado Call_box no vetor de Call_box usando como chave de busca o ramal.
 *
 * @param v_cb O vetor contendo todos os Call_box conhecidos pela Header em determinado momento.
 * @param ext O ramal pelo qual se irá buscar o CBx.
 *
 * @return NULL caso não tenha sido encontrado nenhum CBx com esse ramal; retorna um ponteiro para o Call_box que possui esse ramal,
 * caso o mesmo tenha sido encontrado.
 *
 * Exemplo:
 * @code
 * ...
 *  Vector * v_cb = new Vector();
 *      //assumindo que esse vetor de Call_Box já foi populado.
 *  int ext = 5218;
 *  Call_Box * cb = find_CB( v_cb, ext );
 * ...
 * @endcode
 */
Call_Box * find_CB ( Vector * v_cb, const int ext );

/**
 * @Synopsis Função responsavel por "envelhecer" os registros na Header, na prática, é essa função que pergunta de tempo
 * em tempo se o CBx ainda continua ativo; Essa função também é responsavel por remover o CBx do v_cb assim como deletar o elemento cb
 * assossiado.
 *
 * @param v_cb Um vetor contendo todos os Call_box conhecidos pela Header em um determinado momento.
 * @param data Usado para a criação do pacote de "ping" que a Header irá enviar para o CBx.
 * @param write_buffer Local de memória onde efetivamente irá ser montado o pacote para envio ao CBx do pacote de "ping" ( Registry ).
 *
 * Exemplo:
 * @code
 * ...
 *  Vector * v_cb = new Vector();
 *      //assumindo que esse vetor de Call_Box já foi populado.
 *  uint8_t buffer[ 300 ];
 *      uint8_t write_buffer[ 300 ];
 *  registry_aging( v_cb, buffer, write_buffer );
 * ...
 * @endcode
 */
 
int refresh ( Vector * v_cb );
 
inline int init_refresh ()
{ 
    timer_refresh.start(); 
    return ( 0 );
}

inline int init_sync_refresh ()
{ 
    timer_sync_refresh.start(); 
    return ( 0 );
}
 
void wake_all_up ( Vector * v_cb );

#endif