#include "wdt.h"
 
 /// Watchdog gets instantiated at the module level
Watchdog::Watchdog() {
    wdreset = (LPC_WDT->MOD >> 2) & 1;    // capture the cause of the previous reset
}
 
/// Load timeout value in watchdog timer and enable
void Watchdog::Configure(float s) {
    //LPC_WDT->CLKSEL = 0x1;                // Set CLK src to PCLK
    uint32_t clk = 500000 / 4;    // WD has a fixed /4 prescaler, and a 500khz oscillator
    LPC_WDT->TC = ( uint32_t )( s * ( float )clk );
    LPC_WDT->MOD = 0x3;                   // Enabled and Reset
    kick();
}
 
/// "Service", "kick" or "feed" the dog - reset the watchdog timer
/// by writing this required bit pattern
void Watchdog::kick() {
    //x = NVIC_disable_IRQ();
    /*
        antes de desabilitar as irqs, eu preciso salvar o status delas
    */
    //IRQn irqn;
    //uint16_t ret = NVIC_GetActive( irqn );
    //debug_msg( "NVIC_GetActive --%i--", ret );
    //debug_msg("+");
    //__disable_irq();
    //Interrupt ID == 0 -- Exception Number 16
    LPC_WDT->FEED = 0xAA;
    LPC_WDT->FEED = 0x55;
    
    //__enable_irq();
    //debug_msg(".");
}

bool Watchdog::WatchdogCausedReset(){
    return( this->wdreset );
}