/**
 * @file utils.h
 * @Synopsis Funções de propósito geral são encontradas nesse arquivo. 
 * @author Jhonatan Casale
 * @version 1
 * @date 2014-11-06
 */

#ifndef __UTILS_H__
#define __UTILS_H__

#include "shared_variables.h"
#include <stdint.h>

/**
 * @Synopsis Responsavel por escutar a porta de conexão com o servidor, verificando se o mesmo mandou algum dado.
 *
 * @param v_cb Um vetor contendo todos os Call_box conhecidos pela Header em um determinado momento.
 * @param v_call Um vetor contendo todas as vz_calls em andamento em um dado momento.
 *
 * @return 0 ( zero ) se tudo correu bem, um numero menor do que zero, caso algum problema tenha acontecido na execusão, e um numero
 * maior que zero indicando o ramal que deve ser removido do vetor de ligações.
 *
 * Exemplo:
 * @code
 * ...
 *  Vector * v_cb = new Vector();
 *  Vector * v_call = new Vector();
 *      // assumindo que os vetores já foram populados.
 *  int ret = sip_manager( v_cb, v_call );                                                                  
 *  if( ret > 0x00 ){
 *          // tratar esse request
 *  }          
 * ...
 * @endcode
 */

/**
 * @Synopsis Função usada na ordenação dos CBx para exibição no comando "ls"
 *
 * @param a O primeiro ramal que se quer comparar.
 * @param b O segundo ramal que se quer comparar.
 *
 * @return 0 ( zero ) se os valores forem iguais, maior que zero, se o primeiro valor ser maior que o segundo e retorna um numero
 * negativo, caso o segundo valor seja maior que o primeiro.
 *
 * Exemplo:
 * @code
 * ...
 *  int a = 10;
 *  int b = 119;
 *  int result = ls_comp( ( const void * )&a, ( const void * )&b );
 * ...
 * @endcode
 */
int ls_comp ( const void * a, const void * b );

int wake_comp ( const void * a, const void * b );

/**
 * @Synopsis Função que converte o ramal para a porta, por definição de projeto, cara ramo possui o numero da centena incremental
 * permanecendo o resto igual, por exemplo no ramo pilo os ramais são 5000, 5001 -- no lote 1 5100, 5101 -- porem a porta sempre
 * se manteve a mesma, o CBx esta configurado como ramal 5000 e porta 5000, assim como o ramal 5100 e porta 5000, em outras palavras
 * dado um ramal, calcular a porta é o mesmo que eliminar a centena do numero.
 *
 * @param ext O ramal do qual se quer calcular a porta vinculada.
 *
 * @return O valor calculado da porta.
 *
 * Exemplo:
 * @code
 * ...
 *  int ext = 5220;
 *  int port = convert_ext_to_port( ext );
 * ...
 * @endcode
 */
int convert_ext_to_port ( int ext );

void xmemcpy( uint8_t * dest, const uint8_t * src, uint16_t size );
void xmemcpy32( uint32_t * dest, uint32_t * src, uint16_t size );
uint8_t xstrmatch( const uint8_t * s1, const uint8_t * s2 );
uint8_t xmemmatch(const uint8_t * s1, const uint8_t * s2, uint16_t size);

int hex_init(void);                                             
char * hex8 (uint8_t i);                                         
char * hex16 (uint16_t i); 

#endif