#include "utils.h"

static char itoh[16];
char hexbuf[10];

int hex_init(void) {
  itoh[0] = '0'; itoh[1] = '1'; itoh[2] = '2'; itoh[3] = '3';
  itoh[4] = '4'; itoh[5] = '5'; itoh[6] = '6'; itoh[7] = '7';
  itoh[8] = '8'; itoh[9] = '9'; itoh[10] = 'a'; itoh[11] = 'b';
  itoh[12] = 'c'; itoh[13] = 'd'; itoh[14] = 'e'; itoh[15] = 'f';
  return ( 0 );
}

char * hex8 (uint8_t i) { 
  hexbuf[0] = itoh[(i>>4) & 0x0f];
  hexbuf[1] = itoh[i & 0x0f];
  hexbuf[2] = 0;
  return hexbuf;
}

char * hex16 (uint16_t i) {
  hexbuf[0] = itoh[(i>>12) & 0x0f];
  hexbuf[1] = itoh[(i>>8) & 0x0f];
  hexbuf[2] = itoh[(i>>4) & 0x0f];
  hexbuf[3] = itoh[i & 0x0f];
  hexbuf[4] = 0;
  return hexbuf;
}

int ls_comp ( const void * a, const void * b )
{ 
    if ( reverse_list ) return( *( int * )b - *( int * )a ); 
    
    else return( *( int * )a - *( int * )b ); 

}

int wake_comp ( const void * a, const void * b )
{ 
    return( *( int * )a - *( int * )b ); 
}

int 
convert_ext_to_port( int ext ) { return ( ext ); }

void xmemcpy(uint8_t * dest, const uint8_t * src, uint16_t size ){
  while (size--) *dest++ = *src++;
}

void xmemcpy32(uint32_t * dest, uint32_t * src, uint16_t size){
  size >>= 2;
  while (size--) *dest++ = *src++;
}

uint8_t xstrmatch(const uint8_t * s1, const uint8_t * s2){
  while (*s1) {
    if (*s1++ != *s2++) return 0; /* does not match */
  }
  if ( *s2 == 0 )
    return 1; /* matches */
  else
    return 0; /* does not match */
}

uint8_t xmemmatch(const uint8_t * s1, const uint8_t * s2, uint16_t size){
  while (size--) {
    if (*s1++ != *s2++) return 0; /* does not match */
  }
  return 1; /* matches */
}