#ifndef __SIP_MANAGER_H__
#define __SIP_MANAGER_H__

#include "vector.h"
#include "call_box.h"
/**
 * @Synopsis Responsavel por escutar a porta de conexão com o servidor, verificando se o mesmo mandou algum dado.
 *
 * @param v_cb Um vetor contendo todos os Call_box conhecidos pela Header em um determinado momento.
 * @param v_call Um vetor contendo todas as vz_calls em andamento em um dado momento.
 *
 * @return 0 ( zero ) se tudo correu bem, um numero menor do que zero, caso algum problema tenha acontecido na execusão, e um numero
 * maior que zero indicando o ramal que deve ser removido do vetor de ligações.
 *
 * Exemplo:
 * @code
 * ...
 *  Vector * v_cb = new Vector();
 *  Vector * v_call = new Vector();
 *      // assumindo que os vetores já foram populados.
 *  int ret = sip_manager( v_cb, v_call );                                                                  
 *  if( ret > 0x00 ){
 *          // tratar esse request
 *  }          
 * ...
 * @endcode
 */
int sip_manager( Vector * v_cb ); 

#endif