#include "rtpbuf.h"

void rtpbuf_clear (rtpbuf_t * self) {
  self->size = 0;
}

void rtpbuf_put (rtpbuf_t * self, int size, uint8_t * data){
  if ((size + self->size) <= RTPBUF_BUFSIZE){
    xmemcpy((uint8_t*)self->b+self->size,data,size);
    self->size += size;
  }
}

uint8_t * rtpbuf_get (rtpbuf_t * self) {
  if (self->size < RTPBUF_PKGSIZE) { return NULL; }
  
  return (uint8_t*) self->b;
}

void rtpbuf_next (rtpbuf_t * self) {
  if (self->size >= RTPBUF_PKGSIZE){
    self->size -= RTPBUF_PKGSIZE;
    if (self->size > 0) {
      xmemcpy32(self->b, (self->b)+(RTPBUF_PKGSIZE>>2), self->size);
    }
  }
}