#include "rtp.h"

RTP_Header::RTP_Header( int cb_ext ){
    // por algum motivo do alem, comecar do 0 nao funcionou
    ss_id = 0x01010101 + ( uint32_t )cb_ext;
    seq_number = 0x0101;
    timestamp = 240;
}

RTP_Header::~RTP_Header(){
    // something
}

char * RTP_Header::build_header( char * pkg ){
    if( pkg == NULL ) return( NULL );
    
    for( register int i = 0; i < RTP_HEADER_SIZE; i++ ) pkg[ i ] = 0xff;

    pkg[ 0 ] &= 0x80;
    
    pkg[ 1 ] &= 0x08;

    pkg[ 2 ] = 0xff;
    pkg[ 2 ] &= ( char )( seq_number >> 8 );
    pkg[ 3 ] &= ( char )( seq_number & 0xff );
    
    pkg[ 4 ] &= ( char )( timestamp >> 24 & 0xff  );
    pkg[ 5 ] &= ( char )( timestamp >> 16 & 0xff );
    pkg[ 6 ] &= ( char )( timestamp >> 8 & 0xff );
    pkg[ 7 ] &= ( char )( timestamp & 0xff );
    
    pkg[ 8 ] &= ( char )( ss_id >> 24 & 0xff );
    pkg[ 9 ] &= ( char )( ss_id >> 16 & 0xff );
    pkg[ 10 ] &= ( char )( ss_id >> 8 & 0xff );
    pkg[ 11 ] &= ( char )( ss_id & 0xff );
    
    pkg[ RTP_HEADER_SIZE ] = 0;
    timestamp += 240;
    seq_number++;
    
    return( pkg );
}

size_t RTP_Header::size( void ){
    return( RTP_HEADER_SIZE );    
}

RTP_Body::RTP_Body(){
    // do something
}

RTP_Body::~RTP_Body(){
    // something
}

size_t RTP_Body::size( void ){
    return( sizeof( RTP_Body ) );    
}

char * RTP_Body::build_body( char * dest, char * buffer ){
    for( register int i = 0; i < CB_AUDIO_DATA_SIZE; i++ ) dest[ i ] = buffer[ i ];
    return( dest );
}

RTP::RTP( int ext ){
    rtp_header = new RTP_Header( ext );
    
    if( rtp_header == NULL )
    {
        memory_is_over = true;
        if( debug_rtp == true ) vz_printf ("[%d] RTP_HEADER allocation failed", ext );
        if( debug_memory ) vz_debug ("[%d] RTP_Header allocation fail", ext );
    }
        else
    {
        rtp_header_new_counter++;
    }
    
    rtp_body = new RTP_Body();
    if( rtp_body == NULL )
    {
        memory_is_over = true;
        if( debug_rtp == true ) vz_printf ("[%d] RTP_BODY allocation failed", ext );
        if( debug_memory ) vz_debug ("[%d ]RTP_Body allocation fail", ext );
    }
        else
    {
        rtp_body_new_counter++;   
    }
    
    buffer [ 0 ] = '\0';
    pkg [ 0 ] = '\0';
}

RTP::~RTP(){
    if( rtp_header != NULL)
    {
        delete( rtp_header );
        rtp_header_delete_counter++;    
    }
    if( rtp_body != NULL )
    {
        delete( rtp_body );
        rtp_body_delete_counter++;
    }
}

char * RTP::build_eth_package( char * buffer ){
    if( rtp_header != NULL ) rtp_header->build_header( this->pkg );
    if( rtp_body != NULL ) rtp_body->build_body( this->pkg + RTP_HEADER_OFFSET, buffer );
    return( this->pkg );
}

size_t RTP::header_size( void ){
    //if( rtp_header != NULL ) return rtp_header->size();
    return ( rtp_header != NULL ) ? rtp_header->size() : 0;
}

int RTP::print_yourself ( void )
{
    vz_printf ("buffer :: %p", ( void * ) buffer );
    vz_printf ("pkg :: %p", ( void * ) pkg );
    vz_printf ("rtp_header :: %p", ( void * ) rtp_header );
    vz_printf ("rtp_body :: %p", ( void * ) rtp_body );
    if ( rtp_header != NULL )
    {
        vz_printf ("ss_id :: %d", rtp_header -> get_ss_id () );
        vz_printf ("seq_number :: %d", rtp_header -> get_seq_number () );
        vz_printf ("timestamp :: %d", rtp_header -> get_timestamp () );
    }
        else
    {
        vz_printf ("Objeto rtp_header nao vinculado");    
    }
    return ( sizeof( RTP ) );    
}