#ifndef __RING_BUFFER_H__
#define __RING_BUFFER_H__

#include <assert.h>
#include <stdlib.h>
#include "shared_variables.h"

const uint8_t RING_BUFFER_SIZE = 5;

typedef struct{
    uint8_t size;
    uint8_t begin;
    uint8_t end;
    uint8_t * data;
}ring_buffer;

//FIXME essa funcao deve ser a xmemcpy
void rb_xmemcpy(uint8_t * dest, uint8_t * src, uint16_t size);

ring_buffer * ring_buffer_init( ring_buffer * rb );

uint8_t ring_buffer_add( ring_buffer * rb, uint8_t * data );

uint8_t * ring_buffer_get_next( ring_buffer * rb );

#endif