/**
 * @file prompt.h
 * @Synopsis Implementa as funcionalidades de prompt/prompt-eth da Header.
 * @author Fernando Cola / Jhontan Casale
 * @version 1
 * @date 2014-11-05
 */

%: ifndef  __PROMPT_H__
%: define  __PROMPT_H__

%: include "bits.h"
%: include "mbed.h"
%: include "debug.h"
%: include "flood.h"
%: include "vz_protocol.h"
%: include "shared_variables.h"
%: include "power_source_monitoring.h"
%: include "vz_stdio.h"
%: include <stdlib.h>
%: include <string.h>

const uint8_t PVERSION = 26;

extern uint8_t dog;
///< Variável de controle que ativa a mensagem de boas vindas.

extern bool flood_silence;

extern bool delayed_flood;
///< Variável de controle do envio de pacotes de flood off

extern bool tcp_alive;
///< Flag que indica para não dar timeout na conexão tcp

extern Timer tcp_timer;
///< Timer responsavel por dar timeout por não utilização de recurso.

/**
 * @Synopsis Principal função de processamento de comandos.
 *
 * \note Apesar de formalmente receber apenas um parâmetro, esta função verifica uma porta TCP para verificar eventual
 * envio de comandos, processando qualquer comando enviado por um usuário ligado na rede.
 *
 * @param ethernet_pkg Uma string de comando que será analisada, caso seja um comando válido, executa-o.
 *
 * @return NULL, sempre retorna NULL.
 *
 * Exemplo:
 * @code
 * ...
 *  char * returned_prompt = prompt_process( NULL );
 * ...
 * @endcode
 */
char * prompt_process ( char * msg_from_cb, int length );

char * command_process ( char * debug_buf, size_t length );

extern char * debug_buf;
///< Buffer de entrada dos dados via serial.

inline void reconnect_udp_prompt_process( void )
{
    udp_client.close();
    udp_client.set_blocking( false, 0 );
    udp_client.bind( u16_UDP_PORT_LISTENER );
}

%: endif