#include "power_source_monitoring.h"

Timer power_source_timer;

DigitalIn pwr_src_in ( p25, PullDown );
//DigitalIn pwr_src_in ( p25, PullUp );

UDPSocket power_source_client;

Endpoint pwr_src_server;

uint8_t power_source_status = 0;

/* Inicializacao da comunicacao UDP com o servidor para monitoramento de fonte de alimentacao */
int init_power_source () {
    char server_ip [ 16 ];
    
    /* Inicializacao do timer de leitura de fonte de alimentacao */
    power_source_timer.stop ();
    power_source_timer.reset ();
    
    /* Inicializacao do comunicacao UDP */
    power_source_client.set_blocking( false, 0 );
    power_source_client.bind ( u16_POWER_SOURCE_PORT );
    
    // Criar depois, se quiser, arquivo para PWR_SRC_PORT
    cm -> get_server_ip ( server_ip );
    pwr_src_server.set_address ( server_ip , u16_POWER_SOURCE_PORT );
    
    power_source_timer.start ();
    
    return ( 0 );
}

int 
end_power_source ( void )
{
    power_source_client.close ();
    
    return ( 0 );
}

int 
reconnect_power_source ( void )
{
    end_power_source ();
    init_power_source ();
    
    return ( 0 );
}