#include "parallelcpld.h"

DigitalOut data0(p30);                      //LSB
DigitalOut data1(p31);
DigitalOut data2(p32);
DigitalOut data3(p33);
DigitalOut data4(p34);
DigitalOut data5(p37);
DigitalOut data6(p38);
DigitalOut data7(p39);                      //MSB

DigitalOut DataReady(p11);                  
///<IO 27

DigitalOut hw_extern_wdt( p23 );

uint8_t cb_tx_buffer [ CB_BUFFER_SIZE ];

uint8_t TXBuffer[ CB_BUFFER_SIZE ]; 

uint8_t tx_clear = 1;

ring_buffer * rb = ring_buffer_init( NULL );

// Print a variable using parallel protocol
void parallel_write( uint8_t data ){   
    data0 = BIT0&(data);
    data1 = BIT1&(data);
    data2 = BIT2&(data);
    data3 = BIT3&(data);
    data4 = BIT4&(data);
    data5 = BIT5&(data);
    data6 = BIT6&(data);
    data7 = BIT7&(data);        
}

// Needs: function parallel_write/ Global variables: TXBuffer, tx_clear / Configuration extern interrupt
void send2callboxes( uint8_t * buffer )
{   
    if ( drop_entendi_pkg and ( buffer[ TYPE_PLACE ] == INVITE ) )
    {
        vz_debug ( "Droped entendi pkg" );
        return;    
    }

    if( tx_clear == 1 )
    {
        tx_clear = 0;
        xmemcpy ( TXBuffer, buffer, CB_BUFFER_SIZE );
        
        // Send the first position of TXBuffer first
        parallel_write ( TXBuffer [ 0 ] );
        DataReady = 1;
        
        cpld_pkg_tx_counter++;
        
        uint16_t ext = ( ( uint16_t )buffer[ 0 ] ) << 8  | buffer[ 1 ];
        uint16_t port = ( ( uint16_t )buffer[ 2 ] ) << 8  | buffer[ 3 ];
        uint8_t type = buffer [ TYPE_PLACE ];
        
        if ( debug_fw )
        {
            buffer[ 0 ] |= BIT7;
            fw_cbx_pkg ( ext, ( char *)buffer );
        }
        
        if ( ( type not_eq AUDIO ) and not ( do_not_show_this_invite_pkg ) )
        {
            xmemcpy ( cb_tx_buffer, buffer, CB_BUFFER_SIZE );
            
            if ( debug_show_tx_cpld )
            {
                char str [ 256 ];
                strcpy ( str, "TX :: \n\r" );
                for ( register uint16_t i = 0; i < 32; i++ )
                {
                    char tmp [ 8 ];
                    sprintf ( tmp, "%02x ", cb_tx_buffer [ i ] );
                    strcat ( str, tmp );
                }
                strcat ( str, "\n\r " );
                
                vz_printf ( "%s", str );
            }
            
            if ( debug_cb_tx ) vz_printf ("H -> CBx :: ( %d, %d ) -- Type :: %d", ext, port, type );
            
            if ( debug_sqn ) vz_printf ("H -> CBx :: ( %d, %d ) -- Type :: %d -- seq_num :: %u", ext, port, type, cb_tx_buffer [ SEQ_NUM_PLACE ] );
        }
        
        do_not_show_this_invite_pkg = false;
         
    }else{
        // Error if the transmission is still in use
        uint8_t ret = ring_buffer_add( rb, buffer );
        
        delayed_pkg_to_cb++;
        
        if( ret == 0x01 ) if( dparallel ) vz_debug ("Error: Ring buffer fully charged");
        
        if( ret == 0x00 ) if( dparallel ) vz_debug ("Success : package queued -- on queue %u", rb->size );
    }
}

//*****************************************************************************
//                            EXTERN IRQ Handler
//*****************************************************************************

void get2(){       
    static uint16_t c = 1;
    // Get Ready the new data
    DataReady = 0;
    tx_clear = 0;
    
    if ( c < 300 ){
        // Write the next data to be send
        parallel_write ( TXBuffer[c] ) ;
        // Allow the data to be capture
        DataReady = 1;
    }else{
        // Allow the next package to the transmitted
        tx_clear = 1;
        c = 0;
    }
    c++;
}

void tx_buffer_ring_buffer_handler( void ){
    if( ( rb->size != 0x00 ) && ( tx_clear == 1 ) ){
        uint8_t * _rb_next = ring_buffer_get_next( rb );
        if( dparallel ) vz_printf ( "Ring Buffer less one -- remain %u", rb->size );
        send2callboxes( _rb_next );        
    }
}