#include "fw.h"

UDPSocket fw_sock;                                                                                                                      
Endpoint fw_server;
uint16_t miss_fw_send_pkg = 0;

int init_fw_handler ( void )
{
    char buffer_fw_server_ip [ 16 ] = "";
    
    cm -> get_fw_server_ip ( buffer_fw_server_ip );
    
    int addr = fw_server.set_address ( buffer_fw_server_ip , ( int ) cm -> get_fw_server_port () );
    
    if ( debug_fw ) vz_printf (" Valor de retorno set_address -- %d ", addr );
    
    int bind = fw_sock.bind ( __FW_HEADER_PORT__ );
    
    fw_sock.set_blocking ( false, 0 );
    
    if( debug_fw ) vz_printf (" Valor de retorno bind -- %d ", bind );
    
    return ( 0 );
}

void re_start_fw ( void )
{
    int close = fw_sock.close ();
    if ( debug_fw || debug_reconnect ) vz_printf (" Valor de retorno close-- %d ", close );
    
    init_fw_handler ();
}

void fw_cbx_pkg ( const int ext, char * data )
{
    if ( data not_eq NULL ) 
    {
        static uint8_t fw_cbx_pkg_id = 0x00;
        
        data [ CB_BUFFER_SIZE - 1 ] = fw_cbx_pkg_id ++;
         
        int send = fw_sock.sendTo ( fw_server, data, CB_BUFFER_SIZE );
        
        if ( send not_eq CB_BUFFER_SIZE )
        {
            if ( debug_reconnect )
            {
                vz_printf ( "[%d] Reconnect FW - %d", ext, send );
            }
            
            miss_fw_send_pkg ++;
            re_start_fw ();
        }
    }
}