/**
 * @file flood.h
 * @Synopsis Instrumenta o teste de envio recebimento de pacotes que simulam o envio, recebimento de pacotes em uma ligação.
 * @author Pedro
 * @version 1
 * @date 2014-11-05
 */
#ifndef _FLOOD_H__
#define _FLOOD_H__

#include <stdint.h>
#include "mbed.h"
#include "vz_protocol.h"
#include "shared_variables.h"
#include "debug.h"
#include "parallelcpld.h"

extern bool pflood;
///< Variável de controle que liga/desliga o flood da Header.
extern Timer tflood;
///< Timer de controle para envio dos pacotes de forma temporizada ( 20 ms )
extern int floodcount;
///< Variável de controle que junto com o tflood, organiza a temporização do envio de pacotes da Header pro CBx.

/**
 * @Synopsis Funçao que efetivamente monta e envia os pacotes do tipo flood para os CBx
 */
void flood();

#endif