#ifndef __FILE_SYSTEM_MANAGER_H__
#define __FILE_SYSTEM_MANAGER_H__

#include "QSPIFileSystem.h"
%: include "bits.h"

const uint16_t FILE_BUFFER_SIZE = 1024;

extern QSPIFileSystem qspifs;

/**
 * @Synopsis Altera o valor default contido no arquivo /qspi/myip.txt
 *
 * @param new_header_ip Atualiza o valor de /qspi/myip.txt sobrescrevendo-o com o valor de new_header_ip
 *
 * Exemplo:
 * @code
 * ...
 *  set_ip( "192.168.120.2" );
 * ...
 * @endcode
 */
int fset_header_ip ( const char * new_header_ip );
int fget_ip ( char * header_ip, const size_t length );

/**
 * @Synopsis Altera o valor default contido no arquivo /qspi/myext.txt
 *
 * @param new_header_ext Atualiza o valor de /qspi/myext.txt sobrescrevendo-o com o valor de new_header_ext
 *
 * Exemplo:
 * @code
 * ...
 *  set_header_ext( 912 );
 * ...
 * @endcode
 */
int fset_header_ext ( const int new_header_ext );
int fget_header_ext ( void );

/**
 * @Synopsis Altera o valor default contido no arquivo /qspi/mysipport.txt
 *
 * @param new_header_sip_port Atualiza o valor de /qspi/mysipport.txt sobrescrevendo-o com o valor de new_header_sip_port
 *
 * Exemplo:
 * @code
 * ...
 *  set_header_sip_port( 820 );
 * ...
 * @endcode
 */
int fset_header_sip_port ( const int new_header_sip_port );
int fget_header_sip_port ( void );


/**
 * @Synopsis Altera o valor default contido no arquivo /qspi/serverip.txt
 *
 * @param new_server_ip Atualiza o valor de /qspi/serverip.txt sobrescrevendo-o com o valor de new_server_ip
 *
 * Exemplo:
 * @code
 * ...
 *  set_header_sip_port( "192.168.120.231" );
 * ...
 * @endcode
 */
int fset_server_ip ( const char * new_server_ip );
int fget_server_ip ( char * server_ip, const size_t length );

/**
 * @Synopsis Altera o valor default contido no arquivo /qspi/peerext.txt
 *
 * @param new_server_ext Atualiza o valor de /qspi/peerext.txt sobrescrevendo-o com o valor de new_server_ext
 *
 * Exemplo:
 * @code
 * ...
 *  set_header_sip_port( 1011 );
 * ...
 * @endcode
 */
int fset_server_ext ( const int new_server_ext );
int fget_server_ext ( void );

/**
 * @Synopsis Altera o valor default contido no arquivo /qspi/serverport.txt
 *
 * @param new_server_port Atualiza o valor de /qspi/serverport.txt sobrescrevendo-o com o valor de new_server_port
 *
 * Exemplo:
 * @code
 * ...
 *  set_header_sip_port( 1562 );
 * ...
 * @endcode
 */
int fset_server_port ( const int new_server_port );
int fget_server_port ( void );

/**
 * @Synopsis Altera o valor default contido no arquivo /qspi/udpport.txt
 *
 * @param new_udp_port_listener Atualiza o valor de /qspi/udpport.txt sobrescrevendo-o com o valor de new_udp_port_listener
 *
 * Exemplo:
 * @code
 * ...
 *  set_udp_port_listener( 11147 );
 * ...
 * @endcode
 */
int set_udp_port_listener ( const int new_udp_port_listener );
int fget_udp_port_listener ( void );

/**
 * @Synopsis Altera o valor default contido no arquivo /qspi/tcpport.txt
 *
 * @param new_tcp_port_listener Atualiza o valor de /qspi/tcpport.txt sobrescrevendo-o com o valor de new_tcp_port_listener
 *
 * Exemplo:
 * @code
 * ...
 *  set_tcp_port_listener( 7178 );
 * ...
 * @endcode
 */
int set_tcp_port_listener ( const int new_tcp_port_listener );
int fget_tcp_port_listener ( void );

/**
 * @Synopsis Altera o valor default contido no arquivo /qspi/mymask.txt
 *
 * @param new_mask Atualiza o valor de /qspi/mymask.txt sobrescrevendo-o com o valor de new_mask
 *
 * Exemplo:
 * @code
 * ...
 *  set_mask( "255.255.0.0" );
 * ...
 * @endcode
 */
int fset_mask( const char * new_mask );
int fget_mask ( char * eth_mask, const size_t length );

/**
 * @Synopsis Altera o valor default contido no arquivo /qspi/mygateway.txt
 *
 * @param new_gateway Atualiza o valor de /qspi/mygateway.txt sobrescrevendo-o com o valor de new_gateway
 *
 * Exemplo:
 * @code
 * ...
 *  set_gateway( "192.168.118.2" );
 * ...
 * @endcode
 */
int fset_gateway ( const char * new_gateway );
int fget_gateway ( char * eth_gw, const size_t length );

int fset_max_ext ( const int new_max_ext );
int fget_max_ext ( void );

int fset_min_ext ( const int new_min_ext );
int fget_min_ext ( void );

int cat( const char * fname );

int files( const char type );

int fset_fw_ip ( const char * new_fw_ip );
int fget_fw_ip ( char * fw_ip, const size_t length );

int fset_fw_port ( const int new_fw_port );
int fget_fw_port ( void );

int fset_shift_port ( const int new_shift_port );
int fget_shift_port ( void );

int fset_acceptable_delay ( const int new_acceptable_delay );
int fget_acceptable_delay ( void );

int fset_cbx_detach_mode ( const bool new_cbx_detach_mode );
bool fget_cbx_detach_mode ( int * err );

int fset_cbx_wake_mode ( const bool new_cbx_wake_mode );
bool fget_cbx_wake_mode ( int * err );

int fset_cbx_mode ( const uint8_t new_cbx_mode );
int fget_cbx_mode ( void );

int init_fsystem ( void );

#endif