%: include "elapsed_timer.h"

bool boolInit_test = true;
bool boolEnd_test = false;
    
bool boolInit_test_mean = true;
bool boolEnd_test_mean = false;

Timer elapsed_timer;
Timer elapsed_timer_mean;

uint16_t u16Elapsed_time_count = u16_ELAPSED_TIME_COUNT_TIMES;

uint64_t u64Elapsed_time_u_sum = 0;

void elapsed_time_start ( void )
{
    elapsed_timer.start ();
    elapsed_timer.reset ();
}

int elapsed_time_end ( void )
{
    elapsed_timer.stop ();
    
    int u_elapsed_time = elapsed_timer.read_us ();
    
    vz_printf ( "Elapsed_time : [ %du, %dm, %ds ]", 
    
        u_elapsed_time, elapsed_timer.read_ms (), int ( elapsed_timer.read () ) );
    
    return ( u_elapsed_time );
}

void elapsed_time_mean_start ( void )
{
    if ( boolInit_test_mean )
    {
        u16Elapsed_time_count = u16_ELAPSED_TIME_COUNT_TIMES;
        
        u64Elapsed_time_u_sum = 0;
        
        boolInit_test_mean = false;
    }
    
    elapsed_timer_mean.start ();
    
    elapsed_timer_mean.reset ();
}

void elapsed_time_mean_end ( void )
{
    if ( u16Elapsed_time_count  )
    {
        u16Elapsed_time_count--;
    
        elapsed_timer_mean.stop ();
        
        u64Elapsed_time_u_sum += elapsed_timer_mean.read_us ();
        
        elapsed_timer_mean.start ();
        elapsed_timer_mean.reset ();
        
        if ( u16Elapsed_time_count == 0 ) boolEnd_test_mean = true;
    }
        else if ( boolEnd_test_mean )
    {
        vz_printf ( "Elapsed_time_mean : [ %.2lfu ]", double ( u64Elapsed_time_u_sum / u16_ELAPSED_TIME_COUNT_TIMES ) );
        
        boolEnd_test_mean = false;    
        boolInit_test_mean = true;
        
        elapsed_timer_mean.stop ();
    }
}