/**
 * @file debug.h
 * @Synopsis Instrumenta o uso de debug no código da header.
 * @author Jhonatan Casale / PedroZN
 * @version 1
 * @date 2014-11-05
 */
#ifndef __DEBUG_H__
#define __DEBUG_H__

%: include "shared_variables.h"
%: include "vz_stdio.h"

//%: define MODE_TEST 1

extern uint16_t string_msg_overflow;

extern uint16_t miss_prompt_udp_send_pkg;

extern UDPSocket eth_fw_debug;

extern Endpoint eth_fw_debug_server;

const uint16_t DEBUG_MSG_SIZE = 1024;

const uint8_t DEBUG_AUX_MSG_SIZE = 64;

extern char debug_msg1 [ DEBUG_MSG_SIZE + DEBUG_AUX_MSG_SIZE ];
///< Buffer usado na composisão da mensagem enviada pela macro debug_msg

extern char debug_msg2 [ DEBUG_MSG_SIZE ];
///< Buffer usado na composisão da mensagem enviada pela macro debug_msg

extern char msg_ [ DEBUG_MSG_SIZE ];
///< Buffer utilizado pela macro send_msg

extern bool cb_session;
///< Não utilizada atualmente.

extern bool cb_status;
///< Não utilizada atualmente.

extern bool debug_telemetry;
///< Variável de controle que aciona o debug de telemetria.

extern bool main_test;

extern bool main_test_mean;

extern bool sizes;

extern uint16_t miss_debug_fw_send_pkg;
extern uint16_t miss_sip_registry_send_pkg;
extern uint16_t miss_sip_invite_send_pkg;
extern uint16_t miss_sip_bye_send_pkg;
extern uint16_t miss_sip_ok_send_pkg;
extern uint16_t miss_sip_rcv_bye_send_pkg;
extern uint16_t miss_wdt_send_pkg;
extern uint16_t miss_sip_inc_pkg;
extern uint16_t miss_udp_prompt_send_pkg;
extern uint16_t miss_clock_send_pkg;

extern bool show_uptime;

extern bool debug_sip;
///< Variável de controle que ativa o debug sip.
extern bool debug_prompt;
///< Variável de controle que ativa o debug do prompt.
extern bool debug_vector;
///< Variável de controle que ativa o debug do vector.
extern bool debug_cb;
///< Variável de controle que ativa o debug da classe Call_box.
extern bool debug_main;
///< Variável de controle que ativa o debug da main.
extern bool debug_cks;
///< Variável de controle que ativa o debug do ckechsum dos pacotes recebidos.
extern bool debug_cb_rx;
///< Variável de controle que ativa o debug dos pacotes recebidos do CBx.
extern bool debug_cb_tx;
///< Variável de controle que ativa o debug dos pacotes enviados para o CBx.
extern bool debug_eth_rx;
///< Variável de controle que ativa o debug dos pacotes recebidos da eth \note não implementado.
extern bool debug_eth_tx;
///< Variável de controle que ativa o debug dos pacotes enviados para a eth \note não implementado.
extern bool debug_file;
///< Variável de controle que ativa o debug do sistema de arquivos.
extern bool dbl;
///< Variável de controle que ativa o debug do protocolo de bootloader dos CBx
extern bool dparallel;
///< Variável de controle que aciona o debug de envio de pacotes pro cb, quando se
///< quer transmitir um pacote enquanto outro pacote, já esta em transmissao.
extern bool test_debug;
///< Variável de controle que ativa o debug de test.
extern bool debug_aging;
///< Variável de controle que ativa o debug da funçao de aging do registro.

extern bool debug_clock;
extern bool debug_invite;
extern bool debug_wake;
extern bool debug_muted;
extern bool debug_cpld;
extern bool debug_show_tx_cpld;
extern bool debug_show_rx_cpld;
extern bool debug_cks_err;
extern bool debug_ping;
extern bool debug_refresh;
extern bool long_list;
extern bool debug_out_of_range;
extern bool debug_wdt;
extern bool debug_eth;
extern bool wdt_show;
extern bool debug_rtp;
extern bool debug_memory;
extern bool debug_port_match;
extern bool debug_fw;
extern bool debug_gp;
extern bool missed_send_udp_pkg;
extern bool debug_reconnect;

extern bool debug_boot;
extern bool debug_fw_print;
extern bool big_bug_pkg;
extern bool flood_bug_pkg;
extern uint16_t miss_rtp_udp_send_pkg;
extern bool reset_missed_send_udp_pkg;
extern bool debug_missed;
extern uint16_t deleted_sip;
extern bool dshow_rtp;
extern bool dcallshow_rtp;
extern bool debug_reset_rtp;
extern bool debug_rtp;
extern uint16_t deleted_sip;
extern bool print_values;
extern bool print_v_cb;
extern bool print_v_call;
extern bool print_cb_var;
extern bool print_cb_all;
extern bool print_hex_cb_var;
extern bool print_hex_cb_all;
extern bool print_sip_var;
extern bool print_sip_all;
extern bool print_hex_sip_var;
extern bool print_hex_sip_all;

extern bool print_call_var;
extern bool print_call_all;
extern bool print_hex_call_var;
extern bool print_hex_call_all;

extern bool print_rtp_var;
extern bool print_rtp_all;
extern bool print_hex_rtp_var;
extern bool print_hex_rtp_all;
extern bool frtp;
extern bool rescue_rtp;
extern bool drop_invite_pkg;
extern bool drop_entendi_pkg;
extern bool drop_invite_to_ast_pkg;
extern bool drop_ok_pkg;
extern bool drop_ack_pkg;
extern bool drop_rtp_from_ast_pkg;
extern bool drop_rtp_from_cbx_pkg;
extern bool drop_registry_pkg;
extern bool registra;
extern bool registra4;
extern bool debug_dont_refresh;
extern bool received_audio_from_cb;
extern uint16_t miss_rtp_udp_send_pkg;
extern bool debug_bootloader;
extern bool debug_bind;
extern bool debug_app_init;
extern bool debug_string_length;
extern bool show_current_time;
extern bool dmissed_wdt;
extern bool debug_hello;
extern bool debug_sqn;
extern bool test_ts;
extern bool debug_pwr_src;
extern bool debug_print_clock;
extern bool debug_resend_invite;
extern bool debug_pair;
extern uint16_t miss_rtp_udp_rcv_pkg;
extern bool debug_alloc_vz_call;

#endif