%: ifndef __CONFIG_MANAGER_H__
%: define __CONFIG_MANAGER_H__

%: include <stdint.h>
%: include <string.h>
%: include "file_system_manager.h"

/**
 * Classe que representa lógicamente os valores das variáveis de 
 * ambiente usadas pela Cabeceira, estas variáveis são arquivadas
 * em arquivos e carregadas durante o boot.
 *
 * Header IP 192.168.120.171
 * Header ext 820
 * Header port 5062
 * Server IP 192.168.120.120
 * Server ext 723
 * Server port 5075
 * Mascara de rede 255.255.255.0
 * Gateway IP 192.168.120.1
 * FW Server IP 192.168.120.120
 * FW Server Port 6667
 * Max Ext 6000
 * Min Ext 5000
 * Shift Port 3000
 */
 
const uint16_t u16_SHIFT_PORT = 3000;
///< Deslocamento padrão de porta, usado na forma <ext recebido + SHIFT_PORT>

const char MY_IP[] = "192.168.120.171";
///< Representa o IP default da Header.
//#define __MY_IP__ "192.168.2.20?" // Colinas
//#define __MY_IP__ "192.168.1.200" // Colinas

const char SERVER_IP[] =  "192.168.120.120";
///< Indica o IP defaut do servidor para onde a Header ira encaminhar pedidos de ligação.
//#define __SERVER_IP__ "192.168.30.25" // Colinas

const uint16_t u16_MIN_EXT = 1;
///< Define o valor minimo de ramal que sera processado.

const uint16_t u16_MAX_EXT = 5999;
///< Define o valor máximo de ramal que sera processado.

const uint16_t u16_MY_EXT = 820;
///< Indica o ramal default da Header.

const uint16_t u16_MY_PORT = 5062;
///< Representa a porta default da Header.

const uint16_t u16_PEER_EXT = 913;
///< Estabelece o ramal default para onde a Header ira direcionar os pedidos de ligações.
//#define __PEER_EXT__ 812 // VZ Producao
//#define __PEER_EXT__ 813 // VZ Desenvolvimento

const uint16_t u16_SERVER_PORT =  5075;
///< Indica a porta default do server para onde os pacotes eth serão enviados na negociação SIP.
//#define __SERVER_PORT__ 5060 // Colinas

const char MY_MSK[] =  "255.255.255.0";
///< Indica a mascara de rede onde a Header se encontra.
//#define __MY_GTW__ "192.168.2.254" // Colinas

const char MY_GTW[] = "192.168.120.1";  // vz
///< Indica o IP do Gateway de rede

const uint16_t u16_UDP_PORT_LISTENER = 11406;
///< Porta UDP na qual a Header espera por eventuais mensagens.

const uint16_t u16_TCP_PORT_LISTENER = 7879;
///< Porta TCP na qual a Header espera por eventuais mensagens.

const uint16_t u16_UDP_BOOTLOADER_PORT = 9891;
///< Porta UDP para tratativas do procedimento de gravação dos CBx.

const char FW_SERVER_IP[] =  "192.168.120.144";
///< Estabelece o IP default para onde os dados de telemetria são enviados.
const uint16_t u16_FW_SERVER_PORT = 9192;
///< Estabelece a porta default do servidor  para onde os dados de telemetria são enviados

const uint8_t u8_IP_LENGTH = 46;

const uint8_t u8_ACCEPTABLE_DELAY = 240;

const uint8_t u8_FIBRA_MODE = 0x46; // ascii F

const uint8_t u8_RADIO_MODE = 0x52; // ascii R

const uint8_t u8_CUSTOM_MODE = 0x43; // ascii C

class ConfigManager
{
    private :
        char chHeader_ip[ u8_IP_LENGTH ];
        uint16_t u16Ext;
        uint16_t u16Port;
        char chServer_ip[ u8_IP_LENGTH ];
        uint16_t u16Server_ext;
        uint16_t u16Server_port;
        char chNet_mask[ u8_IP_LENGTH ];
        char chGateway[ u8_IP_LENGTH ];
        char chFw_server_ip[ u8_IP_LENGTH ];
        uint16_t u16Fw_server_port;
        uint16_t u16Max_ext;
        uint16_t u16Min_ext;
        uint16_t u16Shift_port;
        uint16_t u16Udp_port_listener;
        uint16_t u16Tcp_port_listener;
        bool boolModified;
        bool boolHeader_ip_was_modified;
        bool boolServer_ip_was_modified;
        bool boolNet_mask_was_modified;
        bool boolGateway_was_modified;
        bool boolFw_server_ip_was_modified;
        bool boolHeader_ext_was_modified;
        bool boolHeader_sip_port_was_modified;
        bool boolServer_ext_was_modified;
        bool boolServer_port_was_modified;
        bool boolFw_server_port_was_modified;
        bool boolMax_ext_was_modified;
        bool boolMin_ext_was_modified;
        bool boolShift_port_was_modified;
        bool boolCallBoxDetachMode;
        bool boolCallBoxWakeMode;
        uint8_t u8CallBoxMode;
        char chClock_erver_ip [ u8_IP_LENGTH ];
        uint8_t u8Acceptable_delay;
        
        void cbx_custom_mode_check ( void );

    public  :
        ConfigManager ( void );
        ~ConfigManager ( void );

        char * get_header_ip ( char * buffer );
        char * get_server_ip ( char * buffer );
        char * get_net_mask ( char * buffer );
        char * get_gateway ( char * buffer );
        char * get_fw_server_ip ( char * buffer );
        char * get_clock_server_ip ( char * buffer );

        uint8_t get_acceptable_delay ( void );
        uint16_t get_ext ( void );
        uint16_t get_port ( void );
        uint16_t get_server_ext ( void );
        uint16_t get_server_port ( void );
        uint16_t get_fw_server_port ( void );
        uint16_t get_max_ext ( void );
        uint16_t get_min_ext ( void );
        uint16_t get_shift_port ( void );
        uint16_t get_udp_port_listener ( void );
        uint16_t get_tcp_port_listener ( void );
        bool was_modified ( void );
        
        bool header_ip_was_modified ( void );
        bool server_ip_was_modified ( void );
        bool net_mask_was_modified ( void );
        bool gateway_was_modified ( void );
        bool fw_server_ip_was_modified ( void );
        bool header_ext_was_modified ( void );
        bool header_sip_port_was_modified ( void );
        bool server_ext_was_modified ( void );
        bool server_port_was_modified ( void );
        bool fw_server_port_was_modified ( void );
        bool max_ext_was_modified ( void );
        bool min_ext_was_modified ( void );
        bool shift_port_was_modified ( void );
        bool get_cbx_detach_mode ( void );
        bool get_cbx_wake_mode ( void );
        uint8_t get_cbx_mode ( void );
        
        void set_header_ip ( const char * new_header_ip );
        void set_server_ip ( const char * new_server_ip );
        void set_net_mask ( const char * new_net_mask );
        void set_gateway ( const char * new_gateway );
        void set_fw_server_ip ( const char * new_fw_server_ip );
        void set_header_ext ( const uint16_t new_ext );
        void set_header_sip_port ( const uint16_t new_port );
        void set_server_ext ( const uint16_t new_server_ext );
        void set_server_port ( const uint16_t new_server_port );
        void set_fw_server_port ( const uint16_t new_fw_server_port );
        void set_max_ext ( const uint16_t new_max_ext );
        void set_min_ext ( const uint16_t new_min_ext );
        void set_shift_port ( const uint16_t new_shift_port );
        void set_udp_port_listener ( const uint16_t new_udp_port_listener );
        void set_tcp_port_listener ( const uint16_t new_tcp_port_listener );
        void set_modified_true ( void );
        void set_modified_false ( void );
        void set_acceptable_delay ( const uint8_t new_acceptable_delay );
        void set_cbx_detach_mode ( const bool new_cbx_detach_mode );
        void set_cbx_wake_mode ( const bool new_cbx_wake_mode );
        void set_cbx_mode ( const uint8_t new_cbx_mode );
        
        void restore_defaults_settings ( void );
};

%: endif